/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.codec.decoders.primitives;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.codec.DecodeException;
import com.rabbitmq.qpid.protonj2.codec.DecoderState;
import com.rabbitmq.qpid.protonj2.codec.StreamDecoderState;
import com.rabbitmq.qpid.protonj2.codec.decoders.AbstractPrimitiveTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.ProtonStreamUtils;
import java.io.InputStream;

public final class ShortTypeDecoder
extends AbstractPrimitiveTypeDecoder<Short> {
    @Override
    public boolean isJavaPrimitive() {
        return true;
    }

    @Override
    public Class<Short> getTypeClass() {
        return Short.class;
    }

    @Override
    public int getTypeCode() {
        return 97;
    }

    @Override
    public Short readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        return buffer.readShort();
    }

    @Override
    public Short readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        return ProtonStreamUtils.readShort(stream);
    }

    public short readPrimitiveValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        return buffer.readShort();
    }

    public short readPrimitiveValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        return ProtonStreamUtils.readShort(stream);
    }

    @Override
    public void skipValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        buffer.advanceReadOffset(2);
    }

    @Override
    public void skipValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        ProtonStreamUtils.skipBytes(stream, 2L);
    }

    @Override
    public int readSize(ProtonBuffer buffer, DecoderState state) {
        return 2;
    }

    @Override
    public int readSize(InputStream stream, StreamDecoderState state) {
        return 2;
    }
}

