/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.codec.decoders.transport;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.codec.DecodeException;
import com.rabbitmq.qpid.protonj2.codec.Decoder;
import com.rabbitmq.qpid.protonj2.codec.DecoderState;
import com.rabbitmq.qpid.protonj2.codec.StreamDecoder;
import com.rabbitmq.qpid.protonj2.codec.StreamDecoderState;
import com.rabbitmq.qpid.protonj2.codec.StreamTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.AbstractDescribedListTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.ProtonStreamUtils;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.ListTypeDecoder;
import com.rabbitmq.qpid.protonj2.types.Symbol;
import com.rabbitmq.qpid.protonj2.types.UnsignedLong;
import com.rabbitmq.qpid.protonj2.types.transport.Open;
import java.io.InputStream;

public final class OpenTypeDecoder
extends AbstractDescribedListTypeDecoder<Open> {
    private static final int MIN_OPEN_LIST_ENTRIES = 1;
    private static final int MAX_OPEN_LIST_ENTRIES = 10;

    @Override
    public Class<Open> getTypeClass() {
        return Open.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return Open.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Open.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Open readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        return this.readOpen(buffer, state.getDecoder(), state, (ListTypeDecoder)OpenTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Open[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        Open[] result = new Open[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readOpen(buffer, state.getDecoder(), state, (ListTypeDecoder)OpenTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    private Open readOpen(ProtonBuffer buffer, Decoder decoder, DecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Open open = new Open();
        int size = listDecoder.readSize(buffer, state);
        int count = listDecoder.readCount(buffer, state);
        if (count < 1) {
            throw new DecodeException("The container-id field cannot be omitted from the Open");
        }
        if (count > 10) {
            throw new DecodeException("To many entries in Open list encoding: " + count);
        }
        block12: for (int index = 0; index < count; ++index) {
            if (buffer.getByte(buffer.getReadOffset()) == 64) {
                if (index == 0) {
                    throw new DecodeException("The container-id field cannot be omitted from the Open");
                }
                buffer.advanceReadOffset(1);
                continue;
            }
            switch (index) {
                case 0: {
                    open.setContainerId(decoder.readString(buffer, state));
                    continue block12;
                }
                case 1: {
                    open.setHostname(decoder.readString(buffer, state));
                    continue block12;
                }
                case 2: {
                    open.setMaxFrameSize(decoder.readUnsignedInteger(buffer, state, 0L));
                    continue block12;
                }
                case 3: {
                    open.setChannelMax(decoder.readUnsignedShort(buffer, state, 0));
                    continue block12;
                }
                case 4: {
                    open.setIdleTimeout(decoder.readUnsignedInteger(buffer, state, 0L));
                    continue block12;
                }
                case 5: {
                    open.setOutgoingLocales(decoder.readMultiple(buffer, state, Symbol.class));
                    continue block12;
                }
                case 6: {
                    open.setIncomingLocales(decoder.readMultiple(buffer, state, Symbol.class));
                    continue block12;
                }
                case 7: {
                    open.setOfferedCapabilities(decoder.readMultiple(buffer, state, Symbol.class));
                    continue block12;
                }
                case 8: {
                    open.setDesiredCapabilities(decoder.readMultiple(buffer, state, Symbol.class));
                    continue block12;
                }
                case 9: {
                    open.setProperties(decoder.readMap(buffer, state));
                }
            }
        }
        return open;
    }

    @Override
    public Open readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        return this.readOpen(stream, state.getDecoder(), state, (ListTypeDecoder)OpenTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Open[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        Open[] result = new Open[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readOpen(stream, state.getDecoder(), state, (ListTypeDecoder)OpenTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    private Open readOpen(InputStream stream, StreamDecoder decoder, StreamDecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Open open = new Open();
        int size = listDecoder.readSize(stream, state);
        int count = listDecoder.readCount(stream, state);
        if (count < 1) {
            throw new DecodeException("The container-id field cannot be omitted from the Open");
        }
        if (count > 10) {
            throw new DecodeException("To many entries in Open list encoding: " + count);
        }
        block12: for (int index = 0; index < count; ++index) {
            if (stream.markSupported()) {
                boolean nullValue;
                stream.mark(1);
                boolean bl = nullValue = ProtonStreamUtils.readByte(stream) == 64;
                if (nullValue) {
                    if (index != 0) continue;
                    throw new DecodeException("The container-id field cannot be omitted from the Open");
                }
                ProtonStreamUtils.reset(stream);
            }
            switch (index) {
                case 0: {
                    open.setContainerId(decoder.readString(stream, state));
                    continue block12;
                }
                case 1: {
                    open.setHostname(decoder.readString(stream, state));
                    continue block12;
                }
                case 2: {
                    open.setMaxFrameSize(decoder.readUnsignedInteger(stream, state, 0L));
                    continue block12;
                }
                case 3: {
                    open.setChannelMax(decoder.readUnsignedShort(stream, state, 0));
                    continue block12;
                }
                case 4: {
                    open.setIdleTimeout(decoder.readUnsignedInteger(stream, state, 0L));
                    continue block12;
                }
                case 5: {
                    open.setOutgoingLocales(decoder.readMultiple(stream, state, Symbol.class));
                    continue block12;
                }
                case 6: {
                    open.setIncomingLocales(decoder.readMultiple(stream, state, Symbol.class));
                    continue block12;
                }
                case 7: {
                    open.setOfferedCapabilities(decoder.readMultiple(stream, state, Symbol.class));
                    continue block12;
                }
                case 8: {
                    open.setDesiredCapabilities(decoder.readMultiple(stream, state, Symbol.class));
                    continue block12;
                }
                case 9: {
                    open.setProperties(decoder.readMap(stream, state));
                }
            }
        }
        return open;
    }
}

