/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.codec.decoders.transport;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.codec.DecodeException;
import com.rabbitmq.qpid.protonj2.codec.Decoder;
import com.rabbitmq.qpid.protonj2.codec.DecoderState;
import com.rabbitmq.qpid.protonj2.codec.StreamDecoder;
import com.rabbitmq.qpid.protonj2.codec.StreamDecoderState;
import com.rabbitmq.qpid.protonj2.codec.StreamTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.AbstractDescribedListTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.ProtonStreamUtils;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.ListTypeDecoder;
import com.rabbitmq.qpid.protonj2.types.Symbol;
import com.rabbitmq.qpid.protonj2.types.UnsignedByte;
import com.rabbitmq.qpid.protonj2.types.UnsignedLong;
import com.rabbitmq.qpid.protonj2.types.transport.DeliveryState;
import com.rabbitmq.qpid.protonj2.types.transport.ReceiverSettleMode;
import com.rabbitmq.qpid.protonj2.types.transport.Transfer;
import java.io.InputStream;

public final class TransferTypeDecoder
extends AbstractDescribedListTypeDecoder<Transfer> {
    private static final int MIN_TRANSFER_LIST_ENTRIES = 1;
    private static final int MAX_TRANSFER_LIST_ENTRIES = 11;

    @Override
    public Class<Transfer> getTypeClass() {
        return Transfer.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return Transfer.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Transfer.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Transfer readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        return this.readTransfer(buffer, state.getDecoder(), state, (ListTypeDecoder)TransferTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Transfer[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        Transfer[] result = new Transfer[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readTransfer(buffer, state.getDecoder(), state, (ListTypeDecoder)TransferTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    private Transfer readTransfer(ProtonBuffer buffer, Decoder decoder, DecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Transfer transfer = new Transfer();
        int size = listDecoder.readSize(buffer, state);
        int count = listDecoder.readCount(buffer, state);
        if (count < 1) {
            throw new DecodeException("The handle field cannot be omitted");
        }
        if (count > 11) {
            throw new DecodeException("To many entries in Transfer list encoding: " + count);
        }
        block13: for (int index = 0; index < count; ++index) {
            if (buffer.getByte(buffer.getReadOffset()) == 64) {
                if (index == 0) {
                    throw new DecodeException("The handle field cannot be omitted from the Transfer");
                }
                buffer.advanceReadOffset(1);
                continue;
            }
            switch (index) {
                case 0: {
                    transfer.setHandle(decoder.readUnsignedInteger(buffer, state, 0L));
                    continue block13;
                }
                case 1: {
                    transfer.setDeliveryId(decoder.readUnsignedInteger(buffer, state, 0L));
                    continue block13;
                }
                case 2: {
                    transfer.setDeliveryTag(decoder.readDeliveryTag(buffer, state));
                    continue block13;
                }
                case 3: {
                    transfer.setMessageFormat(decoder.readUnsignedInteger(buffer, state, 0L));
                    continue block13;
                }
                case 4: {
                    transfer.setSettled(decoder.readBoolean(buffer, state, false));
                    continue block13;
                }
                case 5: {
                    transfer.setMore(decoder.readBoolean(buffer, state, false));
                    continue block13;
                }
                case 6: {
                    UnsignedByte rcvSettleMode = decoder.readUnsignedByte(buffer, state);
                    transfer.setRcvSettleMode(rcvSettleMode == null ? null : ReceiverSettleMode.values()[rcvSettleMode.intValue()]);
                    continue block13;
                }
                case 7: {
                    transfer.setState(decoder.readObject(buffer, state, DeliveryState.class));
                    continue block13;
                }
                case 8: {
                    transfer.setResume(decoder.readBoolean(buffer, state, false));
                    continue block13;
                }
                case 9: {
                    transfer.setAborted(decoder.readBoolean(buffer, state, false));
                    continue block13;
                }
                case 10: {
                    transfer.setBatchable(decoder.readBoolean(buffer, state, false));
                }
            }
        }
        return transfer;
    }

    @Override
    public Transfer readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        return this.readTransfer(stream, state.getDecoder(), state, (ListTypeDecoder)TransferTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Transfer[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        Transfer[] result = new Transfer[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readTransfer(stream, state.getDecoder(), state, (ListTypeDecoder)TransferTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    private Transfer readTransfer(InputStream stream, StreamDecoder decoder, StreamDecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Transfer transfer = new Transfer();
        int size = listDecoder.readSize(stream, state);
        int count = listDecoder.readCount(stream, state);
        if (count < 1) {
            throw new DecodeException("The handle field cannot be omitted");
        }
        if (count > 11) {
            throw new DecodeException("To many entries in Transfer list encoding: " + count);
        }
        block13: for (int index = 0; index < count; ++index) {
            if (stream.markSupported()) {
                boolean nullValue;
                stream.mark(1);
                boolean bl = nullValue = ProtonStreamUtils.readByte(stream) == 64;
                if (nullValue) {
                    if (index != 0) continue;
                    throw new DecodeException("The handle field cannot be omitted from the Transfer");
                }
                ProtonStreamUtils.reset(stream);
            }
            switch (index) {
                case 0: {
                    transfer.setHandle(decoder.readUnsignedInteger(stream, state, 0L));
                    continue block13;
                }
                case 1: {
                    transfer.setDeliveryId(decoder.readUnsignedInteger(stream, state, 0L));
                    continue block13;
                }
                case 2: {
                    transfer.setDeliveryTag(decoder.readDeliveryTag(stream, state));
                    continue block13;
                }
                case 3: {
                    transfer.setMessageFormat(decoder.readUnsignedInteger(stream, state, 0L));
                    continue block13;
                }
                case 4: {
                    transfer.setSettled(decoder.readBoolean(stream, state, false));
                    continue block13;
                }
                case 5: {
                    transfer.setMore(decoder.readBoolean(stream, state, false));
                    continue block13;
                }
                case 6: {
                    UnsignedByte rcvSettleMode = decoder.readUnsignedByte(stream, state);
                    transfer.setRcvSettleMode(rcvSettleMode == null ? null : ReceiverSettleMode.values()[rcvSettleMode.intValue()]);
                    continue block13;
                }
                case 7: {
                    transfer.setState(decoder.readObject(stream, state, DeliveryState.class));
                    continue block13;
                }
                case 8: {
                    transfer.setResume(decoder.readBoolean(stream, state, false));
                    continue block13;
                }
                case 9: {
                    transfer.setAborted(decoder.readBoolean(stream, state, false));
                    continue block13;
                }
                case 10: {
                    transfer.setBatchable(decoder.readBoolean(stream, state, false));
                }
            }
        }
        return transfer;
    }
}

