/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.engine.impl;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.codec.CodecFactory;
import com.rabbitmq.qpid.protonj2.codec.EncodeException;
import com.rabbitmq.qpid.protonj2.codec.Encoder;
import com.rabbitmq.qpid.protonj2.codec.EncoderState;
import com.rabbitmq.qpid.protonj2.codec.PerformativeEncoder;
import com.rabbitmq.qpid.protonj2.engine.EngineHandler;
import com.rabbitmq.qpid.protonj2.engine.EngineHandlerContext;
import com.rabbitmq.qpid.protonj2.engine.HeaderEnvelope;
import com.rabbitmq.qpid.protonj2.engine.OutgoingAMQPEnvelope;
import com.rabbitmq.qpid.protonj2.engine.SASLEnvelope;
import com.rabbitmq.qpid.protonj2.engine.exceptions.FrameEncodingException;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonEngine;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonEngineConfiguration;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonEngineHandlerContext;
import com.rabbitmq.qpid.protonj2.types.transport.AMQPHeader;
import com.rabbitmq.qpid.protonj2.types.transport.Performative;

public class ProtonFrameEncodingHandler
implements EngineHandler {
    public static final byte AMQP_FRAME_TYPE = 0;
    public static final byte SASL_FRAME_TYPE = 1;
    private static final int AMQP_PERFORMATIVE_PAD = 128;
    private static final int FRAME_HEADER_SIZE = 8;
    private static final byte FRAME_DOFF_SIZE = 2;
    private static final int FRAME_START_BYTE = 0;
    private static final int FRAME_DOFF_BYTE = 4;
    private static final int FRAME_HEADER_PREFIX = 0x2000000;
    private static final byte[] SASL_FRAME_HEADER = new byte[]{0, 0, 0, 0, 2, 1, 0, 0};
    private final Encoder saslEncoder = CodecFactory.getSaslEncoder();
    private final EncoderState saslEncoderState = this.saslEncoder.newEncoderState();
    private final Encoder amqpEncoder = CodecFactory.getEncoder();
    private PerformativeEncoder encoder;
    private ProtonEngine engine;
    private ProtonEngineConfiguration configuration;

    @Override
    public void handlerAdded(EngineHandlerContext context) {
        this.engine = (ProtonEngine)context.engine();
        this.configuration = this.engine.configuration();
        ((ProtonEngineHandlerContext)context).interestMask(4);
    }

    @Override
    public void engineStarting(EngineHandlerContext context) {
        this.encoder = new PerformativeEncoder(this.amqpEncoder);
    }

    @Override
    public void handleWrite(EngineHandlerContext context, HeaderEnvelope envelope) {
        context.fireWrite(((AMQPHeader)envelope.getBody()).getBuffer(), null);
    }

    @Override
    public void handleWrite(EngineHandlerContext context, SASLEnvelope envelope) {
        ProtonBuffer output = this.configuration.getBufferAllocator().outputBuffer(128).implicitGrowthLimit((int)this.configuration.getOutboundMaxFrameSize());
        output.writeBytes(SASL_FRAME_HEADER);
        try {
            this.saslEncoder.writeObject(output, this.saslEncoderState, envelope.getBody());
        }
        catch (EncodeException ex) {
            throw new FrameEncodingException(ex);
        }
        finally {
            this.saslEncoderState.reset();
        }
        context.fireWrite(output.setInt(0, output.getReadableBytes()), null);
    }

    @Override
    public void handleWrite(EngineHandlerContext context, OutgoingAMQPEnvelope envelope) {
        if (envelope.getPayload() == null) {
            this.writePerformativeWithNoPayload(context, envelope);
        } else {
            this.writePerformativeWithPayload(context, envelope);
        }
    }

    private void writePerformativeWithNoPayload(EngineHandlerContext context, OutgoingAMQPEnvelope envelope) {
        int maxFrameSize = (int)this.configuration.getOutboundMaxFrameSize();
        int estimatedCapacity = Math.min(maxFrameSize, 128);
        ProtonBuffer output = this.configuration.getBufferAllocator().outputBuffer(estimatedCapacity).implicitGrowthLimit(maxFrameSize);
        ProtonFrameEncodingHandler.writePerformative(output, this.encoder, envelope.getChannel(), (Performative)envelope.getBody());
        output.setInt(0, output.getReadableBytes());
        output.setInt(4, 0x2000000 | envelope.getChannel());
        output.convertToReadOnly();
        context.fireWrite(output, envelope::handleOutgoingFrameWriteComplete);
    }

    private void writePerformativeWithPayload(EngineHandlerContext context, OutgoingAMQPEnvelope envelope) {
        int maxFrameSize = (int)this.configuration.getOutboundMaxFrameSize();
        ProtonBuffer payload = envelope.getPayload();
        int estimatedCapacity = Math.min(maxFrameSize, 128 + payload.getReadableBytes());
        ProtonBuffer output = this.configuration.getBufferAllocator().outputBuffer(estimatedCapacity).implicitGrowthLimit(maxFrameSize);
        ProtonFrameEncodingHandler.writePerformative(output, this.encoder, envelope.getChannel(), (Performative)envelope.getBody());
        int remainingBytes = maxFrameSize - output.getWriteOffset();
        if (payload.getReadableBytes() > remainingBytes) {
            envelope.handlePayloadToLarge();
            ProtonFrameEncodingHandler.writePerformative(output, this.encoder, envelope.getChannel(), (Performative)envelope.getBody());
            remainingBytes = maxFrameSize - output.getWriteOffset();
            output.ensureWritable(remainingBytes);
            payload.copyInto(payload.getReadOffset(), output, output.getWriteOffset(), remainingBytes);
            output.advanceWriteOffset(remainingBytes);
            payload.advanceReadOffset(remainingBytes);
        } else {
            output.writeBytes(payload);
        }
        output.setInt(0, output.getReadableBytes());
        output.setInt(4, 0x2000000 | envelope.getChannel());
        output.convertToReadOnly();
        context.fireWrite(output, envelope::handleOutgoingFrameWriteComplete);
    }

    private static void writePerformative(ProtonBuffer target, PerformativeEncoder encoder, int channel, Performative performative) {
        target.setWriteOffset(8);
        try {
            performative.invoke(encoder, target, channel, encoder.getEncoder());
        }
        catch (EncodeException ex) {
            throw new FrameEncodingException(ex);
        }
    }
}

