/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.engine.impl;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.engine.EventHandler;
import com.rabbitmq.qpid.protonj2.engine.IncomingDelivery;
import com.rabbitmq.qpid.protonj2.engine.LinkCreditState;
import com.rabbitmq.qpid.protonj2.engine.Receiver;
import com.rabbitmq.qpid.protonj2.engine.exceptions.ProtocolViolationException;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonIncomingDelivery;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonLink;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonLinkCreditState;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonOutgoingDelivery;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonSession;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonSessionIncomingWindow;
import com.rabbitmq.qpid.protonj2.engine.util.DeliveryIdTracker;
import com.rabbitmq.qpid.protonj2.engine.util.UnsettledMap;
import com.rabbitmq.qpid.protonj2.types.transport.Attach;
import com.rabbitmq.qpid.protonj2.types.transport.DeliveryState;
import com.rabbitmq.qpid.protonj2.types.transport.Detach;
import com.rabbitmq.qpid.protonj2.types.transport.Disposition;
import com.rabbitmq.qpid.protonj2.types.transport.Flow;
import com.rabbitmq.qpid.protonj2.types.transport.Role;
import com.rabbitmq.qpid.protonj2.types.transport.Transfer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ProtonReceiver
extends ProtonLink<Receiver>
implements Receiver {
    private EventHandler<IncomingDelivery> deliveryReadEventHandler = null;
    private EventHandler<IncomingDelivery> deliveryAbortedEventHandler = null;
    private EventHandler<IncomingDelivery> deliveryUpdatedEventHandler = null;
    private EventHandler<Receiver> linkCreditUpdatedHandler = null;
    private final ProtonSessionIncomingWindow sessionWindow;
    private final DeliveryIdTracker currentDeliveryId = new DeliveryIdTracker();
    private final UnsettledMap<ProtonIncomingDelivery> unsettled = new UnsettledMap<ProtonIncomingDelivery>(ProtonIncomingDelivery::getDeliveryIdInt);
    private DeliveryState defaultDeliveryState;
    private LinkCreditState drainStateSnapshot;

    public ProtonReceiver(ProtonSession session, String name) {
        super(session, name, new ProtonLinkCreditState());
        this.sessionWindow = session.getIncomingWindow();
    }

    @Override
    public ProtonReceiver setDefaultDeliveryState(DeliveryState state) {
        this.defaultDeliveryState = state;
        return this;
    }

    @Override
    public DeliveryState getDefaultDeliveryState() {
        return this.defaultDeliveryState;
    }

    @Override
    public Role getRole() {
        return Role.RECEIVER;
    }

    @Override
    protected ProtonReceiver self() {
        return this;
    }

    @Override
    public int getCredit() {
        return this.getCreditState().getCredit();
    }

    @Override
    public ProtonReceiver addCredit(int credit) {
        this.checkLinkOperable("Cannot add credit");
        if (credit < 0) {
            throw new IllegalArgumentException("additional credits cannot be less than zero");
        }
        if (credit > 0) {
            this.getCreditState().incrementCredit(credit);
            if (this.isLocallyOpen() && this.wasLocalAttachSent()) {
                this.sessionWindow.writeFlow(this);
            }
        }
        return this;
    }

    @Override
    public boolean drain() {
        this.checkLinkOperable("Cannot drain Receiver");
        if (this.drainStateSnapshot != null) {
            throw new IllegalStateException("Drain attempt already outstanding");
        }
        if (this.getCredit() > 0) {
            this.drainStateSnapshot = this.getCreditState().snapshot();
            if (this.isLocallyOpen() && this.wasLocalAttachSent()) {
                this.sessionWindow.writeFlow(this);
            }
        }
        return this.isDraining();
    }

    @Override
    public boolean drain(int credits) {
        this.checkLinkOperable("Cannot drain Receiver");
        if (this.drainStateSnapshot != null) {
            throw new IllegalStateException("Drain attempt already outstanding");
        }
        int currentCredit = this.getCredit();
        if (credits < 0) {
            throw new IllegalArgumentException("Cannot drain negative link credit");
        }
        if (credits < currentCredit) {
            throw new IllegalArgumentException("Cannot drain partial link credit");
        }
        this.getCreditState().incrementCredit(credits - currentCredit);
        if (this.getCredit() > 0) {
            this.drainStateSnapshot = this.getCreditState().snapshot();
            if (this.isLocallyOpen() && this.wasLocalAttachSent()) {
                this.sessionWindow.writeFlow(this);
            }
        }
        return this.isDraining();
    }

    @Override
    public boolean isDraining() {
        return this.drainStateSnapshot != null;
    }

    @Override
    public Receiver disposition(Predicate<IncomingDelivery> filter, DeliveryState disposition, boolean settle) {
        this.checkLinkOperable("Cannot apply disposition");
        Objects.requireNonNull(filter, "Supplied filter cannot be null");
        List toRemove = settle ? new ArrayList() : Collections.EMPTY_LIST;
        this.unsettled.forEach((deliveryId, delivery) -> {
            if (filter.test((IncomingDelivery)delivery)) {
                if (disposition != null) {
                    delivery.localState(disposition);
                }
                if (settle) {
                    delivery.locallySettled();
                    toRemove.add(deliveryId);
                }
                this.sessionWindow.processDisposition(this, (ProtonIncomingDelivery)delivery);
            }
        });
        if (!toRemove.isEmpty()) {
            toRemove.forEach(deliveryId -> this.unsettled.remove(deliveryId));
        }
        return this;
    }

    @Override
    public Receiver settle(Predicate<IncomingDelivery> filter) {
        return this.disposition(filter, null, true);
    }

    @Override
    public Collection<IncomingDelivery> unsettled() {
        if (this.unsettled.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(new ArrayList<ProtonIncomingDelivery>(this.unsettled.values()));
    }

    @Override
    public boolean hasUnsettled() {
        return !this.unsettled.isEmpty();
    }

    void disposition(ProtonIncomingDelivery delivery) {
        if (!delivery.isRemotelySettled()) {
            this.checkLinkOperable("Cannot set a disposition for delivery");
        }
        try {
            this.sessionWindow.processDisposition(this, delivery);
        }
        finally {
            if (delivery.isSettled()) {
                this.unsettled.remove((int)delivery.getDeliveryId());
                if (delivery.getTag() != null) {
                    delivery.getTag().release();
                }
            }
        }
    }

    void deliveryRead(ProtonIncomingDelivery delivery, int bytesRead) {
        if (this.areDeliveriesStillActive()) {
            this.sessionWindow.deliveryRead(delivery, bytesRead);
        }
    }

    @Override
    public Receiver deliveryReadHandler(EventHandler<IncomingDelivery> handler) {
        this.deliveryReadEventHandler = handler;
        return this;
    }

    Receiver signalDeliveryRead(ProtonIncomingDelivery delivery) {
        if (delivery.deliveryReadHandler() != null) {
            delivery.deliveryReadHandler().handle(delivery);
        } else if (this.deliveryReadEventHandler != null) {
            this.deliveryReadEventHandler.handle(delivery);
        }
        if (this.session.deliveryReadHandler() != null) {
            this.session.deliveryReadHandler().handle(delivery);
        }
        return this;
    }

    @Override
    public Receiver deliveryAbortedHandler(EventHandler<IncomingDelivery> handler) {
        this.deliveryAbortedEventHandler = handler;
        return this;
    }

    Receiver signalDeliveryAborted(ProtonIncomingDelivery delivery) {
        if (delivery.deliveryAbortedHandler() != null) {
            delivery.deliveryAbortedHandler().handle(delivery);
        } else if (delivery.deliveryReadHandler() != null) {
            delivery.deliveryReadHandler().handle(delivery);
        } else if (this.deliveryAbortedEventHandler != null) {
            this.deliveryAbortedEventHandler.handle(delivery);
        } else if (this.deliveryReadEventHandler != null) {
            this.deliveryReadEventHandler.handle(delivery);
        }
        return this;
    }

    @Override
    public Receiver deliveryStateUpdatedHandler(EventHandler<IncomingDelivery> handler) {
        this.deliveryUpdatedEventHandler = handler;
        return this;
    }

    Receiver signalDeliveryStateUpdated(ProtonIncomingDelivery delivery) {
        if (delivery.deliveryStateUpdatedHandler() != null) {
            delivery.deliveryStateUpdatedHandler().handle(delivery);
        } else if (this.deliveryUpdatedEventHandler != null) {
            this.deliveryUpdatedEventHandler.handle(delivery);
        }
        return this;
    }

    @Override
    public Receiver creditStateUpdateHandler(EventHandler<Receiver> handler) {
        this.linkCreditUpdatedHandler = handler;
        return this;
    }

    Receiver signalLinkCreditStateUpdated() {
        if (this.linkCreditUpdatedHandler != null) {
            this.linkCreditUpdatedHandler.handle(this);
        }
        return this;
    }

    @Override
    protected final ProtonReceiver handleRemoteAttach(Attach attach) {
        if (!attach.hasInitialDeliveryCount()) {
            throw new ProtocolViolationException("Sending peer attach had no initial delivery count");
        }
        this.getCreditState().initializeDeliveryCount((int)attach.getInitialDeliveryCount());
        return this;
    }

    @Override
    protected final ProtonReceiver handleRemoteDetach(Detach detach) {
        return this;
    }

    @Override
    protected final ProtonReceiver handleRemoteFlow(Flow flow) {
        ProtonLinkCreditState creditState = this.getCreditState();
        creditState.remoteFlow(flow);
        if (flow.getDrain()) {
            creditState.updateDeliveryCount((int)flow.getDeliveryCount());
            creditState.updateCredit((int)flow.getLinkCredit());
            if (creditState.getCredit() != 0) {
                throw new IllegalArgumentException("Receiver read flow with drain set but credit was not zero");
            }
            this.drainStateSnapshot = null;
        }
        this.signalLinkCreditStateUpdated();
        return this;
    }

    @Override
    protected final ProtonReceiver handleRemoteDisposition(Disposition disposition, ProtonIncomingDelivery delivery) {
        boolean updated = false;
        if (disposition.getState() != null && !disposition.getState().equals(delivery.getRemoteState())) {
            updated = true;
            delivery.remoteState(disposition.getState());
        }
        if (disposition.getSettled() && !delivery.isRemotelySettled()) {
            updated = true;
            delivery.remotelySettled();
        }
        if (updated) {
            this.signalDeliveryStateUpdated(delivery);
        }
        return this;
    }

    @Override
    protected final ProtonReceiver handleRemoteDisposition(Disposition disposition, ProtonOutgoingDelivery delivery) {
        throw new IllegalStateException("Receiver link should never handle dispositions for outgoing deliveries");
    }

    @Override
    protected final ProtonIncomingDelivery handleRemoteTransfer(Transfer transfer, ProtonBuffer payload) {
        boolean done;
        ProtonIncomingDelivery delivery;
        if (!(this.currentDeliveryId.isEmpty() || transfer.hasDeliveryId() && !this.currentDeliveryId.equals((int)transfer.getDeliveryId()))) {
            delivery = this.unsettled.get(this.currentDeliveryId.intValue());
        } else {
            this.verifyNewDeliveryIdSequence(transfer, this.currentDeliveryId);
            delivery = new ProtonIncomingDelivery(this, transfer.getDeliveryId(), transfer.getDeliveryTag());
            delivery.setMessageFormat((int)transfer.getMessageFormat());
            this.unsettled.put((int)transfer.getDeliveryId(), delivery);
            this.currentDeliveryId.set((int)transfer.getDeliveryId());
        }
        if (transfer.hasState()) {
            delivery.remoteState(transfer.getState());
        }
        if (transfer.getSettled() || transfer.getAborted()) {
            delivery.remotelySettled();
        }
        if (payload != null) {
            delivery.appendTransferPayload(payload);
        }
        boolean bl = done = transfer.getAborted() || !transfer.getMore();
        if (done) {
            this.getCreditState().decrementCredit();
            this.getCreditState().incrementDeliveryCount();
            this.currentDeliveryId.reset();
            if (transfer.getAborted()) {
                delivery.aborted();
            } else {
                delivery.completed();
            }
        }
        if (transfer.getAborted()) {
            this.signalDeliveryAborted(delivery);
        } else {
            this.signalDeliveryRead(delivery);
        }
        if (this.isDraining() && this.getCredit() == 0) {
            this.drainStateSnapshot = null;
            this.signalLinkCreditStateUpdated();
        }
        return delivery;
    }

    @Override
    protected ProtonReceiver decorateOutgoingFlow(Flow flow) {
        flow.setLinkCredit(this.getCredit());
        flow.setHandle(this.getHandle());
        if (this.getCreditState().isDeliveryCountInitialized()) {
            flow.setDeliveryCount(this.getCreditState().getDeliveryCount());
        }
        flow.setDrain(this.isDraining());
        if (this.getCreditState().isEcho()) {
            flow.setEcho(true);
        }
        return this;
    }

    private void verifyNewDeliveryIdSequence(Transfer transfer, DeliveryIdTracker currentDeliveryId) {
        if (!transfer.hasDeliveryId()) {
            this.getEngine().engineFailed(new ProtocolViolationException("No delivery-id specified on first Transfer of new delivery"));
        }
        this.sessionWindow.validateNextDeliveryId(transfer.getDeliveryId());
        if (!currentDeliveryId.isEmpty()) {
            this.getEngine().engineFailed(new ProtocolViolationException("Illegal multiplex of deliveries on same link with delivery-id " + currentDeliveryId + " and " + transfer.getDeliveryId()));
        }
    }

    public ProtonSessionIncomingWindow sessionWindow() {
        return this.sessionWindow;
    }

    public EventHandler<Receiver> linkCreditUpdatedHandler() {
        return this.linkCreditUpdatedHandler;
    }
}

