/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.engine.impl;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.engine.exceptions.ProtocolViolationException;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonEngine;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonIncomingDelivery;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonLink;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonReceiver;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonSession;
import com.rabbitmq.qpid.protonj2.engine.util.SequenceNumber;
import com.rabbitmq.qpid.protonj2.engine.util.UnsettledMap;
import com.rabbitmq.qpid.protonj2.types.UnsignedInteger;
import com.rabbitmq.qpid.protonj2.types.transport.Begin;
import com.rabbitmq.qpid.protonj2.types.transport.Disposition;
import com.rabbitmq.qpid.protonj2.types.transport.Flow;
import com.rabbitmq.qpid.protonj2.types.transport.Role;
import com.rabbitmq.qpid.protonj2.types.transport.Transfer;

public class ProtonSessionIncomingWindow {
    private static final int DEFAULT_WINDOW_SIZE = Integer.MAX_VALUE;
    private final ProtonSession session;
    private final ProtonEngine engine;
    private int incomingCapacity = 0;
    private int incomingWindow = 0;
    private int nextIncomingId = 0;
    private SequenceNumber lastDeliveryid;
    private int maxFrameSize;
    private int incomingBytes;
    private UnsettledMap<ProtonIncomingDelivery> unsettled = new UnsettledMap<ProtonIncomingDelivery>(ProtonIncomingDelivery::getDeliveryIdInt);
    private final Disposition cachedDisposition = new Disposition();

    public ProtonSessionIncomingWindow(ProtonSession session) {
        this.session = session;
        this.engine = session.getConnection().getEngine();
        this.maxFrameSize = (int)session.getConnection().getMaxFrameSize();
    }

    public void setIncomingCapacity(int incomingCapacity) {
        this.incomingCapacity = incomingCapacity;
    }

    public int getIncomingCapacity() {
        return this.incomingCapacity;
    }

    public int getRemainingIncomingCapacity() {
        if (this.incomingCapacity <= 0 || this.maxFrameSize == UnsignedInteger.MAX_VALUE.intValue()) {
            return Integer.MAX_VALUE;
        }
        return this.incomingCapacity - this.incomingBytes;
    }

    Begin configureOutbound(Begin begin) {
        this.maxFrameSize = (int)this.session.getConnection().getMaxFrameSize();
        return begin.setIncomingWindow(this.updateIncomingWindow());
    }

    Begin handleBegin(Begin begin) {
        if (begin.hasNextOutgoingId()) {
            this.nextIncomingId = UnsignedInteger.valueOf(begin.getNextOutgoingId()).intValue();
        }
        return begin;
    }

    Flow handleFlow(Flow flow) {
        return flow;
    }

    Transfer handleTransfer(ProtonLink<?> link, Transfer transfer, ProtonBuffer payload) {
        this.incomingBytes += payload != null ? payload.getReadableBytes() : 0;
        --this.incomingWindow;
        ++this.nextIncomingId;
        ProtonIncomingDelivery delivery = link.remoteTransfer(transfer, payload);
        if (!delivery.isSettled() && !delivery.isRemotelySettled() && delivery.isFirstTransfer()) {
            this.unsettled.put((int)delivery.getDeliveryId(), delivery);
        }
        return transfer;
    }

    Disposition handleDisposition(Disposition disposition) {
        int first = (int)disposition.getFirst();
        if (disposition.hasLast() && disposition.getLast() != (long)first) {
            ProtonSessionIncomingWindow.handleRangedDisposition(this.unsettled, disposition);
        } else {
            ProtonIncomingDelivery delivery;
            ProtonIncomingDelivery protonIncomingDelivery = delivery = disposition.getSettled() ? this.unsettled.remove(first) : this.unsettled.get(first);
            if (delivery != null) {
                delivery.getLink().remoteDisposition(disposition, delivery);
            }
        }
        return disposition;
    }

    private static void handleRangedDisposition(UnsettledMap<ProtonIncomingDelivery> unsettled, Disposition disposition) {
        if (disposition.getSettled()) {
            unsettled.removeEach((int)disposition.getFirst(), (int)disposition.getLast(), delivery -> delivery.getLink().remoteDisposition(disposition, (ProtonIncomingDelivery)delivery));
        } else {
            unsettled.forEach((int)disposition.getFirst(), (int)disposition.getLast(), delivery -> delivery.getLink().remoteDisposition(disposition, (ProtonIncomingDelivery)delivery));
        }
    }

    long updateIncomingWindow() {
        this.incomingWindow = this.incomingCapacity <= 0 || (long)this.maxFrameSize == UnsignedInteger.MAX_VALUE.longValue() ? Integer.MAX_VALUE : Integer.divideUnsigned(this.incomingCapacity - this.incomingBytes, this.maxFrameSize);
        return this.incomingWindow;
    }

    public void writeFlow(ProtonReceiver link) {
        this.updateIncomingWindow();
        this.session.writeFlow(link);
    }

    public long getIncomingBytes() {
        return Integer.toUnsignedLong(this.incomingBytes);
    }

    public int getNextIncomingId() {
        return this.nextIncomingId;
    }

    public int getIncomingWindow() {
        return this.incomingWindow;
    }

    void processDisposition(ProtonReceiver receiver, ProtonIncomingDelivery delivery) {
        if (!delivery.isRemotelySettled()) {
            if (delivery.isSettled()) {
                this.unsettled.remove((int)delivery.getDeliveryId());
            }
            this.cachedDisposition.reset();
            this.cachedDisposition.setFirst(delivery.getDeliveryId());
            this.cachedDisposition.setRole(Role.RECEIVER);
            this.cachedDisposition.setSettled(delivery.isSettled());
            this.cachedDisposition.setState(delivery.getState());
            this.engine.fireWrite(this.cachedDisposition, this.session.getLocalChannel());
        }
    }

    void deliveryRead(ProtonIncomingDelivery delivery, int bytesRead) {
        this.incomingBytes -= bytesRead;
        if (this.incomingWindow == 0) {
            this.writeFlow(delivery.getLink());
        }
    }

    void validateNextDeliveryId(long deliveryId) {
        if (this.lastDeliveryid == null) {
            this.lastDeliveryid = new SequenceNumber((int)deliveryId);
        } else if (this.lastDeliveryid.increment().compareTo((int)deliveryId) != 0) {
            this.session.getConnection().getEngine().engineFailed(new ProtocolViolationException("Expected delivery-id " + this.lastDeliveryid + ", got " + deliveryId));
        }
    }
}

