/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.engine.impl;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.buffer.ProtonBufferAllocator;
import com.rabbitmq.qpid.protonj2.buffer.ProtonBufferUtils;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonDeliveryTagGenerator;
import com.rabbitmq.qpid.protonj2.types.DeliveryTag;
import java.util.UUID;

public class ProtonUuidTagGenerator
extends ProtonDeliveryTagGenerator {
    @Override
    public DeliveryTag nextTag() {
        return new ProtonUuidDeliveryTag(UUID.randomUUID());
    }

    private static final class ProtonUuidDeliveryTag
    implements DeliveryTag {
        private static final int BYTES = 16;
        private final UUID tagValue;

        public ProtonUuidDeliveryTag(UUID tagValue) {
            this.tagValue = tagValue;
        }

        @Override
        public int tagLength() {
            return 16;
        }

        @Override
        public byte[] tagBytes() {
            byte[] tagView = new byte[16];
            ProtonBufferUtils.writeLong(this.tagValue.getMostSignificantBits(), tagView, 0);
            ProtonBufferUtils.writeLong(this.tagValue.getLeastSignificantBits(), tagView, 8);
            return tagView;
        }

        @Override
        public ProtonBuffer tagBuffer() {
            return ProtonBufferAllocator.defaultAllocator().copy(this.tagBytes()).convertToReadOnly();
        }

        @Override
        public DeliveryTag copy() {
            return new ProtonUuidDeliveryTag(this.tagValue);
        }

        @Override
        public void writeTo(ProtonBuffer buffer) {
            buffer.writeLong(this.tagValue.getMostSignificantBits());
            buffer.writeLong(this.tagValue.getLeastSignificantBits());
        }

        public int hashCode() {
            return this.tagValue.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.tagValue.equals(((ProtonUuidDeliveryTag)obj).tagValue);
        }

        public String toString() {
            return this.tagValue.toString();
        }
    }
}

