/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.engine.sasl.client;

import com.rabbitmq.qpid.protonj2.engine.sasl.client.AnonymousMechanism;
import com.rabbitmq.qpid.protonj2.engine.sasl.client.CramMD5Mechanism;
import com.rabbitmq.qpid.protonj2.engine.sasl.client.ExternalMechanism;
import com.rabbitmq.qpid.protonj2.engine.sasl.client.Mechanism;
import com.rabbitmq.qpid.protonj2.engine.sasl.client.PlainMechanism;
import com.rabbitmq.qpid.protonj2.engine.sasl.client.ScramSHA1Mechanism;
import com.rabbitmq.qpid.protonj2.engine.sasl.client.ScramSHA256Mechanism;
import com.rabbitmq.qpid.protonj2.engine.sasl.client.ScramSHA512Mechanism;
import com.rabbitmq.qpid.protonj2.engine.sasl.client.XOauth2Mechanism;
import com.rabbitmq.qpid.protonj2.types.Symbol;

public enum SaslMechanisms {
    EXTERNAL{
        private final Mechanism INSTANCE = new ExternalMechanism();

        @Override
        public Symbol getName() {
            return ExternalMechanism.EXTERNAL;
        }

        @Override
        public Mechanism createMechanism() {
            return this.INSTANCE;
        }
    }
    ,
    SCRAM_SHA_512{

        @Override
        public Symbol getName() {
            return ScramSHA512Mechanism.SCRAM_SHA_512;
        }

        @Override
        public Mechanism createMechanism() {
            return new ScramSHA512Mechanism();
        }
    }
    ,
    SCRAM_SHA_256{

        @Override
        public Symbol getName() {
            return ScramSHA256Mechanism.SCRAM_SHA_256;
        }

        @Override
        public Mechanism createMechanism() {
            return new ScramSHA256Mechanism();
        }
    }
    ,
    SCRAM_SHA_1{

        @Override
        public Symbol getName() {
            return ScramSHA1Mechanism.SCRAM_SHA_1;
        }

        @Override
        public Mechanism createMechanism() {
            return new ScramSHA1Mechanism();
        }
    }
    ,
    CRAM_MD5{

        @Override
        public Symbol getName() {
            return CramMD5Mechanism.CRAM_MD5;
        }

        @Override
        public Mechanism createMechanism() {
            return new CramMD5Mechanism();
        }
    }
    ,
    PLAIN{
        private final Mechanism INSTANCE = new PlainMechanism();

        @Override
        public Symbol getName() {
            return PlainMechanism.PLAIN;
        }

        @Override
        public Mechanism createMechanism() {
            return this.INSTANCE;
        }
    }
    ,
    XOAUTH2{

        @Override
        public Symbol getName() {
            return XOauth2Mechanism.XOAUTH2;
        }

        @Override
        public Mechanism createMechanism() {
            return new XOauth2Mechanism();
        }
    }
    ,
    ANONYMOUS{
        private final Mechanism INSTANCE = new AnonymousMechanism();

        @Override
        public Symbol getName() {
            return AnonymousMechanism.ANONYMOUS;
        }

        @Override
        public Mechanism createMechanism() {
            return this.INSTANCE;
        }
    };


    public abstract Symbol getName();

    public abstract Mechanism createMechanism();

    public static SaslMechanisms valueOf(Symbol mechanism) {
        for (SaslMechanisms value : SaslMechanisms.values()) {
            if (!value.getName().equals(mechanism)) continue;
            return value;
        }
        throw new IllegalArgumentException("No Matching SASL Mechanism with name: " + mechanism);
    }

    public static boolean validate(String mechanism) {
        for (SaslMechanisms supported : SaslMechanisms.values()) {
            if (!supported.getName().toString().equals(mechanism.toUpperCase())) continue;
            return true;
        }
        return false;
    }
}

