/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.types;

import java.math.BigInteger;

public final class UnsignedLong
extends Number
implements Comparable<UnsignedLong> {
    private static final long serialVersionUID = -5901821450224443596L;
    private static final BigInteger TWO_TO_THE_SIXTY_FOUR = new BigInteger(new byte[]{1, 0, 0, 0, 0, 0, 0, 0, 0});
    private static final BigInteger LONG_MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    private static final UnsignedLong[] cachedValues = new UnsignedLong[256];
    public static final UnsignedLong ZERO;
    public static final UnsignedLong ONE;
    public static final UnsignedLong MAX_VALUE;
    private final long underlying;

    public UnsignedLong(long underlying) {
        this.underlying = underlying;
    }

    @Override
    public int intValue() {
        return (int)this.underlying;
    }

    @Override
    public long longValue() {
        return this.underlying;
    }

    public BigInteger bigIntegerValue() {
        if (this.underlying >= 0L) {
            return BigInteger.valueOf(this.underlying);
        }
        return TWO_TO_THE_SIXTY_FOUR.add(BigInteger.valueOf(this.underlying));
    }

    @Override
    public float floatValue() {
        return this.longValue();
    }

    @Override
    public double doubleValue() {
        return this.longValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnsignedLong that = (UnsignedLong)o;
        return this.underlying == that.underlying;
    }

    @Override
    public int compareTo(long value) {
        return Long.compareUnsigned(this.underlying, value);
    }

    @Override
    public int compareTo(UnsignedLong o) {
        return this.bigIntegerValue().compareTo(o.bigIntegerValue());
    }

    public static int compare(long left, long right) {
        return Long.compareUnsigned(left, right);
    }

    public int hashCode() {
        return (int)(this.underlying ^ this.underlying >>> 32);
    }

    public String toString() {
        return String.valueOf(this.bigIntegerValue());
    }

    public static UnsignedLong valueOf(long value) {
        if ((value & 0xFFL) == value) {
            return cachedValues[(int)value];
        }
        return new UnsignedLong(value);
    }

    public static UnsignedLong valueOf(String value) {
        BigInteger bigInt = new BigInteger(value);
        return UnsignedLong.valueOf(bigInt);
    }

    public static UnsignedLong valueOf(BigInteger value) {
        if (value.signum() == -1 || value.bitLength() > 64) {
            throw new NumberFormatException("Value \"" + value + "\" lies outside the range [0 - 2^64).");
        }
        if (value.compareTo(LONG_MAX_VALUE) >= 0) {
            return UnsignedLong.valueOf(value.longValue());
        }
        return UnsignedLong.valueOf(TWO_TO_THE_SIXTY_FOUR.subtract(value).negate().longValue());
    }

    static {
        for (int i = 0; i < 256; ++i) {
            UnsignedLong.cachedValues[i] = new UnsignedLong(i);
        }
        ZERO = cachedValues[0];
        ONE = cachedValues[1];
        MAX_VALUE = new UnsignedLong(-1L);
    }
}

