/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.types.transport;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.types.Symbol;
import com.rabbitmq.qpid.protonj2.types.UnsignedInteger;
import com.rabbitmq.qpid.protonj2.types.UnsignedLong;
import com.rabbitmq.qpid.protonj2.types.UnsignedShort;
import com.rabbitmq.qpid.protonj2.types.transport.Performative;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Open
implements Performative {
    public static final UnsignedLong DESCRIPTOR_CODE = UnsignedLong.valueOf(16L);
    public static final Symbol DESCRIPTOR_SYMBOL = Symbol.valueOf("amqp:open:list");
    private static final long UINT_MAX = 0xFFFFFFFFL;
    private static final int CONTAINER_ID = 1;
    private static final int HOSTNAME = 2;
    private static final int MAX_FRAME_SIZE = 4;
    private static final int CHANNEL_MAX = 8;
    private static final int IDLE_TIMEOUT = 16;
    private static final int OUTGOING_LOCALES = 32;
    private static final int INCOMING_LOCALES = 64;
    private static final int OFFERED_CAPABILITIES = 128;
    private static final int DESIRED_CAPABILITIES = 256;
    private static final int PROPERTIES = 512;
    private int modified = 1;
    private String containerId = "";
    private String hostname;
    private long maxFrameSize = UnsignedInteger.MAX_VALUE.longValue();
    private int channelMax = UnsignedShort.MAX_VALUE.intValue();
    private long idleTimeout;
    private Symbol[] outgoingLocales;
    private Symbol[] incomingLocales;
    private Symbol[] offeredCapabilities;
    private Symbol[] desiredCapabilities;
    private Map<Symbol, Object> properties;

    @Override
    public Open copy() {
        Open copy = new Open();
        copy.setContainerId(this.containerId);
        if (this.hasHostname()) {
            copy.setHostname(this.hostname);
        }
        if (this.hasMaxFrameSize()) {
            copy.setMaxFrameSize(this.maxFrameSize);
        }
        if (this.hasChannelMax()) {
            copy.setChannelMax(this.channelMax);
        }
        if (this.hasIdleTimeout()) {
            copy.setIdleTimeout(this.idleTimeout);
        }
        if (this.hasOutgoingLocales()) {
            copy.setOutgoingLocales(Arrays.copyOf(this.outgoingLocales, this.outgoingLocales.length));
        }
        if (this.hasIncomingLocales()) {
            copy.setIncomingLocales(Arrays.copyOf(this.incomingLocales, this.incomingLocales.length));
        }
        if (this.hasOfferedCapabilities()) {
            copy.setOfferedCapabilities(Arrays.copyOf(this.offeredCapabilities, this.offeredCapabilities.length));
        }
        if (this.hasDesiredCapabilities()) {
            copy.setOfferedCapabilities(Arrays.copyOf(this.desiredCapabilities, this.desiredCapabilities.length));
        }
        if (this.hasProperties()) {
            copy.setProperties(new LinkedHashMap<Symbol, Object>(this.properties));
        }
        return copy;
    }

    public boolean isEmpty() {
        return this.modified == 0;
    }

    public int getElementCount() {
        return 32 - Integer.numberOfLeadingZeros(this.modified);
    }

    public boolean hasElement(int index) {
        int value = 1 << index;
        return (this.modified & value) == value;
    }

    public boolean hasContainerId() {
        return (this.modified & 1) == 1;
    }

    public boolean hasHostname() {
        return (this.modified & 2) == 2;
    }

    public boolean hasMaxFrameSize() {
        return (this.modified & 4) == 4;
    }

    public boolean hasChannelMax() {
        return (this.modified & 8) == 8;
    }

    public boolean hasIdleTimeout() {
        return (this.modified & 0x10) == 16;
    }

    public boolean hasOutgoingLocales() {
        return (this.modified & 0x20) == 32;
    }

    public boolean hasIncomingLocales() {
        return (this.modified & 0x40) == 64;
    }

    public boolean hasOfferedCapabilities() {
        return (this.modified & 0x80) == 128;
    }

    public boolean hasDesiredCapabilities() {
        return (this.modified & 0x100) == 256;
    }

    public boolean hasProperties() {
        return (this.modified & 0x200) == 512;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public Open setContainerId(String containerId) {
        if (containerId == null) {
            throw new NullPointerException("the container-id field is mandatory");
        }
        this.modified |= 1;
        this.containerId = containerId;
        return this;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Open setHostname(String hostname) {
        this.modified = hostname == null ? (this.modified &= 0xFFFFFFFD) : (this.modified |= 2);
        this.hostname = hostname;
        return this;
    }

    public long getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public Open setMaxFrameSize(int maxFrameSize) {
        this.modified |= 4;
        this.maxFrameSize = Integer.toUnsignedLong(maxFrameSize);
        return this;
    }

    public Open setMaxFrameSize(long maxFrameSize) {
        if (maxFrameSize < 0L || maxFrameSize > 0xFFFFFFFFL) {
            throw new IllegalArgumentException(String.format("Given max frame size value %d larger than this implementations limit of %d", maxFrameSize, Integer.MAX_VALUE));
        }
        this.modified |= 4;
        this.maxFrameSize = maxFrameSize;
        return this;
    }

    public int getChannelMax() {
        return this.channelMax;
    }

    public Open setChannelMax(short channelMax) {
        this.modified |= 8;
        this.channelMax = Short.toUnsignedInt(channelMax);
        return this;
    }

    public Open setChannelMax(int channelMax) {
        if (channelMax < 0 || channelMax > UnsignedShort.MAX_VALUE.intValue()) {
            throw new IllegalArgumentException("The Channel Max value given is out of range: " + channelMax);
        }
        this.modified |= 8;
        this.channelMax = channelMax;
        return this;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public Open setIdleTimeout(int idleTimeout) {
        this.modified |= 0x10;
        this.idleTimeout = Integer.toUnsignedLong(idleTimeout);
        return this;
    }

    public Open setIdleTimeout(long idleTimeout) {
        if (idleTimeout < 0L || idleTimeout > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("The Idle Timeout value given is out of range: " + idleTimeout);
        }
        this.modified |= 0x10;
        this.idleTimeout = idleTimeout;
        return this;
    }

    public Symbol[] getOutgoingLocales() {
        return this.outgoingLocales;
    }

    public Open setOutgoingLocales(Symbol ... outgoingLocales) {
        this.modified = outgoingLocales != null ? (this.modified |= 0x20) : (this.modified &= 0xFFFFFFDF);
        this.outgoingLocales = outgoingLocales;
        return this;
    }

    public Symbol[] getIncomingLocales() {
        return this.incomingLocales;
    }

    public Open setIncomingLocales(Symbol ... incomingLocales) {
        this.modified = incomingLocales != null ? (this.modified |= 0x40) : (this.modified &= 0xFFFFFFBF);
        this.incomingLocales = incomingLocales;
        return this;
    }

    public Symbol[] getOfferedCapabilities() {
        return this.offeredCapabilities;
    }

    public Open setOfferedCapabilities(Symbol ... offeredCapabilities) {
        this.modified = offeredCapabilities != null ? (this.modified |= 0x80) : (this.modified &= 0xFFFFFF7F);
        this.offeredCapabilities = offeredCapabilities;
        return this;
    }

    public Symbol[] getDesiredCapabilities() {
        return this.desiredCapabilities;
    }

    public Open setDesiredCapabilities(Symbol ... desiredCapabilities) {
        this.modified = desiredCapabilities != null ? (this.modified |= 0x100) : (this.modified &= 0xFFFFFEFF);
        this.desiredCapabilities = desiredCapabilities;
        return this;
    }

    public Map<Symbol, Object> getProperties() {
        return this.properties;
    }

    public Open setProperties(Map<Symbol, Object> properties) {
        this.modified = properties != null ? (this.modified |= 0x200) : (this.modified &= 0xFFFFFDFF);
        this.properties = properties;
        return this;
    }

    @Override
    public Performative.PerformativeType getPerformativeType() {
        return Performative.PerformativeType.OPEN;
    }

    @Override
    public <E> void invoke(Performative.PerformativeHandler<E> handler, ProtonBuffer payload, int channel, E context) {
        handler.handleOpen(this, payload, channel, context);
    }

    public String toString() {
        return "Open{ containerId='" + this.containerId + "', hostname='" + this.hostname + "', maxFrameSize=" + (Serializable)(this.hasMaxFrameSize() ? Long.valueOf(this.maxFrameSize) : "null") + ", channelMax=" + (Serializable)(this.hasChannelMax() ? Integer.valueOf(this.channelMax) : "null") + ", idleTimeOut=" + (Serializable)(this.hasIdleTimeout() ? Long.valueOf(this.idleTimeout) : "null") + ", outgoingLocales=" + (this.outgoingLocales == null ? "null" : Arrays.asList(this.outgoingLocales)) + ", incomingLocales=" + (this.incomingLocales == null ? "null" : Arrays.asList(this.incomingLocales)) + ", offeredCapabilities=" + (this.offeredCapabilities == null ? "null" : Arrays.asList(this.offeredCapabilities)) + ", desiredCapabilities=" + (this.desiredCapabilities == null ? "null" : Arrays.asList(this.desiredCapabilities)) + ", properties=" + this.properties + "}";
    }
}

