/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.impl;

import com.rabbitmq.client.amqp.Management;
import com.rabbitmq.client.amqp.impl.AmqpManagement;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;

class AmqpExchangeSpecification
implements Management.ExchangeSpecification {
    private static final boolean DURABLE = true;
    private static final boolean INTERNAL = false;
    private final AmqpManagement management;
    private String name;
    private String type = Management.ExchangeType.DIRECT.name().toLowerCase(Locale.ENGLISH);
    private boolean autoDelete = false;
    private final Map<String, Object> arguments = new LinkedHashMap<String, Object>();

    AmqpExchangeSpecification(AmqpManagement management) {
        this.management = management;
    }

    @Override
    public Management.ExchangeSpecification name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public Management.ExchangeSpecification autoDelete(boolean autoDelete) {
        this.autoDelete = autoDelete;
        return this;
    }

    @Override
    public Management.ExchangeSpecification type(Management.ExchangeType type) {
        this.type = type == null ? null : type.name().toLowerCase(Locale.ENGLISH);
        return this;
    }

    @Override
    public Management.ExchangeSpecification type(String type) {
        this.type = type;
        return this;
    }

    @Override
    public Management.ExchangeSpecification argument(String key, Object value) {
        this.arguments.put(key, value);
        return this;
    }

    @Override
    public void declare() {
        LinkedHashMap<String, Object> body = new LinkedHashMap<String, Object>();
        body.put("type", this.type);
        body.put("durable", true);
        body.put("auto_delete", this.autoDelete);
        body.put("internal", false);
        body.put("arguments", this.arguments);
        this.management.declareExchange(this.name, body);
        this.management.recovery().exchangeDeclared(this);
    }

    String name() {
        return this.name;
    }

    String type() {
        return this.type;
    }

    boolean autoDelete() {
        return this.autoDelete;
    }

    void arguments(BiConsumer<String, Object> consumer) {
        this.arguments.forEach(consumer);
    }
}

