/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.impl;

import com.rabbitmq.client.amqp.impl.AmqpBindingManagement;
import com.rabbitmq.client.amqp.impl.AmqpExchangeSpecification;
import com.rabbitmq.client.amqp.impl.AmqpQueueSpecification;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

interface TopologyListener {
    public static final TopologyListener NO_OP = new NoOpTopologyListener();

    public void exchangeDeclared(AmqpExchangeSpecification var1);

    public void exchangeDeleted(String var1);

    public void queueDeclared(AmqpQueueSpecification var1);

    public void queueDeleted(String var1);

    public void bindingDeclared(AmqpBindingManagement.AmqpBindingSpecification var1);

    public void bindingDeleted(AmqpBindingManagement.AmqpUnbindSpecification var1);

    public void consumerCreated(long var1, String var3);

    public void consumerDeleted(long var1, String var3);

    public static TopologyListener compose(List<TopologyListener> listeners) {
        return new CompositeTopologyListener(listeners);
    }

    public static class CompositeTopologyListener
    implements TopologyListener,
    AutoCloseable {
        private static final Logger LOGGER = LoggerFactory.getLogger(CompositeTopologyListener.class);
        private final List<TopologyListener> listeners;

        public CompositeTopologyListener(List<TopologyListener> listeners) {
            this.listeners = new CopyOnWriteArrayList<TopologyListener>(listeners);
        }

        @Override
        public void exchangeDeclared(AmqpExchangeSpecification specification) {
            this.listeners.forEach(mr -> mr.exchangeDeclared(specification));
        }

        @Override
        public void exchangeDeleted(String name) {
            this.listeners.forEach(mr -> mr.exchangeDeleted(name));
        }

        @Override
        public void queueDeclared(AmqpQueueSpecification specification) {
            this.listeners.forEach(mr -> mr.queueDeclared(specification));
        }

        @Override
        public void queueDeleted(String name) {
            this.listeners.forEach(mr -> mr.queueDeleted(name));
        }

        @Override
        public void bindingDeclared(AmqpBindingManagement.AmqpBindingSpecification specification) {
            this.listeners.forEach(mr -> mr.bindingDeclared(specification));
        }

        @Override
        public void bindingDeleted(AmqpBindingManagement.AmqpUnbindSpecification specification) {
            this.listeners.forEach(mr -> mr.bindingDeleted(specification));
        }

        @Override
        public void consumerCreated(long id, String queue) {
            this.listeners.forEach(mr -> mr.consumerCreated(id, queue));
        }

        @Override
        public void consumerDeleted(long id, String queue) {
            this.listeners.forEach(mr -> mr.consumerDeleted(id, queue));
        }

        @Override
        public void close() throws Exception {
            for (TopologyListener listener : this.listeners) {
                if (!(listener instanceof AutoCloseable)) continue;
                try {
                    ((AutoCloseable)((Object)listener)).close();
                }
                catch (Exception e) {
                    LOGGER.info("Error while closing topology listener", (Throwable)e);
                }
            }
        }
    }

    public static class NoOpTopologyListener
    implements TopologyListener {
        @Override
        public void exchangeDeclared(AmqpExchangeSpecification specification) {
        }

        @Override
        public void exchangeDeleted(String name) {
        }

        @Override
        public void queueDeclared(AmqpQueueSpecification specification) {
        }

        @Override
        public void queueDeleted(String name) {
        }

        @Override
        public void bindingDeclared(AmqpBindingManagement.AmqpBindingSpecification specification) {
        }

        @Override
        public void bindingDeleted(AmqpBindingManagement.AmqpUnbindSpecification specification) {
        }

        @Override
        public void consumerCreated(long id, String queue) {
        }

        @Override
        public void consumerDeleted(long id, String queue) {
        }
    }
}

