/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.client.impl;

import com.rabbitmq.qpid.protonj2.client.DeliveryState;
import com.rabbitmq.qpid.protonj2.client.StreamSender;
import com.rabbitmq.qpid.protonj2.client.StreamTracker;
import com.rabbitmq.qpid.protonj2.client.exceptions.ClientException;
import com.rabbitmq.qpid.protonj2.client.futures.ClientFutureFactory;
import com.rabbitmq.qpid.protonj2.client.impl.ClientDeliveryState;
import com.rabbitmq.qpid.protonj2.client.impl.ClientStreamSender;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public final class ClientNoOpStreamTracker
implements StreamTracker {
    private final ClientStreamSender sender;
    private DeliveryState state;
    private boolean settled;

    ClientNoOpStreamTracker(ClientStreamSender sender) {
        this.sender = sender;
    }

    @Override
    public StreamSender sender() {
        return this.sender;
    }

    @Override
    public StreamTracker settle() throws ClientException {
        this.settled = true;
        return this;
    }

    @Override
    public StreamTracker disposition(DeliveryState state, boolean settle) throws ClientException {
        this.state = state;
        this.settled = settle;
        return this;
    }

    @Override
    public StreamTracker awaitSettlement() throws ClientException {
        return this;
    }

    @Override
    public StreamTracker awaitSettlement(long timeout, TimeUnit unit) throws ClientException {
        return this;
    }

    @Override
    public boolean settled() {
        return this.settled;
    }

    @Override
    public DeliveryState state() {
        return this.state;
    }

    @Override
    public DeliveryState remoteState() {
        return ClientDeliveryState.ClientAccepted.getInstance();
    }

    @Override
    public boolean remoteSettled() {
        return true;
    }

    @Override
    public Future<StreamTracker> settlementFuture() {
        return ClientFutureFactory.completedFuture(this);
    }

    @Override
    public StreamTracker awaitAccepted() throws ClientException {
        return this;
    }

    @Override
    public StreamTracker awaitAccepted(long timeout, TimeUnit unit) throws ClientException {
        return this;
    }
}

