/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.client.impl;

import com.rabbitmq.qpid.protonj2.client.LinkOptions;
import com.rabbitmq.qpid.protonj2.client.ReceiverOptions;
import com.rabbitmq.qpid.protonj2.client.SessionOptions;
import com.rabbitmq.qpid.protonj2.client.SourceOptions;
import com.rabbitmq.qpid.protonj2.client.StreamReceiverOptions;
import com.rabbitmq.qpid.protonj2.client.TargetOptions;
import com.rabbitmq.qpid.protonj2.client.exceptions.ClientException;
import com.rabbitmq.qpid.protonj2.client.impl.ClientConstants;
import com.rabbitmq.qpid.protonj2.client.impl.ClientConversionSupport;
import com.rabbitmq.qpid.protonj2.client.impl.ClientDeliveryState;
import com.rabbitmq.qpid.protonj2.client.impl.ClientReceiver;
import com.rabbitmq.qpid.protonj2.client.impl.ClientSession;
import com.rabbitmq.qpid.protonj2.client.impl.ClientStreamReceiver;
import com.rabbitmq.qpid.protonj2.engine.Receiver;
import com.rabbitmq.qpid.protonj2.types.UnsignedInteger;
import com.rabbitmq.qpid.protonj2.types.messaging.Outcome;
import com.rabbitmq.qpid.protonj2.types.messaging.Released;
import com.rabbitmq.qpid.protonj2.types.messaging.Source;
import com.rabbitmq.qpid.protonj2.types.messaging.Target;
import com.rabbitmq.qpid.protonj2.types.messaging.TerminusDurability;
import com.rabbitmq.qpid.protonj2.types.messaging.TerminusExpiryPolicy;
import com.rabbitmq.qpid.protonj2.types.transactions.Coordinator;
import com.rabbitmq.qpid.protonj2.types.transport.ReceiverSettleMode;
import com.rabbitmq.qpid.protonj2.types.transport.SenderSettleMode;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

final class ClientReceiverBuilder {
    private final ClientSession session;
    private final SessionOptions sessionOptions;
    private final AtomicInteger receiverCounter = new AtomicInteger();
    private volatile ReceiverOptions defaultReceiverOptions;
    private volatile StreamReceiverOptions defaultStreamReceiverOptions;

    ClientReceiverBuilder(ClientSession session) {
        this.session = session;
        this.sessionOptions = session.options();
    }

    public ClientReceiver receiver(String address, ReceiverOptions receiverOptions) throws ClientException {
        ReceiverOptions rcvOptions = receiverOptions != null ? receiverOptions : this.getDefaultReceiverOptions();
        String receiverId = this.nextReceiverId();
        Receiver protonReceiver = this.createReceiver(address, rcvOptions, receiverId);
        protonReceiver.setSource(this.createSource(address, rcvOptions));
        protonReceiver.setTarget(this.createTarget(address, rcvOptions));
        return new ClientReceiver(this.session, rcvOptions, receiverId, protonReceiver);
    }

    public ClientReceiver durableReceiver(String address, String subscriptionName, ReceiverOptions receiverOptions) {
        ReceiverOptions options = receiverOptions != null ? receiverOptions : this.getDefaultReceiverOptions();
        String receiverId = this.nextReceiverId();
        options.linkName(subscriptionName);
        Receiver protonReceiver = this.createReceiver(address, options, receiverId);
        protonReceiver.setSource(this.createDurableSource(address, options));
        protonReceiver.setTarget(this.createTarget(address, options));
        return new ClientReceiver(this.session, options, receiverId, protonReceiver);
    }

    public ClientReceiver dynamicReceiver(Map<String, Object> dynamicNodeProperties, ReceiverOptions receiverOptions) throws ClientException {
        ReceiverOptions options = receiverOptions != null ? receiverOptions : this.getDefaultReceiverOptions();
        String receiverId = this.nextReceiverId();
        Receiver protonReceiver = this.createReceiver(null, options, receiverId);
        protonReceiver.setSource(this.createSource(null, options));
        protonReceiver.setTarget(this.createTarget(null, options));
        protonReceiver.getSource().setDynamic(true);
        protonReceiver.getSource().setDynamicNodeProperties(ClientConversionSupport.toSymbolKeyedMap(dynamicNodeProperties));
        return new ClientReceiver(this.session, options, receiverId, protonReceiver);
    }

    public ClientStreamReceiver streamReceiver(String address, StreamReceiverOptions receiverOptions) throws ClientException {
        StreamReceiverOptions options = receiverOptions != null ? receiverOptions : this.getDefaultStreamReceiverOptions();
        String receiverId = this.nextReceiverId();
        Receiver protonReceiver = this.createReceiver(address, options, receiverId);
        protonReceiver.setSource(this.createSource(address, options));
        protonReceiver.setTarget(this.createTarget(address, options));
        return new ClientStreamReceiver(this.session, options, receiverId, protonReceiver);
    }

    public static Receiver recreateReceiver(ClientSession session, Receiver previousReceiver, LinkOptions<?> options) {
        Receiver protonReceiver = session.getProtonSession().receiver(previousReceiver.getName());
        protonReceiver.setSource(previousReceiver.getSource());
        if (previousReceiver.getTarget() instanceof Coordinator) {
            protonReceiver.setTarget((Coordinator)previousReceiver.getTarget());
        } else {
            protonReceiver.setTarget((Target)previousReceiver.getTarget());
        }
        protonReceiver.setSenderSettleMode(previousReceiver.getSenderSettleMode());
        protonReceiver.setReceiverSettleMode(previousReceiver.getReceiverSettleMode());
        protonReceiver.setOfferedCapabilities(ClientConversionSupport.toSymbolArray(options.offeredCapabilities()));
        protonReceiver.setDesiredCapabilities(ClientConversionSupport.toSymbolArray(options.desiredCapabilities()));
        protonReceiver.setProperties(ClientConversionSupport.toSymbolKeyedMap(options.properties()));
        protonReceiver.setDefaultDeliveryState(Released.getInstance());
        return protonReceiver;
    }

    private String nextReceiverId() {
        return this.session.id() + ":" + this.receiverCounter.incrementAndGet();
    }

    private Receiver createReceiver(String address, LinkOptions<?> options, String receiverId) {
        Object linkName = options.linkName() != null ? options.linkName() : "receiver-" + receiverId;
        Receiver protonReceiver = this.session.getProtonSession().receiver((String)linkName);
        switch (options.deliveryMode()) {
            case AT_MOST_ONCE: {
                protonReceiver.setSenderSettleMode(SenderSettleMode.SETTLED);
                protonReceiver.setReceiverSettleMode(ReceiverSettleMode.FIRST);
                break;
            }
            case AT_LEAST_ONCE: {
                protonReceiver.setSenderSettleMode(SenderSettleMode.UNSETTLED);
                protonReceiver.setReceiverSettleMode(ReceiverSettleMode.FIRST);
            }
        }
        protonReceiver.setOfferedCapabilities(ClientConversionSupport.toSymbolArray(options.offeredCapabilities()));
        protonReceiver.setDesiredCapabilities(ClientConversionSupport.toSymbolArray(options.desiredCapabilities()));
        protonReceiver.setProperties(ClientConversionSupport.toSymbolKeyedMap(options.properties()));
        protonReceiver.setDefaultDeliveryState(Released.getInstance());
        return protonReceiver;
    }

    private Source createSource(String address, LinkOptions<?> options) {
        SourceOptions sourceOptions = options.sourceOptions();
        Source source = new Source();
        source.setAddress(address);
        if (sourceOptions.durabilityMode() != null) {
            source.setDurable(ClientConversionSupport.asProtonType(sourceOptions.durabilityMode()));
        } else {
            source.setDurable(TerminusDurability.NONE);
        }
        if (sourceOptions.expiryPolicy() != null) {
            source.setExpiryPolicy(ClientConversionSupport.asProtonType(sourceOptions.expiryPolicy()));
        } else {
            source.setExpiryPolicy(TerminusExpiryPolicy.LINK_DETACH);
        }
        if (sourceOptions.distributionMode() != null) {
            source.setDistributionMode(ClientConversionSupport.asProtonType(sourceOptions.distributionMode()));
        }
        if (sourceOptions.timeout() >= 0L) {
            source.setTimeout(UnsignedInteger.valueOf(sourceOptions.timeout()));
        }
        if (sourceOptions.filters() != null) {
            source.setFilter(ClientConversionSupport.toSymbolKeyedMap(sourceOptions.filters()));
        }
        if (sourceOptions.defaultOutcome() != null) {
            source.setDefaultOutcome((Outcome)((Object)ClientDeliveryState.asProtonType(sourceOptions.defaultOutcome())));
        } else {
            source.setDefaultOutcome((Outcome)((Object)ClientDeliveryState.asProtonType(SourceOptions.DEFAULT_RECEIVER_OUTCOME)));
        }
        source.setOutcomes(ClientConversionSupport.outcomesToSymbols(sourceOptions.outcomes()));
        source.setCapabilities(ClientConversionSupport.toSymbolArray(sourceOptions.capabilities()));
        return source;
    }

    private Source createDurableSource(String address, LinkOptions<?> options) {
        SourceOptions sourceOptions = options.sourceOptions();
        Source source = new Source();
        source.setAddress(address);
        source.setDurable(TerminusDurability.UNSETTLED_STATE);
        source.setExpiryPolicy(TerminusExpiryPolicy.NEVER);
        source.setDistributionMode(ClientConstants.COPY);
        source.setOutcomes(ClientConversionSupport.outcomesToSymbols(sourceOptions.outcomes()));
        source.setDefaultOutcome((Outcome)((Object)ClientDeliveryState.asProtonType(sourceOptions.defaultOutcome())));
        source.setCapabilities(ClientConversionSupport.toSymbolArray(sourceOptions.capabilities()));
        if (sourceOptions.timeout() >= 0L) {
            source.setTimeout(UnsignedInteger.valueOf(sourceOptions.timeout()));
        }
        if (sourceOptions.filters() != null) {
            source.setFilter(ClientConversionSupport.toSymbolKeyedMap(sourceOptions.filters()));
        }
        return source;
    }

    private Target createTarget(String address, LinkOptions<?> options) {
        TargetOptions targetOptions = options.targetOptions();
        Target target = new Target();
        target.setAddress(address);
        target.setCapabilities(ClientConversionSupport.toSymbolArray(targetOptions.capabilities()));
        if (targetOptions.durabilityMode() != null) {
            target.setDurable(ClientConversionSupport.asProtonType(targetOptions.durabilityMode()));
        }
        if (targetOptions.expiryPolicy() != null) {
            target.setExpiryPolicy(ClientConversionSupport.asProtonType(targetOptions.expiryPolicy()));
        }
        if (targetOptions.timeout() >= 0L) {
            target.setTimeout(UnsignedInteger.valueOf(targetOptions.timeout()));
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReceiverOptions getDefaultReceiverOptions() {
        ReceiverOptions receiverOptions = this.defaultReceiverOptions;
        if (receiverOptions == null) {
            ClientReceiverBuilder clientReceiverBuilder = this;
            synchronized (clientReceiverBuilder) {
                receiverOptions = this.defaultReceiverOptions;
                if (receiverOptions == null) {
                    receiverOptions = new ReceiverOptions();
                    receiverOptions.openTimeout(this.sessionOptions.openTimeout());
                    receiverOptions.closeTimeout(this.sessionOptions.closeTimeout());
                    receiverOptions.requestTimeout(this.sessionOptions.requestTimeout());
                    receiverOptions.drainTimeout(this.sessionOptions.drainTimeout());
                }
                this.defaultReceiverOptions = receiverOptions;
            }
        }
        return receiverOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StreamReceiverOptions getDefaultStreamReceiverOptions() {
        StreamReceiverOptions receiverOptions = this.defaultStreamReceiverOptions;
        if (receiverOptions == null) {
            ClientReceiverBuilder clientReceiverBuilder = this;
            synchronized (clientReceiverBuilder) {
                receiverOptions = this.defaultStreamReceiverOptions;
                if (receiverOptions == null) {
                    receiverOptions = new StreamReceiverOptions();
                    receiverOptions.openTimeout(this.sessionOptions.openTimeout());
                    receiverOptions.closeTimeout(this.sessionOptions.closeTimeout());
                    receiverOptions.requestTimeout(this.sessionOptions.requestTimeout());
                    receiverOptions.drainTimeout(this.sessionOptions.drainTimeout());
                }
                this.defaultStreamReceiverOptions = receiverOptions;
            }
        }
        return receiverOptions;
    }
}

