/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.client.impl;

import com.rabbitmq.qpid.protonj2.client.DurabilityMode;
import com.rabbitmq.qpid.protonj2.client.ExpiryPolicy;
import com.rabbitmq.qpid.protonj2.client.Target;
import com.rabbitmq.qpid.protonj2.client.impl.ClientConversionSupport;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

final class ClientRemoteTarget
implements Target {
    private final com.rabbitmq.qpid.protonj2.types.messaging.Target remoteTarget;
    private Map<String, Object> cachedDynamicNodeProperties;
    private Set<String> cachedCapabilities;

    ClientRemoteTarget(com.rabbitmq.qpid.protonj2.types.messaging.Target remoteTarget) {
        this.remoteTarget = remoteTarget;
    }

    @Override
    public String address() {
        return this.remoteTarget.getAddress();
    }

    @Override
    public DurabilityMode durabilityMode() {
        if (this.remoteTarget.getDurable() != null) {
            switch (this.remoteTarget.getDurable()) {
                case NONE: {
                    return DurabilityMode.NONE;
                }
                case CONFIGURATION: {
                    return DurabilityMode.CONFIGURATION;
                }
                case UNSETTLED_STATE: {
                    return DurabilityMode.UNSETTLED_STATE;
                }
            }
        }
        return DurabilityMode.NONE;
    }

    @Override
    public long timeout() {
        return this.remoteTarget.getTimeout() == null ? 0L : this.remoteTarget.getTimeout().longValue();
    }

    @Override
    public ExpiryPolicy expiryPolicy() {
        if (this.remoteTarget.getExpiryPolicy() != null) {
            switch (this.remoteTarget.getExpiryPolicy()) {
                case LINK_DETACH: {
                    return ExpiryPolicy.LINK_CLOSE;
                }
                case SESSION_END: {
                    return ExpiryPolicy.SESSION_CLOSE;
                }
                case CONNECTION_CLOSE: {
                    return ExpiryPolicy.CONNECTION_CLOSE;
                }
                case NEVER: {
                    return ExpiryPolicy.NEVER;
                }
            }
        }
        return ExpiryPolicy.SESSION_CLOSE;
    }

    @Override
    public boolean dynamic() {
        return this.remoteTarget.isDynamic();
    }

    @Override
    public Map<String, Object> dynamicNodeProperties() {
        if (this.cachedDynamicNodeProperties == null && this.remoteTarget.getDynamicNodeProperties() != null) {
            this.cachedDynamicNodeProperties = Collections.unmodifiableMap(ClientConversionSupport.toStringKeyedMap(this.remoteTarget.getDynamicNodeProperties()));
        }
        return this.cachedDynamicNodeProperties;
    }

    @Override
    public Set<String> capabilities() {
        if (this.cachedCapabilities == null && this.remoteTarget.getCapabilities() != null) {
            this.cachedCapabilities = Collections.unmodifiableSet(ClientConversionSupport.toStringSet(this.remoteTarget.getCapabilities()));
        }
        return this.cachedCapabilities;
    }
}

