/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.codec.decoders.messaging;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.codec.DecodeException;
import com.rabbitmq.qpid.protonj2.codec.DecoderState;
import com.rabbitmq.qpid.protonj2.codec.StreamDecoderState;
import com.rabbitmq.qpid.protonj2.codec.StreamTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.AbstractDescribedListTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.ListTypeDecoder;
import com.rabbitmq.qpid.protonj2.types.Symbol;
import com.rabbitmq.qpid.protonj2.types.UnsignedLong;
import com.rabbitmq.qpid.protonj2.types.messaging.Modified;
import java.io.InputStream;

public final class ModifiedTypeDecoder
extends AbstractDescribedListTypeDecoder<Modified> {
    private static final int MIN_MODIFIED_LIST_ENTRIES = 0;
    private static final int MAX_MODIFIED_LIST_ENTRIES = 3;

    @Override
    public Class<Modified> getTypeClass() {
        return Modified.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return Modified.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Modified.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Modified readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        return this.readModified(buffer, state, (ListTypeDecoder)ModifiedTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Modified[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        Modified[] result = new Modified[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readModified(buffer, state, (ListTypeDecoder)ModifiedTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    private Modified readModified(ProtonBuffer buffer, DecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Modified modified = new Modified();
        int size = listDecoder.readSize(buffer, state);
        int count = listDecoder.readCount(buffer, state);
        if (count < 0) {
            throw new DecodeException("Not enough entries in Modified list encoding: " + count);
        }
        if (count > 3) {
            throw new DecodeException("To many entries in Modified list encoding: " + count);
        }
        block5: for (int index = 0; index < count; ++index) {
            switch (index) {
                case 0: {
                    modified.setDeliveryFailed(state.getDecoder().readBoolean(buffer, state, false));
                    continue block5;
                }
                case 1: {
                    modified.setUndeliverableHere(state.getDecoder().readBoolean(buffer, state, false));
                    continue block5;
                }
                case 2: {
                    modified.setMessageAnnotations(state.getDecoder().readMap(buffer, state));
                    continue block5;
                }
                default: {
                    throw new DecodeException("To many entries in Modified encoding");
                }
            }
        }
        return modified;
    }

    @Override
    public Modified readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        ModifiedTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        return this.readModified(stream, state, (ListTypeDecoder)decoder);
    }

    public Modified[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        Modified[] result = new Modified[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readModified(stream, state, (ListTypeDecoder)ModifiedTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    private Modified readModified(InputStream stream, StreamDecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Modified modified = new Modified();
        int size = listDecoder.readSize(stream, state);
        int count = listDecoder.readCount(stream, state);
        if (count < 0) {
            throw new DecodeException("Not enough entries in Modified list encoding: " + count);
        }
        if (count > 3) {
            throw new DecodeException("To many entries in Modified list encoding: " + count);
        }
        block5: for (int index = 0; index < count; ++index) {
            switch (index) {
                case 0: {
                    modified.setDeliveryFailed(state.getDecoder().readBoolean(stream, state, false));
                    continue block5;
                }
                case 1: {
                    modified.setUndeliverableHere(state.getDecoder().readBoolean(stream, state, false));
                    continue block5;
                }
                case 2: {
                    modified.setMessageAnnotations(state.getDecoder().readMap(stream, state));
                    continue block5;
                }
                default: {
                    throw new DecodeException("To many entries in Modified encoding");
                }
            }
        }
        return modified;
    }
}

