/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.codec.decoders.transport;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.codec.DecodeException;
import com.rabbitmq.qpid.protonj2.codec.Decoder;
import com.rabbitmq.qpid.protonj2.codec.DecoderState;
import com.rabbitmq.qpid.protonj2.codec.StreamDecoder;
import com.rabbitmq.qpid.protonj2.codec.StreamDecoderState;
import com.rabbitmq.qpid.protonj2.codec.StreamTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.AbstractDescribedListTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.ProtonStreamUtils;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.ListTypeDecoder;
import com.rabbitmq.qpid.protonj2.types.Symbol;
import com.rabbitmq.qpid.protonj2.types.UnsignedLong;
import com.rabbitmq.qpid.protonj2.types.messaging.Source;
import com.rabbitmq.qpid.protonj2.types.messaging.Terminus;
import com.rabbitmq.qpid.protonj2.types.transport.Attach;
import com.rabbitmq.qpid.protonj2.types.transport.ReceiverSettleMode;
import com.rabbitmq.qpid.protonj2.types.transport.Role;
import com.rabbitmq.qpid.protonj2.types.transport.SenderSettleMode;
import java.io.InputStream;

public final class AttachTypeDecoder
extends AbstractDescribedListTypeDecoder<Attach> {
    private static final int MIN_ATTACH_LIST_ENTRIES = 3;
    private static final int MAX_ATTACH_LIST_ENTRIES = 14;

    @Override
    public Class<Attach> getTypeClass() {
        return Attach.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return Attach.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Attach.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Attach readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        return this.readAttach(buffer, state.getDecoder(), state, (ListTypeDecoder)AttachTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Attach[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        Attach[] result = new Attach[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readAttach(buffer, state.getDecoder(), state, (ListTypeDecoder)AttachTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    private Attach readAttach(ProtonBuffer buffer, Decoder decoder, DecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Attach attach = new Attach();
        int size = listDecoder.readSize(buffer, state);
        int count = listDecoder.readCount(buffer, state);
        if (count < 3) {
            throw new DecodeException(this.errorForMissingRequiredFields(count));
        }
        if (count > 14) {
            throw new DecodeException("To many entries in Attach list encoding: " + count);
        }
        block16: for (int index = 0; index < count; ++index) {
            boolean nullValue;
            boolean bl = nullValue = buffer.getByte(buffer.getReadOffset()) == 64;
            if (nullValue) {
                if (index < 3) {
                    throw new DecodeException(this.errorForMissingRequiredFields(index));
                }
                buffer.advanceReadOffset(1);
                continue;
            }
            switch (index) {
                case 0: {
                    attach.setName(decoder.readString(buffer, state));
                    continue block16;
                }
                case 1: {
                    attach.setHandle(decoder.readUnsignedInteger(buffer, state, 0L));
                    continue block16;
                }
                case 2: {
                    attach.setRole(decoder.readBoolean(buffer, state, false) ? Role.RECEIVER : Role.SENDER);
                    continue block16;
                }
                case 3: {
                    attach.setSenderSettleMode(SenderSettleMode.valueOf(decoder.readUnsignedByte(buffer, state, (byte)2)));
                    continue block16;
                }
                case 4: {
                    attach.setReceiverSettleMode(ReceiverSettleMode.valueOf(decoder.readUnsignedByte(buffer, state, (byte)0)));
                    continue block16;
                }
                case 5: {
                    attach.setSource(decoder.readObject(buffer, state, Source.class));
                    continue block16;
                }
                case 6: {
                    attach.setTarget(decoder.readObject(buffer, state, Terminus.class));
                    continue block16;
                }
                case 7: {
                    attach.setUnsettled(decoder.readMap(buffer, state));
                    continue block16;
                }
                case 8: {
                    attach.setIncompleteUnsettled(decoder.readBoolean(buffer, state, true));
                    continue block16;
                }
                case 9: {
                    attach.setInitialDeliveryCount(decoder.readUnsignedInteger(buffer, state, 0L));
                    continue block16;
                }
                case 10: {
                    attach.setMaxMessageSize(decoder.readUnsignedLong(buffer, state));
                    continue block16;
                }
                case 11: {
                    attach.setOfferedCapabilities(decoder.readMultiple(buffer, state, Symbol.class));
                    continue block16;
                }
                case 12: {
                    attach.setDesiredCapabilities(decoder.readMultiple(buffer, state, Symbol.class));
                    continue block16;
                }
                case 13: {
                    attach.setProperties(decoder.readMap(buffer, state));
                }
            }
        }
        return attach;
    }

    @Override
    public Attach readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        return this.readAttach(stream, state.getDecoder(), state, (ListTypeDecoder)AttachTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Attach[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        Attach[] result = new Attach[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readAttach(stream, state.getDecoder(), state, (ListTypeDecoder)AttachTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    private Attach readAttach(InputStream stream, StreamDecoder decoder, StreamDecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Attach attach = new Attach();
        int size = listDecoder.readSize(stream, state);
        int count = listDecoder.readCount(stream, state);
        if (count < 3) {
            throw new DecodeException(this.errorForMissingRequiredFields(count));
        }
        if (count > 14) {
            throw new DecodeException("To many entries in Attach list encoding: " + count);
        }
        block16: for (int index = 0; index < count; ++index) {
            if (stream.markSupported()) {
                boolean nullValue;
                stream.mark(1);
                boolean bl = nullValue = ProtonStreamUtils.readByte(stream) == 64;
                if (nullValue) {
                    if (index >= 3) continue;
                    throw new DecodeException(this.errorForMissingRequiredFields(index));
                }
                ProtonStreamUtils.reset(stream);
            }
            switch (index) {
                case 0: {
                    attach.setName(decoder.readString(stream, state));
                    continue block16;
                }
                case 1: {
                    attach.setHandle(decoder.readUnsignedInteger(stream, state, 0L));
                    continue block16;
                }
                case 2: {
                    attach.setRole(decoder.readBoolean(stream, state, false) ? Role.RECEIVER : Role.SENDER);
                    continue block16;
                }
                case 3: {
                    attach.setSenderSettleMode(SenderSettleMode.valueOf(decoder.readUnsignedByte(stream, state, (byte)2)));
                    continue block16;
                }
                case 4: {
                    attach.setReceiverSettleMode(ReceiverSettleMode.valueOf(decoder.readUnsignedByte(stream, state, (byte)0)));
                    continue block16;
                }
                case 5: {
                    attach.setSource(decoder.readObject(stream, state, Source.class));
                    continue block16;
                }
                case 6: {
                    attach.setTarget(decoder.readObject(stream, state, Terminus.class));
                    continue block16;
                }
                case 7: {
                    attach.setUnsettled(decoder.readMap(stream, state));
                    continue block16;
                }
                case 8: {
                    attach.setIncompleteUnsettled(decoder.readBoolean(stream, state, true));
                    continue block16;
                }
                case 9: {
                    attach.setInitialDeliveryCount(decoder.readUnsignedInteger(stream, state, 0L));
                    continue block16;
                }
                case 10: {
                    attach.setMaxMessageSize(decoder.readUnsignedLong(stream, state));
                    continue block16;
                }
                case 11: {
                    attach.setOfferedCapabilities(decoder.readMultiple(stream, state, Symbol.class));
                    continue block16;
                }
                case 12: {
                    attach.setDesiredCapabilities(decoder.readMultiple(stream, state, Symbol.class));
                    continue block16;
                }
                case 13: {
                    attach.setProperties(decoder.readMap(stream, state));
                }
            }
        }
        return attach;
    }

    private String errorForMissingRequiredFields(int present) {
        switch (present) {
            case 2: {
                return "The role field cannot be omitted from the Attach";
            }
            case 1: {
                return "The handle field cannot be omitted from the Attach";
            }
        }
        return "The name field cannot be omitted from the Attach";
    }
}

