/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.codec.decoders.transport;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.codec.DecodeException;
import com.rabbitmq.qpid.protonj2.codec.Decoder;
import com.rabbitmq.qpid.protonj2.codec.DecoderState;
import com.rabbitmq.qpid.protonj2.codec.StreamDecoder;
import com.rabbitmq.qpid.protonj2.codec.StreamDecoderState;
import com.rabbitmq.qpid.protonj2.codec.StreamTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.AbstractDescribedListTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.ProtonStreamUtils;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.ListTypeDecoder;
import com.rabbitmq.qpid.protonj2.types.Symbol;
import com.rabbitmq.qpid.protonj2.types.UnsignedLong;
import com.rabbitmq.qpid.protonj2.types.transport.Flow;
import java.io.InputStream;

public final class FlowTypeDecoder
extends AbstractDescribedListTypeDecoder<Flow> {
    private static final int MIN_FLOW_LIST_ENTRIES = 4;
    private static final int MAX_FLOW_LIST_ENTRIES = 11;

    @Override
    public Class<Flow> getTypeClass() {
        return Flow.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return Flow.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Flow.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Flow readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        return this.readFlow(buffer, state.getDecoder(), state, (ListTypeDecoder)FlowTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Flow[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        Flow[] result = new Flow[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readFlow(buffer, state.getDecoder(), state, (ListTypeDecoder)FlowTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    private Flow readFlow(ProtonBuffer buffer, Decoder decoder, DecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Flow flow = new Flow();
        int size = listDecoder.readSize(buffer, state);
        int count = listDecoder.readCount(buffer, state);
        if (count < 4) {
            throw new DecodeException(this.errorForMissingRequiredFields(count));
        }
        if (count > 11) {
            throw new DecodeException("To many entries in Flow list encoding: " + count);
        }
        block13: for (int index = 0; index < count; ++index) {
            if (buffer.getByte(buffer.getReadOffset()) == 64) {
                if (index > 0 && index < 4) {
                    throw new DecodeException(this.errorForMissingRequiredFields(index));
                }
                buffer.advanceReadOffset(1);
                continue;
            }
            switch (index) {
                case 0: {
                    flow.setNextIncomingId(decoder.readUnsignedInteger(buffer, state, 0L));
                    continue block13;
                }
                case 1: {
                    flow.setIncomingWindow(decoder.readUnsignedInteger(buffer, state, 0L));
                    continue block13;
                }
                case 2: {
                    flow.setNextOutgoingId(decoder.readUnsignedInteger(buffer, state, 0L));
                    continue block13;
                }
                case 3: {
                    flow.setOutgoingWindow(decoder.readUnsignedInteger(buffer, state, 0L));
                    continue block13;
                }
                case 4: {
                    flow.setHandle(decoder.readUnsignedInteger(buffer, state, 0L));
                    continue block13;
                }
                case 5: {
                    flow.setDeliveryCount(decoder.readUnsignedInteger(buffer, state, 0L));
                    continue block13;
                }
                case 6: {
                    flow.setLinkCredit(decoder.readUnsignedInteger(buffer, state, 0L));
                    continue block13;
                }
                case 7: {
                    flow.setAvailable(decoder.readUnsignedInteger(buffer, state, 0L));
                    continue block13;
                }
                case 8: {
                    flow.setDrain(decoder.readBoolean(buffer, state, false));
                    continue block13;
                }
                case 9: {
                    flow.setEcho(decoder.readBoolean(buffer, state, false));
                    continue block13;
                }
                case 10: {
                    flow.setProperties(decoder.readMap(buffer, state));
                }
            }
        }
        return flow;
    }

    @Override
    public Flow readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        return this.readFlow(stream, state.getDecoder(), state, (ListTypeDecoder)FlowTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Flow[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        Flow[] result = new Flow[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readFlow(stream, state.getDecoder(), state, (ListTypeDecoder)FlowTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    private Flow readFlow(InputStream stream, StreamDecoder decoder, StreamDecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Flow flow = new Flow();
        int size = listDecoder.readSize(stream, state);
        int count = listDecoder.readCount(stream, state);
        if (count < 4) {
            throw new DecodeException(this.errorForMissingRequiredFields(count));
        }
        if (count > 11) {
            throw new DecodeException("To many entries in Flow list encoding: " + count);
        }
        block13: for (int index = 0; index < count; ++index) {
            if (stream.markSupported()) {
                boolean nullValue;
                stream.mark(1);
                boolean bl = nullValue = ProtonStreamUtils.readByte(stream) == 64;
                if (nullValue) {
                    if (index <= 0 || index >= 4) continue;
                    throw new DecodeException(this.errorForMissingRequiredFields(index));
                }
                ProtonStreamUtils.reset(stream);
            }
            switch (index) {
                case 0: {
                    flow.setNextIncomingId(decoder.readUnsignedInteger(stream, state, 0L));
                    continue block13;
                }
                case 1: {
                    flow.setIncomingWindow(decoder.readUnsignedInteger(stream, state, 0L));
                    continue block13;
                }
                case 2: {
                    flow.setNextOutgoingId(decoder.readUnsignedInteger(stream, state, 0L));
                    continue block13;
                }
                case 3: {
                    flow.setOutgoingWindow(decoder.readUnsignedInteger(stream, state, 0L));
                    continue block13;
                }
                case 4: {
                    flow.setHandle(decoder.readUnsignedInteger(stream, state, 0L));
                    continue block13;
                }
                case 5: {
                    flow.setDeliveryCount(decoder.readUnsignedInteger(stream, state, 0L));
                    continue block13;
                }
                case 6: {
                    flow.setLinkCredit(decoder.readUnsignedInteger(stream, state, 0L));
                    continue block13;
                }
                case 7: {
                    flow.setAvailable(decoder.readUnsignedInteger(stream, state, 0L));
                    continue block13;
                }
                case 8: {
                    flow.setDrain(decoder.readBoolean(stream, state, false));
                    continue block13;
                }
                case 9: {
                    flow.setEcho(decoder.readBoolean(stream, state, false));
                    continue block13;
                }
                case 10: {
                    flow.setProperties(decoder.readMap(stream, state));
                }
            }
        }
        return flow;
    }

    private String errorForMissingRequiredFields(int present) {
        switch (present) {
            case 3: {
                return "The outgoing-window field cannot be omitted from the Flow";
            }
            case 2: {
                return "The next-outgoing-id field cannot be omitted from the Flow";
            }
        }
        return "The incoming-window field cannot be omitted from the Flow";
    }
}

