/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.codec.encoders.primitives;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.codec.EncoderState;
import com.rabbitmq.qpid.protonj2.codec.encoders.AbstractPrimitiveTypeEncoder;

public final class CharacterTypeEncoder
extends AbstractPrimitiveTypeEncoder<Character> {
    @Override
    public Class<Character> getTypeClass() {
        return Character.class;
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, Character value) {
        buffer.writeByte((byte)115);
        buffer.writeInt(value.charValue() & 0xFFFF);
    }

    @Override
    public void writeRawArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        buffer.writeByte((byte)115);
        for (Object charValue : values) {
            buffer.writeInt(((Character)charValue).charValue() & 0xFFFF);
        }
    }

    public void writeRawArray(ProtonBuffer buffer, EncoderState state, char[] values) {
        buffer.writeByte((byte)115);
        for (char charValue : values) {
            buffer.writeInt(charValue & 0xFFFF);
        }
    }

    public void writeArray(ProtonBuffer buffer, EncoderState state, char[] values) {
        if (values.length < 63) {
            this.writeAsArray8(buffer, state, values);
        } else {
            this.writeAsArray32(buffer, state, values);
        }
    }

    private void writeAsArray8(ProtonBuffer buffer, EncoderState state, char[] values) {
        buffer.writeByte((byte)-32);
        int startIndex = buffer.getWriteOffset();
        buffer.writeByte((byte)0);
        buffer.writeByte((byte)values.length);
        this.writeRawArray(buffer, state, values);
        int endIndex = buffer.getWriteOffset();
        long writeSize = endIndex - startIndex - 1;
        buffer.setByte(startIndex, (byte)writeSize);
    }

    private void writeAsArray32(ProtonBuffer buffer, EncoderState state, char[] values) {
        buffer.writeByte((byte)-16);
        int startIndex = buffer.getWriteOffset();
        buffer.writeInt(0);
        buffer.writeInt(values.length);
        this.writeRawArray(buffer, state, values);
        int endIndex = buffer.getWriteOffset();
        long writeSize = endIndex - startIndex - 4;
        if (writeSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot encode given array, encoded size to large: " + writeSize);
        }
        buffer.setInt(startIndex, (int)writeSize);
    }
}

