/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.codec.encoders.primitives;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.codec.EncoderState;
import com.rabbitmq.qpid.protonj2.codec.encoders.AbstractPrimitiveTypeEncoder;

public final class ShortTypeEncoder
extends AbstractPrimitiveTypeEncoder<Short> {
    @Override
    public Class<Short> getTypeClass() {
        return Short.class;
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, Short value) {
        buffer.writeByte((byte)97);
        buffer.writeShort(value);
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, short value) {
        buffer.writeByte((byte)97);
        buffer.writeShort(value);
    }

    @Override
    public void writeRawArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        buffer.writeByte((byte)97);
        for (Object value : values) {
            buffer.writeShort((Short)value);
        }
    }

    public void writeRawArray(ProtonBuffer buffer, EncoderState state, short[] values) {
        buffer.writeByte((byte)97);
        for (short value : values) {
            buffer.writeShort(value);
        }
    }

    public void writeArray(ProtonBuffer buffer, EncoderState state, short[] values) {
        if (values.length < 127) {
            this.writeAsArray8(buffer, state, values);
        } else {
            this.writeAsArray32(buffer, state, values);
        }
    }

    private void writeAsArray8(ProtonBuffer buffer, EncoderState state, short[] values) {
        buffer.writeByte((byte)-32);
        int startIndex = buffer.getWriteOffset();
        buffer.writeByte((byte)0);
        buffer.writeByte((byte)values.length);
        this.writeRawArray(buffer, state, values);
        int endIndex = buffer.getWriteOffset();
        long writeSize = endIndex - startIndex - 1;
        buffer.setByte(startIndex, (byte)writeSize);
    }

    private void writeAsArray32(ProtonBuffer buffer, EncoderState state, short[] values) {
        buffer.writeByte((byte)-16);
        int startIndex = buffer.getWriteOffset();
        buffer.writeInt(0);
        buffer.writeInt(values.length);
        this.writeRawArray(buffer, state, values);
        int endIndex = buffer.getWriteOffset();
        long writeSize = endIndex - startIndex - 4;
        if (writeSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot encode given array, encoded size to large: " + writeSize);
        }
        buffer.setInt(startIndex, (int)writeSize);
    }
}

