/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.types;

public final class UnsignedByte
extends Number
implements Comparable<UnsignedByte> {
    private static final long serialVersionUID = 6271683731751283403L;
    private static final UnsignedByte[] cachedValues = new UnsignedByte[256];
    private final byte underlying;

    public UnsignedByte(byte underlying) {
        this.underlying = underlying;
    }

    @Override
    public byte byteValue() {
        return this.underlying;
    }

    @Override
    public short shortValue() {
        return (short)this.intValue();
    }

    @Override
    public int intValue() {
        return this.underlying & 0xFF;
    }

    @Override
    public long longValue() {
        return (long)this.underlying & 0xFFL;
    }

    @Override
    public float floatValue() {
        return this.longValue();
    }

    @Override
    public double doubleValue() {
        return this.longValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnsignedByte that = (UnsignedByte)o;
        return this.underlying == that.underlying;
    }

    @Override
    public int compareTo(byte value) {
        return UnsignedByte.compare(this.underlying, value);
    }

    @Override
    public int compareTo(UnsignedByte o) {
        return UnsignedByte.compare(this.underlying, o.underlying);
    }

    public static int compare(byte left, byte right) {
        return Integer.compareUnsigned(Byte.toUnsignedInt(left), Byte.toUnsignedInt(right));
    }

    public int hashCode() {
        return this.underlying;
    }

    public String toString() {
        return String.valueOf(this.intValue());
    }

    public static UnsignedByte valueOf(byte value) {
        int index = value & 0xFF;
        return cachedValues[index];
    }

    public static UnsignedByte valueOf(String value) throws NumberFormatException {
        int intVal = Integer.parseInt(value);
        if (intVal < 0 || intVal >= 256) {
            throw new NumberFormatException("Value \"" + value + "\" lies outside the range [0-256).");
        }
        return UnsignedByte.valueOf((byte)intVal);
    }

    public static short toUnsignedShort(byte value) {
        return (short)(value & 0xFF);
    }

    public static int toUnsignedInt(byte value) {
        return Byte.toUnsignedInt(value);
    }

    public static long toUnsignedLong(byte value) {
        return Byte.toUnsignedLong(value);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            UnsignedByte.cachedValues[i] = new UnsignedByte((byte)i);
        }
    }
}

