/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.types;

public final class UnsignedInteger
extends Number
implements Comparable<UnsignedInteger> {
    private static final long serialVersionUID = 3042749852724499995L;
    private static final UnsignedInteger[] cachedValues = new UnsignedInteger[256];
    public static final UnsignedInteger ZERO;
    public static final UnsignedInteger ONE;
    public static final UnsignedInteger MAX_VALUE;
    private final int underlying;

    public UnsignedInteger(int underlying) {
        this.underlying = underlying;
    }

    @Override
    public int intValue() {
        return this.underlying;
    }

    @Override
    public long longValue() {
        return Integer.toUnsignedLong(this.underlying);
    }

    @Override
    public float floatValue() {
        return this.longValue();
    }

    @Override
    public double doubleValue() {
        return this.longValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnsignedInteger that = (UnsignedInteger)o;
        return this.underlying == that.underlying;
    }

    @Override
    public int compareTo(int value) {
        return Integer.compareUnsigned(this.underlying, value);
    }

    @Override
    public int compareTo(long value) {
        return Long.compareUnsigned(this.longValue(), value);
    }

    @Override
    public int compareTo(UnsignedInteger value) {
        return Long.compareUnsigned(this.longValue(), value.longValue());
    }

    public static int compare(int left, int right) {
        return Integer.compareUnsigned(left, right);
    }

    public static int compare(long left, long right) {
        return Long.compareUnsigned(left, right);
    }

    public int hashCode() {
        return this.underlying;
    }

    public String toString() {
        return String.valueOf(this.longValue());
    }

    public static UnsignedInteger valueOf(int value) {
        if ((value & 0xFFFFFF00) == 0) {
            return cachedValues[value];
        }
        return new UnsignedInteger(value);
    }

    public UnsignedInteger add(UnsignedInteger value) {
        int val = this.underlying + value.underlying;
        return UnsignedInteger.valueOf(val);
    }

    public UnsignedInteger subtract(UnsignedInteger value) {
        int val = this.underlying - value.underlying;
        return UnsignedInteger.valueOf(val);
    }

    public static UnsignedInteger valueOf(String value) {
        long longVal = Long.parseLong(value);
        return UnsignedInteger.valueOf(longVal);
    }

    public static UnsignedInteger valueOf(long value) {
        if (value < 0L || value >= 0x100000000L) {
            throw new NumberFormatException("Value \"" + value + "\" lies outside the range [0-4294967296).");
        }
        return UnsignedInteger.valueOf((int)value);
    }

    public static long toUnsignedLong(int value) {
        return Integer.toUnsignedLong(value);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            UnsignedInteger.cachedValues[i] = new UnsignedInteger(i);
        }
        ZERO = cachedValues[0];
        ONE = cachedValues[1];
        MAX_VALUE = new UnsignedInteger(-1);
    }
}

