/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.types.messaging;

import com.rabbitmq.qpid.protonj2.types.Symbol;
import com.rabbitmq.qpid.protonj2.types.UnsignedInteger;
import com.rabbitmq.qpid.protonj2.types.UnsignedLong;
import com.rabbitmq.qpid.protonj2.types.messaging.Terminus;
import com.rabbitmq.qpid.protonj2.types.messaging.TerminusDurability;
import com.rabbitmq.qpid.protonj2.types.messaging.TerminusExpiryPolicy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class Target
implements Terminus {
    public static final UnsignedLong DESCRIPTOR_CODE = UnsignedLong.valueOf(41L);
    public static final Symbol DESCRIPTOR_SYMBOL = Symbol.valueOf("amqp:target:list");
    private String address;
    private TerminusDurability durable = TerminusDurability.NONE;
    private TerminusExpiryPolicy expiryPolicy = TerminusExpiryPolicy.SESSION_END;
    private UnsignedInteger timeout = UnsignedInteger.ZERO;
    private boolean dynamic;
    private Map<Symbol, Object> dynamicNodeProperties;
    private Symbol[] capabilities;

    public Target() {
    }

    private Target(Target other) {
        this.address = other.address;
        this.durable = other.durable;
        this.expiryPolicy = other.expiryPolicy;
        this.timeout = other.timeout;
        this.dynamic = other.dynamic;
        if (other.dynamicNodeProperties != null) {
            this.dynamicNodeProperties = new HashMap<Symbol, Object>(other.dynamicNodeProperties);
        }
        if (other.capabilities != null) {
            this.capabilities = (Symbol[])other.capabilities.clone();
        }
    }

    @Override
    public Target copy() {
        return new Target(this);
    }

    public String getAddress() {
        return this.address;
    }

    public Target setAddress(String address) {
        this.address = address;
        return this;
    }

    public TerminusDurability getDurable() {
        return this.durable;
    }

    public Target setDurable(TerminusDurability durable) {
        this.durable = durable == null ? TerminusDurability.NONE : durable;
        return this;
    }

    public TerminusExpiryPolicy getExpiryPolicy() {
        return this.expiryPolicy;
    }

    public Target setExpiryPolicy(TerminusExpiryPolicy expiryPolicy) {
        this.expiryPolicy = expiryPolicy == null ? TerminusExpiryPolicy.SESSION_END : expiryPolicy;
        return this;
    }

    public UnsignedInteger getTimeout() {
        return this.timeout;
    }

    public Target setTimeout(UnsignedInteger timeout) {
        this.timeout = timeout;
        return this;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public Target setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
        return this;
    }

    public Map<Symbol, Object> getDynamicNodeProperties() {
        return this.dynamicNodeProperties;
    }

    public Target setDynamicNodeProperties(Map<Symbol, ?> dynamicNodeProperties) {
        this.dynamicNodeProperties = dynamicNodeProperties;
        return this;
    }

    public Symbol[] getCapabilities() {
        return this.capabilities;
    }

    public Target setCapabilities(Symbol ... capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public String toString() {
        return "Target{address='" + this.getAddress() + "', durable=" + this.getDurable() + ", expiryPolicy=" + this.getExpiryPolicy() + ", timeout=" + this.getTimeout() + ", dynamic=" + this.isDynamic() + ", dynamicNodeProperties=" + this.getDynamicNodeProperties() + ", capabilities=" + (this.getCapabilities() == null ? null : Arrays.asList(this.getCapabilities())) + "}";
    }
}

