/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.types.security;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.engine.util.StringUtils;
import com.rabbitmq.qpid.protonj2.types.Binary;
import com.rabbitmq.qpid.protonj2.types.Symbol;
import com.rabbitmq.qpid.protonj2.types.UnsignedLong;
import com.rabbitmq.qpid.protonj2.types.security.SaslPerformative;

public final class SaslInit
implements SaslPerformative {
    public static final UnsignedLong DESCRIPTOR_CODE = UnsignedLong.valueOf(65L);
    public static final Symbol DESCRIPTOR_SYMBOL = Symbol.valueOf("amqp:sasl-init:list");
    private Symbol mechanism;
    private ProtonBuffer initialResponse;
    private String hostname;

    public Symbol getMechanism() {
        return this.mechanism;
    }

    public SaslInit setMechanism(Symbol mechanism) {
        if (mechanism == null) {
            throw new NullPointerException("the mechanism field is mandatory");
        }
        this.mechanism = mechanism;
        return this;
    }

    public ProtonBuffer getInitialResponse() {
        return this.initialResponse;
    }

    public SaslInit setInitialResponse(Binary initialResponse) {
        this.initialResponse = initialResponse == null ? null : initialResponse.asProtonBuffer();
        return this;
    }

    public SaslInit setInitialResponse(ProtonBuffer initialResponse) {
        this.initialResponse = initialResponse;
        return this;
    }

    public String getHostname() {
        return this.hostname;
    }

    public SaslInit setHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @Override
    public SaslInit copy() {
        SaslInit copy = new SaslInit();
        copy.setHostname(this.hostname);
        copy.setInitialResponse(this.initialResponse == null ? null : this.initialResponse.copy());
        if (this.mechanism != null) {
            copy.setMechanism(this.mechanism);
        }
        return copy;
    }

    public String toString() {
        return "SaslInit{mechanism=" + this.mechanism + ", initialResponse=" + (this.initialResponse == null ? null : StringUtils.toQuotedString(this.initialResponse)) + ", hostname='" + this.hostname + "'}";
    }

    @Override
    public SaslPerformative.SaslPerformativeType getPerformativeType() {
        return SaslPerformative.SaslPerformativeType.INIT;
    }

    @Override
    public <E> void invoke(SaslPerformative.SaslPerformativeHandler<E> handler, E context) {
        handler.handleInit(this, context);
    }
}

