/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.types.transport;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.buffer.ProtonBufferAllocator;
import java.nio.ByteBuffer;

public final class AMQPHeader {
    static final byte[] PREFIX = new byte[]{65, 77, 81, 80};
    public static final int PROTOCOL_ID_INDEX = 4;
    public static final int MAJOR_VERSION_INDEX = 5;
    public static final int MINOR_VERSION_INDEX = 6;
    public static final int REVISION_INDEX = 7;
    public static final byte AMQP_PROTOCOL_ID = 0;
    public static final byte SASL_PROTOCOL_ID = 3;
    public static final int HEADER_SIZE_BYTES = 8;
    private static final AMQPHeader AMQP_HEADER = new AMQPHeader(new byte[]{65, 77, 81, 80, 0, 1, 0, 0});
    private static final AMQPHeader SASL_HEADER = new AMQPHeader(new byte[]{65, 77, 81, 80, 3, 1, 0, 0});
    private ProtonBuffer buffer;

    public AMQPHeader() {
        this(AMQPHeader.AMQP_HEADER.buffer.copy(true));
    }

    public AMQPHeader(byte[] headerBytes) {
        this.setBuffer(ProtonBufferAllocator.defaultAllocator().copy(headerBytes).convertToReadOnly(), true);
    }

    public AMQPHeader(ProtonBuffer buffer) {
        this.setBuffer(buffer.copy(true), true);
    }

    public AMQPHeader(ProtonBuffer buffer, boolean validate) {
        this.setBuffer(buffer.copy(true), validate);
    }

    public static AMQPHeader getAMQPHeader() {
        return AMQP_HEADER;
    }

    public static AMQPHeader getSASLHeader() {
        return SASL_HEADER;
    }

    public int getProtocolId() {
        return this.buffer.getByte(4) & 0xFF;
    }

    public int getMajor() {
        return this.buffer.getByte(5) & 0xFF;
    }

    public int getMinor() {
        return this.buffer.getByte(6) & 0xFF;
    }

    public int getRevision() {
        return this.buffer.getByte(7) & 0xFF;
    }

    public ProtonBuffer getBuffer() {
        return this.buffer.copy(true);
    }

    public byte[] toArray() {
        if (this.buffer != null) {
            byte[] copy = new byte[this.buffer.getReadableBytes()];
            this.buffer.copyInto(0, copy, 0, copy.length);
            return copy;
        }
        return null;
    }

    public ByteBuffer toByteBuffer() {
        if (this.buffer != null) {
            byte[] copy = new byte[this.buffer.getReadableBytes()];
            this.buffer.copyInto(0, copy, 0, copy.length);
            return ByteBuffer.wrap(copy);
        }
        return null;
    }

    public byte getByteAt(int i) {
        return this.buffer.getByte(i);
    }

    public boolean hasValidPrefix() {
        return this.startsWith(this.buffer, PREFIX);
    }

    public boolean isSaslHeader() {
        return this.getProtocolId() == 3;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.buffer == null ? 0 : this.buffer.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AMQPHeader other = (AMQPHeader)obj;
        return !(this.buffer == null ? other.buffer != null : !this.buffer.equals(other.buffer));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.buffer.getReadableBytes(); ++i) {
            char value = (char)this.buffer.getByte(i);
            if (Character.isLetter(value)) {
                builder.append(value);
                continue;
            }
            builder.append(",");
            builder.append((int)value);
        }
        return builder.toString();
    }

    private boolean startsWith(ProtonBuffer buffer, byte[] value) {
        if (buffer == null || buffer.getReadableBytes() < value.length) {
            return false;
        }
        for (int i = 0; i < value.length; ++i) {
            if (buffer.getByte(i) == value[i]) continue;
            return false;
        }
        return true;
    }

    private AMQPHeader setBuffer(ProtonBuffer value, boolean validate) {
        if (validate) {
            if (value.getReadableBytes() != 8 || !this.startsWith(value, PREFIX)) {
                throw new IllegalArgumentException("Not an AMQP header buffer");
            }
            AMQPHeader.validateProtocolByte(value.getByte(4));
            AMQPHeader.validateMajorVersionByte(value.getByte(5));
            AMQPHeader.validateMinorVersionByte(value.getByte(6));
            AMQPHeader.validateRevisionByte(value.getByte(7));
        }
        this.buffer = value;
        return this;
    }

    public static void validate(byte[] headerBytes) {
        if (headerBytes.length != 8) {
            throw new IllegalArgumentException("Not an AMQP header buffer, size should be eight but was: " + headerBytes.length);
        }
        for (int i = 0; i < PREFIX.length; ++i) {
            if (headerBytes[i] == PREFIX[i]) continue;
            throw new IllegalArgumentException("The header bytes given do not have an AMQP prefix");
        }
        AMQPHeader.validateProtocolByte(headerBytes[4]);
        AMQPHeader.validateMajorVersionByte(headerBytes[5]);
        AMQPHeader.validateMinorVersionByte(headerBytes[6]);
        AMQPHeader.validateRevisionByte(headerBytes[7]);
    }

    public static void validateByte(int index, byte value) {
        switch (index) {
            case 0: {
                AMQPHeader.validatePrefixByte1(value);
                break;
            }
            case 1: {
                AMQPHeader.validatePrefixByte2(value);
                break;
            }
            case 2: {
                AMQPHeader.validatePrefixByte3(value);
                break;
            }
            case 3: {
                AMQPHeader.validatePrefixByte4(value);
                break;
            }
            case 4: {
                AMQPHeader.validateProtocolByte(value);
                break;
            }
            case 5: {
                AMQPHeader.validateMajorVersionByte(value);
                break;
            }
            case 6: {
                AMQPHeader.validateMinorVersionByte(value);
                break;
            }
            case 7: {
                AMQPHeader.validateRevisionByte(value);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid AMQP Header byte index provided to validation method: " + index);
            }
        }
    }

    private static void validatePrefixByte1(byte value) {
        if (value != PREFIX[0]) {
            throw new IllegalArgumentException(String.format("Invalid header byte(1) specified %d : expected %d", value, PREFIX[0]));
        }
    }

    private static void validatePrefixByte2(byte value) {
        if (value != PREFIX[1]) {
            throw new IllegalArgumentException(String.format("Invalid header byte(2) specified %d : expected %d", value, PREFIX[1]));
        }
    }

    private static void validatePrefixByte3(byte value) {
        if (value != PREFIX[2]) {
            throw new IllegalArgumentException(String.format("Invalid header byte(3) specified %d : expected %d", value, PREFIX[2]));
        }
    }

    private static void validatePrefixByte4(byte value) {
        if (value != PREFIX[3]) {
            throw new IllegalArgumentException(String.format("Invalid header byte(4) specified %d : expected %d", value, PREFIX[3]));
        }
    }

    private static void validateProtocolByte(byte value) {
        if (value != 0 && value != 3) {
            throw new IllegalArgumentException(String.format("Invalid protocol Id specified %d : expected one of %d or %d", value, (byte)0, (byte)3));
        }
    }

    private static void validateMajorVersionByte(byte value) {
        if (value != 1) {
            throw new IllegalArgumentException(String.format("Invalid Major version specified %d : expected %d", value, 1));
        }
    }

    private static void validateMinorVersionByte(byte value) {
        if (value != 0) {
            throw new IllegalArgumentException(String.format("Invalid Minor version specified %d : expected %d", value, 0));
        }
    }

    private static void validateRevisionByte(byte value) {
        if (value != 0) {
            throw new IllegalArgumentException(String.format("Invalid revision specified %d : expected %d", value, 0));
        }
    }

    public <E> void invoke(HeaderHandler<E> handler, E context) {
        if (this.isSaslHeader()) {
            handler.handleSASLHeader(this, context);
        } else {
            handler.handleAMQPHeader(this, context);
        }
    }

    public static interface HeaderHandler<E> {
        default public void handleAMQPHeader(AMQPHeader header, E context) {
        }

        default public void handleSASLHeader(AMQPHeader header, E context) {
        }
    }
}

