/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.impl;

import com.rabbitmq.client.amqp.ConnectionBuilder;
import com.rabbitmq.client.amqp.Environment;
import com.rabbitmq.client.amqp.ObservationCollector;
import com.rabbitmq.client.amqp.impl.AmqpConnection;
import com.rabbitmq.client.amqp.impl.AmqpConnectionBuilder;
import com.rabbitmq.client.amqp.impl.Clock;
import com.rabbitmq.client.amqp.impl.ConnectionManager;
import com.rabbitmq.client.amqp.impl.ConnectionUtils;
import com.rabbitmq.client.amqp.impl.CredentialsManagerFactory;
import com.rabbitmq.client.amqp.impl.DefaultConnectionSettings;
import com.rabbitmq.client.amqp.impl.EventLoop;
import com.rabbitmq.client.amqp.impl.Utils;
import com.rabbitmq.client.amqp.metrics.MetricsCollector;
import com.rabbitmq.client.amqp.metrics.NoOpMetricsCollector;
import com.rabbitmq.qpid.protonj2.client.Client;
import com.rabbitmq.qpid.protonj2.client.ClientOptions;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AmqpEnvironment
implements Environment {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpEnvironment.class);
    private static final AtomicLong ID_SEQUENCE = new AtomicLong(0L);
    private final Client client;
    private final DefaultConnectionSettings<?> connectionSettings = DefaultConnectionSettings.instance();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final boolean internalExecutor;
    private final boolean internalScheduledExecutor;
    private final boolean internalPublisherExecutor;
    private final ExecutorService executorService;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Executor dispatchingExecutorService;
    private final ExecutorService publisherExecutorService;
    private final ConnectionManager connectionManager = new ConnectionManager(this);
    private final long id;
    private final Clock clock = new Clock();
    private volatile ScheduledFuture<?> clockRefreshFuture;
    private final AtomicBoolean clockRefreshSet = new AtomicBoolean(false);
    private final MetricsCollector metricsCollector;
    private final ObservationCollector observationCollector;
    private final ConnectionUtils.AffinityCache affinityCache = new ConnectionUtils.AffinityCache();
    private final EventLoop recoveryEventLoop;
    private final ExecutorService recoveryEventLoopExecutorService;
    private final CredentialsManagerFactory credentialsManagerFactory = new CredentialsManagerFactory(this);

    AmqpEnvironment(ExecutorService executorService, ScheduledExecutorService scheduledExecutorService, Executor dispatchingExecutorService, ExecutorService publisherExecutorService, DefaultConnectionSettings<?> connectionSettings, MetricsCollector metricsCollector, ObservationCollector observationCollector) {
        this.id = ID_SEQUENCE.getAndIncrement();
        connectionSettings.copyTo(this.connectionSettings);
        this.connectionSettings.consolidate();
        ClientOptions clientOptions = new ClientOptions();
        this.client = Client.create(clientOptions);
        String threadPrefix = String.format("rabbitmq-amqp-environment-%d-", this.id);
        if (executorService == null) {
            this.executorService = Executors.newCachedThreadPool(Utils.threadFactory(threadPrefix));
            this.internalExecutor = true;
        } else {
            this.executorService = executorService;
            this.internalExecutor = false;
        }
        if (scheduledExecutorService == null) {
            this.scheduledExecutorService = Executors.newScheduledThreadPool(1, Utils.threadFactory(threadPrefix + "scheduler-"));
            this.internalScheduledExecutor = true;
        } else {
            this.scheduledExecutorService = scheduledExecutorService;
            this.internalScheduledExecutor = false;
        }
        this.dispatchingExecutorService = dispatchingExecutorService;
        if (publisherExecutorService == null) {
            this.publisherExecutorService = Utils.executorService(threadPrefix, new Object[0]);
            this.internalPublisherExecutor = true;
        } else {
            this.publisherExecutorService = publisherExecutorService;
            this.internalPublisherExecutor = false;
        }
        this.metricsCollector = metricsCollector == null ? NoOpMetricsCollector.INSTANCE : metricsCollector;
        this.observationCollector = observationCollector == null ? Utils.NO_OP_OBSERVATION_COLLECTOR : observationCollector;
        this.recoveryEventLoopExecutorService = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Utils.threadFactory(threadPrefix + "event-loop-"));
        this.recoveryEventLoop = new EventLoop(this.recoveryEventLoopExecutorService);
    }

    DefaultConnectionSettings<?> connectionSettings() {
        return this.connectionSettings;
    }

    Client client() {
        return this.client;
    }

    Clock clock() {
        if (this.clockRefreshSet.compareAndSet(false, true)) {
            this.clockRefreshFuture = this.scheduledExecutorService.scheduleAtFixedRate(this.clock::refresh, 1L, 1L, TimeUnit.SECONDS);
        }
        return this.clock;
    }

    CredentialsManagerFactory credentialsManagerFactory() {
        return this.credentialsManagerFactory;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            LOGGER.debug("Closing environment {}", (Object)this);
            this.connectionManager.close();
            this.client.close();
            this.recoveryEventLoop.close();
            this.recoveryEventLoopExecutorService.shutdownNow();
            if (this.internalExecutor) {
                this.executorService.shutdownNow();
            }
            if (this.internalScheduledExecutor) {
                this.scheduledExecutorService.shutdownNow();
            }
            if (this.internalPublisherExecutor) {
                this.publisherExecutorService.shutdownNow();
            }
            if (this.clockRefreshFuture != null) {
                this.clockRefreshFuture.cancel(false);
            }
            this.scheduledExecutorService.shutdownNow();
            LOGGER.debug("Environment {} has been closed", (Object)this);
        }
    }

    @Override
    public ConnectionBuilder connectionBuilder() {
        return new AmqpConnectionBuilder(this);
    }

    ExecutorService executorService() {
        return this.executorService;
    }

    Executor dispatchingExecutorService() {
        return this.dispatchingExecutorService;
    }

    ExecutorService publisherExecutorService() {
        return this.publisherExecutorService;
    }

    ScheduledExecutorService scheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    MetricsCollector metricsCollector() {
        return this.metricsCollector;
    }

    ObservationCollector observationCollector() {
        return this.observationCollector;
    }

    ConnectionUtils.AffinityCache affinityCache() {
        return this.affinityCache;
    }

    EventLoop recoveryEventLoop() {
        return this.recoveryEventLoop;
    }

    AmqpConnection connection(AmqpConnectionBuilder builder) {
        return this.connectionManager.connection(builder);
    }

    void removeConnection(AmqpConnection connection) {
        this.connectionManager.remove(connection);
    }

    public String toString() {
        return "rabbitmq-amqp-" + this.id;
    }
}

