/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.impl;

import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClientProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientProperties.class);
    private static final char[] VERSION_PROPERTY = new char[]{'c', 'o', 'm', '.', 'r', 'a', 'b', 'b', 'i', 't', 'm', 'q', '.', 'c', 'l', 'i', 'e', 'n', 't', '.', 'a', 'm', 'q', 'p', '.', 'v', 'e', 'r', 's', 'i', 'o', 'n'};
    public static final String VERSION = ClientProperties.getVersion();
    public static final Map<String, Object> DEFAULT_CLIENT_PROPERTIES = Map.of("product", "RabbitMQ", "version", VERSION, "platform", "Java", "copyright", "Copyright (c) 2024 Broadcom Inc. and/or its subsidiaries.", "information", "Licensed under the Apache License version 2. See https://www.rabbitmq.com/.");

    private static String getVersion() {
        String version;
        try {
            version = ClientProperties.getVersionFromPropertyFile();
        }
        catch (Exception e1) {
            LOGGER.warn("Couldn't get version from property file", (Throwable)e1);
            try {
                version = ClientProperties.getVersionFromPackage();
            }
            catch (Exception e2) {
                LOGGER.warn("Couldn't get version with Package#getImplementationVersion", (Throwable)e1);
                version = ClientProperties.getDefaultVersion();
            }
        }
        return version;
    }

    private static String getVersionFromPropertyFile() throws Exception {
        Properties version = new Properties();
        try (InputStream inputStream = ClientProperties.class.getClassLoader().getResourceAsStream("rabbitmq-amqp-1-0-client.properties");){
            version.load(inputStream);
        }
        String propertyName = new String(VERSION_PROPERTY);
        String versionProperty = version.getProperty(propertyName);
        if (versionProperty == null) {
            throw new IllegalStateException("Couldn't find version property in property file");
        }
        return versionProperty;
    }

    private static String getVersionFromPackage() {
        if (ClientProperties.class.getPackage().getImplementationVersion() == null) {
            throw new IllegalStateException("Couldn't get version with Package#getImplementationVersion");
        }
        return ClientProperties.class.getPackage().getImplementationVersion();
    }

    private static String getDefaultVersion() {
        return "0.0.0";
    }

    private ClientProperties() {
    }
}

