/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.impl;

import com.rabbitmq.client.amqp.Address;
import com.rabbitmq.client.amqp.AmqpException;
import com.rabbitmq.client.amqp.ConnectionSettings;
import com.rabbitmq.client.amqp.Management;
import com.rabbitmq.client.amqp.impl.AmqpConnection;
import com.rabbitmq.client.amqp.impl.AmqpManagement;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConnectionUtils {
    static final RetryStrategy NO_RETRY_STRATEGY = Supplier::get;
    static final ConnectionSettings.AffinityStrategy LEADER_FOR_PUBLISHING_FOLLOWERS_FOR_CONSUMING_STRATEGY = new LeaderForPublishingFollowersForConsumingStrategy();
    static final ConnectionSettings.AffinityStrategy LEADER_FOR_PUBLISHING_MEMBERS_FOR_CONSUMING_STRATEGY = new LeaderForPublishingMembersForConsumingStrategy();
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionUtils.class);

    private ConnectionUtils() {
    }

    static AmqpConnection.NativeConnectionWrapper enforceAffinity(Function<List<Address>, AmqpConnection.NativeConnectionWrapper> connectionFactory, AmqpManagement management, AffinityContext context, AffinityCache affinityCache, ConnectionSettings.AffinityStrategy strategy, RetryStrategy retryStrategy, String connectionName) {
        if (context == null) {
            return retryStrategy.maybeRetry(() -> (AmqpConnection.NativeConnectionWrapper)connectionFactory.apply(null));
        }
        AmqpConnection.NativeConnectionWrapper connectionWrapper = null;
        try {
            AmqpConnection.NativeConnectionWrapper pickedConnection = null;
            int attemptCount = 0;
            boolean queueInfoRefreshed = false;
            List<String> nodesWithAffinity = null;
            Management.QueueInfo info = affinityCache.queueInfo(context.queue());
            while (pickedConnection == null) {
                ++attemptCount;
                connectionWrapper = null;
                if (info == null) {
                    connectionWrapper = retryStrategy.maybeRetry(() -> (AmqpConnection.NativeConnectionWrapper)connectionFactory.apply(null));
                    info = ConnectionUtils.lookUpQueueInfo(management, context, affinityCache, retryStrategy);
                    queueInfoRefreshed = true;
                }
                if (info == null) {
                    return connectionWrapper;
                }
                LOGGER.debug("Looking affinity with queue '{}' (type = {}, leader = {}, replicas = {}) for '{}'", new Object[]{info.name(), info.type(), info.leader(), info.members(), connectionName});
                if (nodesWithAffinity == null) {
                    nodesWithAffinity = strategy.nodesWithAffinity(context, info);
                }
                if (connectionWrapper == null) {
                    List addressHints = nodesWithAffinity.stream().map(affinityCache::nodenameToAddress).filter(Objects::nonNull).collect(Collectors.toList());
                    connectionWrapper = retryStrategy.maybeRetry(() -> (AmqpConnection.NativeConnectionWrapper)connectionFactory.apply(addressHints));
                }
                LOGGER.trace("Nodes matching affinity {}: {}.", (Object)context, nodesWithAffinity);
                LOGGER.trace("Currently connected to node {}.", (Object)connectionWrapper.nodename());
                affinityCache.nodenameToAddress(connectionWrapper.nodename(), connectionWrapper.address());
                if (nodesWithAffinity.contains(connectionWrapper.nodename())) {
                    if (!queueInfoRefreshed) {
                        LOGGER.trace("Found affinity, but refreshing queue information to check affinity is still valid.");
                        info = ConnectionUtils.lookUpQueueInfo(management, context, affinityCache, retryStrategy);
                        if (info == null) {
                            LOGGER.trace("Could not look up info for queue '{}'", (Object)context.queue());
                            pickedConnection = connectionWrapper;
                        } else {
                            nodesWithAffinity = strategy.nodesWithAffinity(context, info);
                            queueInfoRefreshed = true;
                            if (nodesWithAffinity.contains(connectionWrapper.nodename())) {
                                pickedConnection = connectionWrapper;
                            } else {
                                LOGGER.debug("Affinity no longer valid, retrying.");
                                management.releaseResources(null);
                                connectionWrapper.connection().close();
                            }
                        }
                    } else {
                        pickedConnection = connectionWrapper;
                    }
                    if (pickedConnection == null) continue;
                    LOGGER.debug("Connected to node '{}' for '{}'", (Object)pickedConnection.nodename(), (Object)connectionName);
                    continue;
                }
                if (attemptCount == 5) {
                    LOGGER.debug("Could not find affinity {} after {} attempt(s), using last connection for '{}'.", new Object[]{context, attemptCount, connectionName});
                    pickedConnection = connectionWrapper;
                    continue;
                }
                LOGGER.trace("Affinity {} not found with node {}.", (Object)context, (Object)connectionWrapper.nodename());
                if (!queueInfoRefreshed && (info = ConnectionUtils.lookUpQueueInfo(management, context, affinityCache, retryStrategy)) != null) {
                    nodesWithAffinity = strategy.nodesWithAffinity(context, info);
                    queueInfoRefreshed = true;
                }
                management.releaseResources(null);
                connectionWrapper.connection().close();
            }
            return pickedConnection;
        }
        catch (AmqpException.AmqpConnectionException e) {
            management.releaseResources(e);
            try {
                if (connectionWrapper != null) {
                    connectionWrapper.connection().close();
                }
            }
            catch (Exception ex) {
                LOGGER.debug("Error while closing native connection while enforcing affinity: {}", (Object)ex.getMessage());
            }
            management.markUnavailable();
            LOGGER.warn("Cannot enforce affinity {} of '{}' because connection has been closed", new Object[]{context, connectionName, e});
            throw e;
        }
        catch (RuntimeException e) {
            LOGGER.warn("Cannot enforce affinity {} of '{}' error when looking up queue", new Object[]{context, connectionName, e});
            throw e;
        }
    }

    private static Management.QueueInfo lookUpQueueInfo(AmqpManagement management, AffinityContext affinity, AffinityCache cache, RetryStrategy retryStrategy) {
        return retryStrategy.maybeRetry(() -> {
            Management.QueueInfo info = null;
            management.init();
            try {
                info = management.queueInfo(affinity.queue());
                cache.queueInfo(info);
            }
            catch (AmqpException.AmqpEntityDoesNotExistException e) {
                LOGGER.debug("Queue '{}' does not exist.", (Object)affinity.queue());
                cache.clearQueueInfoEntry(affinity.queue());
            }
            return info;
        });
    }

    @FunctionalInterface
    static interface RetryStrategy {
        public <T> T maybeRetry(Supplier<T> var1);
    }

    static class LeaderForPublishingFollowersForConsumingStrategy
    implements ConnectionSettings.AffinityStrategy {
        LeaderForPublishingFollowersForConsumingStrategy() {
        }

        @Override
        public List<String> nodesWithAffinity(ConnectionSettings.AffinityContext context, Management.QueueInfo info) {
            List followers;
            ConnectionSettings.Affinity.Operation operation = context.operation();
            String leader = info.leader();
            List<Object> replicas = info.members() == null ? Collections.emptyList() : info.members();
            LOGGER.debug("Trying to find affinity {} with leader = {}, replicas = {}", new Object[]{context, leader, replicas});
            List<Object> nodesWithAffinity = info.type() == Management.QueueType.QUORUM || info.type() == Management.QueueType.STREAM ? (operation == ConnectionSettings.Affinity.Operation.PUBLISH ? (leader == null || leader.isBlank() ? Collections.emptyList() : List.of(leader)) : (operation == ConnectionSettings.Affinity.Operation.CONSUME ? (!(followers = replicas.stream().filter(Objects::nonNull).filter(r -> !r.equals(leader)).collect(Collectors.toList())).isEmpty() ? List.copyOf(followers) : (leader != null && !leader.isBlank() ? List.of(leader) : Collections.emptyList())) : List.copyOf(replicas))) : List.copyOf(replicas);
            LOGGER.debug("Nodes with affinity: {}", nodesWithAffinity);
            return nodesWithAffinity;
        }
    }

    static class LeaderForPublishingMembersForConsumingStrategy
    implements ConnectionSettings.AffinityStrategy {
        LeaderForPublishingMembersForConsumingStrategy() {
        }

        @Override
        public List<String> nodesWithAffinity(ConnectionSettings.AffinityContext context, Management.QueueInfo info) {
            List<String> nodesWithAffinity;
            List<String> list = nodesWithAffinity = info.members() == null || info.members().isEmpty() ? Collections.emptyList() : List.copyOf(info.members());
            if (context.operation() == ConnectionSettings.Affinity.Operation.PUBLISH) {
                nodesWithAffinity = info.leader() != null && !info.leader().isBlank() ? List.of(info.leader()) : Collections.emptyList();
            }
            return nodesWithAffinity;
        }
    }

    static class AffinityContext
    implements ConnectionSettings.AffinityContext {
        private final String queue;
        private final ConnectionSettings.Affinity.Operation operation;

        AffinityContext(String queue, ConnectionSettings.Affinity.Operation operation) {
            this.queue = queue;
            this.operation = operation;
        }

        @Override
        public String queue() {
            return this.queue;
        }

        @Override
        public ConnectionSettings.Affinity.Operation operation() {
            return this.operation;
        }

        public String toString() {
            return "{queue='" + this.queue + "', operation=" + String.valueOf((Object)this.operation) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AffinityContext that = (AffinityContext)o;
            return Objects.equals(this.queue, that.queue) && this.operation == that.operation;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.queue, this.operation});
        }
    }

    static class AffinityCache {
        private final ConcurrentMap<String, Management.QueueInfo> queueInfoCache = new ConcurrentHashMap<String, Management.QueueInfo>();
        private final ConcurrentMap<String, Address> nodenameToAddressMapping = new ConcurrentHashMap<String, Address>();

        AffinityCache() {
        }

        AffinityCache queueInfo(Management.QueueInfo info) {
            this.queueInfoCache.put(info.name(), info);
            return this;
        }

        Management.QueueInfo queueInfo(String queue) {
            return (Management.QueueInfo)this.queueInfoCache.get(queue);
        }

        void clearQueueInfoEntry(String queue) {
            this.queueInfoCache.remove(queue);
        }

        AffinityCache nodenameToAddress(String nodename, Address address) {
            if (nodename != null && !nodename.isBlank()) {
                this.nodenameToAddressMapping.put(nodename, address);
            }
            return this;
        }

        Address nodenameToAddress(String name) {
            return (Address)this.nodenameToAddressMapping.get(name);
        }
    }
}

