/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.impl;

import com.rabbitmq.client.amqp.Message;
import com.rabbitmq.client.amqp.RpcClient;
import com.rabbitmq.client.amqp.RpcClientBuilder;
import com.rabbitmq.client.amqp.RpcServer;
import com.rabbitmq.client.amqp.RpcServerBuilder;
import com.rabbitmq.client.amqp.impl.AmqpConnection;
import com.rabbitmq.client.amqp.impl.DefaultAddressBuilder;
import java.time.Duration;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

abstract class RpcSupport {
    private RpcSupport() {
    }

    static class AmqpRpcServerBuilder
    implements RpcServerBuilder {
        private final AmqpConnection connection;
        private String requestQueue;
        private RpcServer.Handler handler;
        private Function<Message, Object> correlationIdExtractor;
        private BiFunction<Message, Object, Message> replyPostProcessor;
        private Duration closeTimeout = Duration.ofSeconds(60L);

        AmqpRpcServerBuilder(AmqpConnection connection) {
            this.connection = connection;
        }

        @Override
        public RpcServerBuilder requestQueue(String requestQueue) {
            this.requestQueue = requestQueue;
            return this;
        }

        @Override
        public RpcServerBuilder handler(RpcServer.Handler handler) {
            this.handler = handler;
            return this;
        }

        @Override
        public RpcServerBuilder correlationIdExtractor(Function<Message, Object> correlationIdExtractor) {
            this.correlationIdExtractor = correlationIdExtractor;
            return this;
        }

        @Override
        public RpcServerBuilder replyPostProcessor(BiFunction<Message, Object, Message> replyPostProcessor) {
            this.replyPostProcessor = replyPostProcessor;
            return this;
        }

        @Override
        public RpcServerBuilder closeTimeout(Duration closeTimeout) {
            this.closeTimeout = closeTimeout;
            return this;
        }

        @Override
        public RpcServer build() {
            return this.connection.createRpcServer(this);
        }

        AmqpConnection connection() {
            return this.connection;
        }

        String requestQueue() {
            return this.requestQueue;
        }

        RpcServer.Handler handler() {
            return this.handler;
        }

        Function<Message, Object> correlationIdExtractor() {
            return this.correlationIdExtractor;
        }

        BiFunction<Message, Object, Message> replyPostProcessor() {
            return this.replyPostProcessor;
        }

        Duration closeTimeout() {
            return this.closeTimeout;
        }
    }

    private static class DefaultRpcClientAddressBuilder
    extends DefaultAddressBuilder<RpcClientBuilder.RpcClientAddressBuilder>
    implements RpcClientBuilder.RpcClientAddressBuilder {
        private final AmqpRpcClientBuilder builder;

        private DefaultRpcClientAddressBuilder(AmqpRpcClientBuilder builder) {
            super(null);
            this.builder = builder;
        }

        @Override
        RpcClientBuilder.RpcClientAddressBuilder result() {
            return this;
        }

        @Override
        public RpcClientBuilder rpcClient() {
            return this.builder;
        }
    }

    static class AmqpRpcClientBuilder
    implements RpcClientBuilder {
        private static final Duration REQUEST_TIMEOUT_MIN = Duration.ofSeconds(1L);
        private final AmqpConnection connection;
        private final DefaultRpcClientAddressBuilder requestAddressBuilder = new DefaultRpcClientAddressBuilder(this);
        private String replyToQueue;
        private Supplier<Object> correlationIdSupplier;
        private BiFunction<Message, Object, Message> requestPostProcessor;
        private Function<Message, Object> correlationIdExtractor;
        private Duration requestTimeout = Duration.ofSeconds(30L);

        AmqpRpcClientBuilder(AmqpConnection connection) {
            this.connection = connection;
        }

        @Override
        public RpcClientBuilder.RpcClientAddressBuilder requestAddress() {
            return this.requestAddressBuilder;
        }

        @Override
        public RpcClientBuilder replyToQueue(String replyToQueue) {
            this.replyToQueue = replyToQueue;
            return this;
        }

        @Override
        public RpcClientBuilder correlationIdSupplier(Supplier<Object> correlationIdSupplier) {
            this.correlationIdSupplier = correlationIdSupplier;
            return this;
        }

        @Override
        public RpcClientBuilder requestPostProcessor(BiFunction<Message, Object, Message> requestPostProcessor) {
            this.requestPostProcessor = requestPostProcessor;
            return this;
        }

        @Override
        public RpcClientBuilder correlationIdExtractor(Function<Message, Object> correlationIdExtractor) {
            this.correlationIdExtractor = correlationIdExtractor;
            return this;
        }

        @Override
        public RpcClientBuilder requestTimeout(Duration timeout) {
            if (timeout == null) {
                throw new IllegalArgumentException("Request timeout cannot be null");
            }
            if (timeout.compareTo(REQUEST_TIMEOUT_MIN) < 0) {
                throw new IllegalArgumentException("Request timeout cannot be less than " + String.valueOf(REQUEST_TIMEOUT_MIN));
            }
            this.requestTimeout = timeout;
            return this;
        }

        Function<Message, Object> correlationIdExtractor() {
            return this.correlationIdExtractor;
        }

        @Override
        public RpcClient build() {
            return this.connection.createRpcClient(this);
        }

        AmqpConnection connection() {
            return this.connection;
        }

        String replyToQueue() {
            return this.replyToQueue;
        }

        Supplier<Object> correlationIdSupplier() {
            return this.correlationIdSupplier;
        }

        BiFunction<Message, Object, Message> requestPostProcessor() {
            return this.requestPostProcessor;
        }

        Duration requestTimeout() {
            return this.requestTimeout;
        }
    }
}

