/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.impl;

import com.rabbitmq.client.amqp.impl.FastUtilArrays;
import com.rabbitmq.client.amqp.impl.FastUtilIntComparator;
import com.rabbitmq.client.amqp.impl.FastUtilSwapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.function.ToLongFunction;

final class SerialNumberUtils {
    static final long SERIAL_SPACE = 0x100000000L;
    private static final long COMPARE = 0x80000000L;

    private SerialNumberUtils() {
    }

    static long inc(long s) {
        return (s + 1L) % 0x100000000L;
    }

    static <T> List<T> sort(List<T> list, ToLongFunction<T> serialNumberExtractor) {
        FastUtilArrays.quickSort(0, list.size(), new SerialNumberComparator<T>(list, serialNumberExtractor), new ListSwapper<T>(list));
        return list;
    }

    static <T> long[][] ranges(List<T> list, ToLongFunction<T> serialNumberExtractor) {
        if (list.isEmpty()) {
            return new long[0][0];
        }
        SerialNumberUtils.sort(list, serialNumberExtractor);
        long s1 = serialNumberExtractor.applyAsLong(list.get(0));
        long[] range = new long[]{s1, s1};
        ArrayList<long[]> ranges = new ArrayList<long[]>();
        ranges.add(range);
        for (int i = 1; i < list.size(); ++i) {
            long v = serialNumberExtractor.applyAsLong(list.get(i));
            if (v == SerialNumberUtils.inc(range[1])) {
                range[1] = v;
                continue;
            }
            range = new long[]{v, v};
            ranges.add(range);
        }
        return (long[][])ranges.toArray((T[])new long[0][]);
    }

    static int compare(long s1, long s2) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 < s2 && s2 - s1 < 0x80000000L || s1 > s2 && s1 - s2 > 0x80000000L) {
            return -1;
        }
        if (s1 < s2 && s2 - s1 > 0x80000000L || s1 > s2 && s1 - s2 < 0x80000000L) {
            return 1;
        }
        throw new IllegalArgumentException("Cannot compare serial numbers " + s1 + " and " + s2);
    }

    private static final class ListSwapper<T>
    implements FastUtilSwapper {
        private static final long serialVersionUID = -4992779583870196665L;
        private final List<T> list;

        private ListSwapper(List<T> list) {
            this.list = list;
        }

        @Override
        public void swap(int a, int b) {
            T t = this.list.get(a);
            this.list.set(a, this.list.get(b));
            this.list.set(b, t);
        }
    }

    private static class SerialNumberComparator<T>
    implements FastUtilIntComparator {
        private static final long serialVersionUID = -1979133464402603205L;
        private final List<T> list;
        @SuppressFBWarnings(value={"SE_BAD_FIELD"})
        private final ToLongFunction<T> serialNumberExtractor;

        private SerialNumberComparator(List<T> list, ToLongFunction<T> serialNumberExtractor) {
            this.list = list;
            this.serialNumberExtractor = serialNumberExtractor;
        }

        @Override
        public int compare(int k1, int k2) {
            return SerialNumberUtils.compare(this.serialNumberExtractor.applyAsLong(this.list.get(k1)), this.serialNumberExtractor.applyAsLong(this.list.get(k2)));
        }
    }
}

