/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.impl;

import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;

final class WorkPool<K, W> {
    private static final int MAX_QUEUE_LENGTH = 1000;
    private final SetQueue<K> ready = new SetQueue();
    private final Set<K> inProgress = new HashSet<K>();
    private final Map<K, LinkedBlockingQueue<W>> pool = new HashMap<K, LinkedBlockingQueue<W>>();
    private final BiConsumer<LinkedBlockingQueue<W>, W> enqueueingCallback;
    private final Lock lock = new ReentrantLock();

    public WorkPool(Duration queueingTimeout) {
        if (queueingTimeout.toNanos() > 0L) {
            long timeout = queueingTimeout.toMillis();
            this.enqueueingCallback = (queue, item) -> {
                try {
                    boolean offered = queue.offer(item, timeout, TimeUnit.MILLISECONDS);
                    if (!offered) {
                        throw new WorkPoolFullException("Could not enqueue in work pool after " + String.valueOf(queueingTimeout) + " ms.");
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            };
        } else {
            this.enqueueingCallback = (queue, item) -> {
                try {
                    queue.put(item);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            };
        }
    }

    public void registerKey(K key) {
        this.lock.lock();
        try {
            if (!this.pool.containsKey(key)) {
                this.pool.put(key, new LinkedBlockingQueue(1000));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void unregisterKey(K key) {
        this.lock.lock();
        try {
            this.pool.remove(key);
            this.ready.remove(key);
            this.inProgress.remove(key);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void unregisterAllKeys() {
        this.lock.lock();
        try {
            this.pool.clear();
            this.ready.clear();
            this.inProgress.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K nextWorkBlock(Collection<W> to, int size) {
        this.lock.lock();
        try {
            K nextKey = this.readyToInProgress();
            if (nextKey != null) {
                LinkedBlockingQueue<W> queue = this.pool.get(nextKey);
                this.drainTo(queue, to, size);
            }
            K k = nextKey;
            return k;
        }
        finally {
            this.lock.unlock();
        }
    }

    private int drainTo(LinkedBlockingQueue<W> deList, Collection<W> c, int maxElements) {
        W first;
        int n;
        for (n = 0; n < maxElements && (first = deList.poll()) != null; ++n) {
            c.add(first);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addWorkItem(K key, W item) {
        LinkedBlockingQueue<W> queue;
        this.lock.lock();
        try {
            queue = this.pool.get(key);
        }
        finally {
            this.lock.unlock();
        }
        if (queue != null) {
            this.enqueueingCallback.accept(queue, item);
            this.lock.lock();
            try {
                if (this.isDormant(key)) {
                    this.dormantToReady(key);
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return false;
    }

    public boolean finishWorkBlock(K key) {
        this.lock.lock();
        try {
            if (!this.isRegistered(key)) {
                boolean bl = false;
                return bl;
            }
            if (!this.inProgress.contains(key)) {
                throw new IllegalStateException("Client " + String.valueOf(key) + " not in progress");
            }
            if (this.moreWorkItems(key)) {
                this.inProgressToReady(key);
                boolean bl = true;
                return bl;
            }
            this.inProgressToDormant(key);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean moreWorkItems(K key) {
        LinkedBlockingQueue<W> leList = this.pool.get(key);
        return leList != null && !leList.isEmpty();
    }

    private boolean isInProgress(K key) {
        return this.inProgress.contains(key);
    }

    private boolean isReady(K key) {
        return this.ready.contains(key);
    }

    private boolean isRegistered(K key) {
        return this.pool.containsKey(key);
    }

    private boolean isDormant(K key) {
        return !this.isInProgress(key) && !this.isReady(key) && this.isRegistered(key);
    }

    private void inProgressToReady(K key) {
        this.inProgress.remove(key);
        this.ready.addIfNotPresent(key);
    }

    private void inProgressToDormant(K key) {
        this.inProgress.remove(key);
    }

    private void dormantToReady(K key) {
        this.ready.addIfNotPresent(key);
    }

    private K readyToInProgress() {
        K key = this.ready.poll();
        if (key != null) {
            this.inProgress.add(key);
        }
        return key;
    }

    static class WorkPoolFullException
    extends RuntimeException {
        public WorkPoolFullException(String msg) {
            super(msg);
        }
    }

    private static final class SetQueue<T> {
        private final Set<T> members = new HashSet<T>();
        private final Queue<T> queue = new LinkedList<T>();

        private SetQueue() {
        }

        public boolean addIfNotPresent(T item) {
            if (this.members.contains(item)) {
                return false;
            }
            this.members.add(item);
            this.queue.offer(item);
            return true;
        }

        public T poll() {
            T item = this.queue.poll();
            if (item != null) {
                this.members.remove(item);
            }
            return item;
        }

        public boolean contains(T item) {
            return this.members.contains(item);
        }

        public boolean isEmpty() {
            return this.members.isEmpty();
        }

        public boolean remove(T item) {
            this.queue.remove(item);
            return this.members.remove(item);
        }

        public void clear() {
            this.queue.clear();
            this.members.clear();
        }
    }
}

