/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.metrics;

import com.rabbitmq.client.amqp.metrics.MetricsCollector;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;

public class MicrometerMetricsCollector
implements MetricsCollector {
    private final AtomicLong connections;
    private final AtomicLong publishers;
    private final AtomicLong consumers;
    private final Counter publish;
    private final Counter publishAccepted;
    private final Counter publishRejected;
    private final Counter publishReleased;
    private final Counter consume;
    private final Counter consumeAccepted;
    private final Counter consumeRequeued;
    private final Counter consumeDiscarded;

    public MicrometerMetricsCollector(MeterRegistry registry) {
        this(registry, "rabbitmq.amqp");
    }

    public MicrometerMetricsCollector(MeterRegistry registry, String prefix) {
        this(registry, prefix, Collections.emptyList());
    }

    public MicrometerMetricsCollector(MeterRegistry registry, String prefix, String ... tags) {
        this(registry, prefix, (Iterable<Tag>)Tags.of((String[])tags));
    }

    public MicrometerMetricsCollector(MeterRegistry registry, String prefix, Iterable<Tag> tags) {
        this.connections = (AtomicLong)registry.gauge(prefix + ".connections", tags, (Number)new AtomicLong(0L));
        this.publishers = (AtomicLong)registry.gauge(prefix + ".publishers", tags, (Number)new AtomicLong(0L));
        this.consumers = (AtomicLong)registry.gauge(prefix + ".consumers", tags, (Number)new AtomicLong(0L));
        this.publish = registry.counter(prefix + ".published", tags);
        this.publishAccepted = registry.counter(prefix + ".published_accepted", tags);
        this.publishRejected = registry.counter(prefix + ".published_rejected", tags);
        this.publishReleased = registry.counter(prefix + ".published_released", tags);
        this.consume = registry.counter(prefix + ".consumed", tags);
        this.consumeAccepted = registry.counter(prefix + ".consumed_accepted", tags);
        this.consumeRequeued = registry.counter(prefix + ".consumed_requeued", tags);
        this.consumeDiscarded = registry.counter(prefix + ".consumed_discarded", tags);
    }

    @Override
    public void openConnection() {
        this.connections.incrementAndGet();
    }

    @Override
    public void closeConnection() {
        this.connections.decrementAndGet();
    }

    @Override
    public void openPublisher() {
        this.publishers.incrementAndGet();
    }

    @Override
    public void closePublisher() {
        this.publishers.decrementAndGet();
    }

    @Override
    public void openConsumer() {
        this.consumers.incrementAndGet();
    }

    @Override
    public void closeConsumer() {
        this.consumers.decrementAndGet();
    }

    @Override
    public void publish() {
        this.publish.increment();
    }

    @Override
    public void publishDisposition(MetricsCollector.PublishDisposition disposition) {
        switch (disposition) {
            case ACCEPTED: {
                this.publishAccepted.increment();
                break;
            }
            case REJECTED: {
                this.publishRejected.increment();
                break;
            }
            case RELEASED: {
                this.publishReleased.increment();
                break;
            }
        }
    }

    @Override
    public void consume() {
        this.consume.increment();
    }

    @Override
    public void consumeDisposition(MetricsCollector.ConsumeDisposition disposition) {
        switch (disposition) {
            case ACCEPTED: {
                this.consumeAccepted.increment();
                break;
            }
            case REQUEUED: {
                this.consumeRequeued.increment();
                break;
            }
            case DISCARDED: {
                this.consumeDiscarded.increment();
                break;
            }
        }
    }
}

