/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.oauth2;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.rabbitmq.client.amqp.oauth2.Token;
import com.rabbitmq.client.amqp.oauth2.TokenParser;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;

public class GsonTokenParser
implements TokenParser {
    private static final Gson GSON = new Gson();
    private static final TypeToken<Map<String, Object>> MAP_TYPE = new TypeToken<Map<String, Object>>(){};

    @Override
    public Token parse(String tokenAsString) {
        Map tokenAsMap = (Map)GSON.fromJson(tokenAsString, MAP_TYPE);
        String accessToken = (String)tokenAsMap.get("access_token");
        Duration expiresIn = Duration.ofSeconds(((Number)tokenAsMap.get("expires_in")).longValue());
        Instant expirationTime = Instant.ofEpochMilli(System.currentTimeMillis() + expiresIn.toMillis());
        return new DefaultTokenInfo(accessToken, expirationTime);
    }

    private static final class DefaultTokenInfo
    implements Token {
        private final String value;
        private final Instant expirationTime;

        private DefaultTokenInfo(String value, Instant expirationTime) {
            this.value = value;
            this.expirationTime = expirationTime;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public Instant expirationTime() {
            return this.expirationTime;
        }
    }
}

