/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.buffer;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.buffer.ProtonBufferAllocator;
import com.rabbitmq.qpid.protonj2.buffer.ProtonBufferClosedException;
import com.rabbitmq.qpid.protonj2.buffer.ProtonBufferReadOnlyException;
import com.rabbitmq.qpid.protonj2.buffer.ProtonCompositeBuffer;
import java.lang.ref.Cleaner;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Objects;

public abstract class ProtonBufferUtils {
    public static final int MAX_BUFFER_CAPACITY = 0x7FFFFFF7;
    private static Cleaner CLEANER;

    public static synchronized Cleaner getCleaner() {
        if (CLEANER == null) {
            CLEANER = Cleaner.create();
        }
        return CLEANER;
    }

    public static synchronized void setCleaner(Cleaner cleaner) {
        CLEANER = cleaner;
    }

    public static Cleaner.Cleanable registerCleanup(Object observed, ProtonBuffer buffer) {
        Objects.requireNonNull(observed, "The observed resource holder cannot be null");
        Objects.requireNonNull(buffer, "The buffer resource to be cleaned cannot be null");
        return ProtonBufferUtils.getCleaner().register(observed, () -> buffer.close());
    }

    public static String toString(ProtonBuffer buffer, Charset charset) {
        byte[] copy = new byte[buffer.getReadableBytes()];
        buffer.copyInto(buffer.getReadOffset(), copy, 0, copy.length);
        return new String(copy, 0, copy.length, charset);
    }

    public static byte[] toByteArray(ProtonBuffer buffer) {
        byte[] copy = new byte[buffer.getReadableBytes()];
        buffer.copyInto(buffer.getReadOffset(), copy, 0, copy.length);
        return copy;
    }

    public static byte[] toByteArray(ByteBuffer buffer) {
        byte[] copy = new byte[buffer.remaining()];
        buffer.get(copy, 0, copy.length);
        return copy;
    }

    public static ByteBuffer toByteBuffer(ProtonBuffer buffer) {
        ByteBuffer copy = ByteBuffer.allocate(buffer.getReadableBytes());
        buffer.copyInto(buffer.getReadOffset(), copy, 0, copy.remaining());
        return copy;
    }

    public static byte[] toByteArray(byte value) {
        return ProtonBufferUtils.writeByte(value, new byte[1], 0);
    }

    public static byte[] toByteArray(short value) {
        return ProtonBufferUtils.writeShort(value, new byte[2], 0);
    }

    public static byte[] toByteArray(int value) {
        return ProtonBufferUtils.writeInt(value, new byte[4], 0);
    }

    public static byte[] toByteArray(long value) {
        return ProtonBufferUtils.writeLong(value, new byte[8], 0);
    }

    public static byte[] writeChar(char value, byte[] destination, int offset) {
        return ProtonBufferUtils.writeShort((short)value, destination, offset);
    }

    public static byte[] writeByte(byte value, byte[] destination, int offset) {
        destination[offset] = value;
        return destination;
    }

    public static byte[] writeUnsignedByte(int value, byte[] destination, int offset) {
        destination[offset] = (byte)(value & 0xFF);
        return destination;
    }

    public static byte[] writeShort(short value, byte[] destination, int offset) {
        destination[offset++] = (byte)(value >>> 8);
        destination[offset++] = (byte)(value >>> 0);
        return destination;
    }

    public static byte[] writeUnsignedShort(int value, byte[] destination, int offset) {
        return ProtonBufferUtils.writeShort((short)(value & 0xFFFF), destination, offset);
    }

    public static byte[] writeInt(int value, byte[] destination, int offset) {
        destination[offset++] = (byte)(value >>> 24);
        destination[offset++] = (byte)(value >>> 16);
        destination[offset++] = (byte)(value >>> 8);
        destination[offset++] = (byte)(value >>> 0);
        return destination;
    }

    public static byte[] writeUnsignedInt(long value, byte[] destination, int offset) {
        return ProtonBufferUtils.writeInt((int)(value & 0xFFFFFFFFL), destination, offset);
    }

    public static byte[] writeLong(long value, byte[] destination, int offset) {
        destination[offset++] = (byte)(value >>> 56);
        destination[offset++] = (byte)(value >>> 48);
        destination[offset++] = (byte)(value >>> 40);
        destination[offset++] = (byte)(value >>> 32);
        destination[offset++] = (byte)(value >>> 24);
        destination[offset++] = (byte)(value >>> 16);
        destination[offset++] = (byte)(value >>> 8);
        destination[offset++] = (byte)(value >>> 0);
        return destination;
    }

    public static byte[] writeFloat(float value, byte[] destination, int offset) {
        return ProtonBufferUtils.writeInt(Float.floatToIntBits(value), destination, offset);
    }

    public static byte[] writeDouble(double value, byte[] destination, int offset) {
        return ProtonBufferUtils.writeLong(Double.doubleToLongBits(value), destination, offset);
    }

    public static byte readByte(byte[] array, int offset) {
        return array[offset];
    }

    public static int readUnsignedByte(byte[] array, int offset) {
        return array[offset] & 0xFF;
    }

    public static short readShort(byte[] array, int offset) {
        return (short)((array[offset++] & 0xFF) << 8 | (array[offset++] & 0xFF) << 0);
    }

    public static int readUnsignedShort(byte[] array, int offset) {
        return ProtonBufferUtils.readShort(array, offset) & 0xFFFF;
    }

    public static char readChar(byte[] array, int offset) {
        return (char)ProtonBufferUtils.readShort(array, offset);
    }

    public static int readInt(byte[] array, int offset) {
        return (array[offset++] & 0xFF) << 24 | (array[offset++] & 0xFF) << 16 | (array[offset++] & 0xFF) << 8 | (array[offset++] & 0xFF) << 0;
    }

    public static long readUnsignedInt(byte[] array, int offset) {
        return (long)ProtonBufferUtils.readInt(array, offset) & 0xFFFFFFFFL;
    }

    public static long readLong(byte[] array, int offset) {
        return (long)(array[offset++] & 0xFF) << 56 | (long)(array[offset++] & 0xFF) << 48 | (long)(array[offset++] & 0xFF) << 40 | (long)(array[offset++] & 0xFF) << 32 | (long)(array[offset++] & 0xFF) << 24 | (long)(array[offset++] & 0xFF) << 16 | (long)(array[offset++] & 0xFF) << 8 | (long)(array[offset++] & 0xFF) << 0;
    }

    public static float readFloat(byte[] array, int offset) {
        return Float.intBitsToFloat(ProtonBufferUtils.readInt(array, offset));
    }

    public static double readDouble(byte[] array, int offset) {
        return Double.longBitsToDouble(ProtonBufferUtils.readLong(array, offset));
    }

    public static void checkLength(int length) {
        if (length < 0) {
            throw new IndexOutOfBoundsException(String.format("The length value cannot be negative: %d", length));
        }
    }

    public static void checkIsNotNegative(int value, String description) {
        if (value < 0) {
            throw new IllegalArgumentException(String.format("The value cannot be negative: %d : %s", value, description));
        }
    }

    public static void checkIsNotNegative(long value, String description) {
        if (value < 0L) {
            throw new IllegalArgumentException(String.format("The value cannot be negative: %d : %s", value, description));
        }
    }

    public static void checkIndexIsNotNegative(int value, String description) {
        if (value < 0) {
            throw new IndexOutOfBoundsException(String.format("The index cannot be negative: %d : %s", value, description));
        }
    }

    public static void checkIndexIsNotNegative(long value, String description) {
        if (value < 0L) {
            throw new IndexOutOfBoundsException(String.format("The index cannot be negative: %d : %s", value, description));
        }
    }

    public static void checkArgumentIsNotNegative(int value, String description) {
        if (value < 0) {
            throw new IllegalArgumentException(String.format("The argument cannot be negative: %d : %s", value, description));
        }
    }

    public static void checkArgumentIsNotNegative(long value, String description) {
        if (value < 0L) {
            throw new IllegalArgumentException(String.format("The argument cannot be negative: %d : %s", value, description));
        }
    }

    public static void checkOffset(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException(String.format("The offset value cannot be negative: %d", offset));
        }
    }

    public static void checkIsClosed(ProtonBuffer buffer) {
        if (buffer.isClosed()) {
            throw new ProtonBufferClosedException("The buffer has already been closed: " + String.valueOf(buffer));
        }
    }

    public static void checkIsReadOnly(ProtonBuffer buffer) {
        if (buffer.isReadOnly()) {
            throw new ProtonBufferReadOnlyException("The buffer is read-only and not writes are allowed: " + String.valueOf(buffer));
        }
    }

    public static void checkBufferCanGrowTo(int currentCapacity, int additional) {
        ProtonBufferUtils.checkIsNotNegative(additional, "The additional capacity value cannot be negative");
        long newCapacity = (long)currentCapacity + (long)additional;
        if (newCapacity > 0x7FFFFFF7L) {
            throw new IllegalArgumentException("Requested new buffer capacity {" + newCapacity + "} is greater than the max allowed size: 2147483639");
        }
    }

    public static void checkImplicitGrowthLimit(int implicitCapacity, int currentCapacity) {
        if (implicitCapacity < currentCapacity) {
            throw new IndexOutOfBoundsException("Implicit capacity limit (" + implicitCapacity + ") cannot be less than capacity (" + currentCapacity + ")");
        }
        if (implicitCapacity > 0x7FFFFFF7) {
            throw new IndexOutOfBoundsException("Implicit capacity limit (" + implicitCapacity + ") cannot be greater than max buffer size (2147483639)");
        }
    }

    public static ProtonBufferClosedException genericBufferIsClosed(ProtonBuffer buffer) {
        return new ProtonBufferClosedException("This buffer is closed: " + String.valueOf(buffer));
    }

    public static ProtonBufferReadOnlyException genericBufferIsReadOnly(ProtonBuffer buffer) {
        return new ProtonBufferReadOnlyException("This buffer is read only: " + String.valueOf(buffer));
    }

    public static IndexOutOfBoundsException genericOutOfBounds(ProtonBuffer buffer, int index) {
        return new IndexOutOfBoundsException("Index " + index + " is out of bounds: [read 0 to " + buffer.getWriteOffset() + ", write 0 to " + buffer.capacity() + "].");
    }

    public static boolean equals(ProtonBuffer left, ProtonBuffer right) {
        if (left == right) {
            return true;
        }
        int length = left.getReadableBytes();
        if (length != right.getReadableBytes()) {
            return false;
        }
        return ProtonBufferUtils.equalsImpl(left, left.getReadOffset(), right, right.getReadOffset(), length);
    }

    public static boolean equals(ProtonBuffer left, ProtonBuffer right, int length) {
        Objects.requireNonNull(left, "The left hand buffer cannot be null");
        Objects.requireNonNull(right, "The right hand buffer cannot be null");
        return ProtonBufferUtils.equalsImpl(left, left.getReadOffset(), right, right.getReadOffset(), length);
    }

    public static boolean equals(ProtonBuffer left, int leftStartIndex, ProtonBuffer right, int rightStartIndex, int length) {
        Objects.requireNonNull(left, "The left hand buffer cannot be null");
        Objects.requireNonNull(right, "The right hand buffer cannot be null");
        ProtonBufferUtils.checkArgumentIsNotNegative(leftStartIndex, "The left hand buffer start index cannot be negative");
        ProtonBufferUtils.checkArgumentIsNotNegative(rightStartIndex, "The right hand buffer start index cannot be negative");
        ProtonBufferUtils.checkArgumentIsNotNegative(length, "The comparison length cannot be negative");
        return ProtonBufferUtils.equalsImpl(left, leftStartIndex, right, rightStartIndex, length);
    }

    private static boolean equalsImpl(ProtonBuffer left, int leftStartIndex, ProtonBuffer right, int rightStartIndex, int length) {
        int i;
        if (left.getWriteOffset() - length < leftStartIndex || right.getWriteOffset() - length < rightStartIndex) {
            return false;
        }
        int longCount = length >>> 3;
        int byteCount = length & 7;
        for (i = longCount; i > 0; --i) {
            if (left.getLong(leftStartIndex) != right.getLong(rightStartIndex)) {
                return false;
            }
            leftStartIndex += 8;
            rightStartIndex += 8;
        }
        for (i = byteCount; i > 0; --i) {
            if (left.getByte(leftStartIndex) != right.getByte(rightStartIndex)) {
                return false;
            }
            ++leftStartIndex;
            ++rightStartIndex;
        }
        return true;
    }

    public static int hashCode(ProtonBuffer buffer) {
        int i;
        int readable = buffer.getReadableBytes();
        int readableInts = readable >>> 2;
        int remainingBytes = readable & 3;
        int hash = 1;
        int position = buffer.getReadOffset();
        for (i = readableInts; i > 0; --i) {
            hash = 31 * hash + buffer.getInt(position);
            position += 4;
        }
        for (i = remainingBytes; i > 0; --i) {
            hash = 31 * hash + buffer.getByte(position++);
        }
        if (hash == 0) {
            hash = 1;
        }
        return hash;
    }

    public static int compare(ProtonBuffer lhs, ProtonBuffer rhs) {
        int length = lhs.getReadOffset() + Math.min(lhs.getReadableBytes(), rhs.getReadableBytes());
        int i = lhs.getReadOffset();
        int j = rhs.getReadOffset();
        while (i < length) {
            int cmp = Integer.compare(lhs.getByte(i) & 0xFF, rhs.getByte(j) & 0xFF);
            if (cmp != 0) {
                return cmp;
            }
            ++i;
            ++j;
        }
        return lhs.getReadableBytes() - rhs.getReadableBytes();
    }

    static void writeCharSequence(CharSequence source, ProtonBuffer destination, Charset charset) {
        byte[] bytes = source.toString().getBytes(charset);
        destination.writeBytes(bytes);
    }

    public static CharSequence readCharSequence(ProtonBuffer source, int length, Charset charset) {
        CharSequence charSequence = ProtonBufferUtils.copyToCharSequence(source, source.getReadOffset(), length, charset);
        source.advanceReadOffset(length);
        return charSequence;
    }

    public static CharSequence copyToCharSequence(ProtonBuffer source, int offset, int length, Charset charset) {
        byte[] data = new byte[length];
        source.copyInto(offset, data, 0, length);
        return new String(data, 0, length, charset);
    }

    public static ProtonBufferAllocator unclosable(ProtonBufferAllocator allocator) {
        return new UnclosableBufferAllocator(allocator);
    }

    private static class UnclosableBufferAllocator
    implements ProtonBufferAllocator {
        private final ProtonBufferAllocator allocator;

        public UnclosableBufferAllocator(ProtonBufferAllocator allocator) {
            this.allocator = allocator;
        }

        @Override
        public ProtonBuffer outputBuffer(int initialCapacity) {
            return this.allocator.outputBuffer(initialCapacity);
        }

        @Override
        public ProtonBuffer allocate() {
            return this.allocator.allocate();
        }

        @Override
        public ProtonBuffer allocate(int initialCapacity) {
            return this.allocator.allocate(initialCapacity);
        }

        @Override
        public ProtonBuffer allocateHeapBuffer() {
            return this.allocator.allocateHeapBuffer();
        }

        @Override
        public ProtonBuffer allocateHeapBuffer(int initialCapacity) {
            return this.allocator.allocateHeapBuffer(initialCapacity);
        }

        @Override
        public ProtonCompositeBuffer composite() {
            return this.allocator.composite();
        }

        @Override
        public ProtonCompositeBuffer composite(ProtonBuffer buffer) {
            return this.allocator.composite(buffer);
        }

        @Override
        public ProtonCompositeBuffer composite(ProtonBuffer[] buffers) {
            return this.allocator.composite(buffers);
        }

        @Override
        public ProtonBuffer copy(byte[] array, int offset, int length) {
            return this.allocator.copy(array, offset, length);
        }
    }
}

