/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.client;

import com.rabbitmq.qpid.protonj2.client.DeliveryMode;
import com.rabbitmq.qpid.protonj2.client.SourceOptions;
import com.rabbitmq.qpid.protonj2.client.TargetOptions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class LinkOptions<T extends LinkOptions<T>> {
    private long requestTimeout = -1L;
    private long openTimeout = 15000L;
    private long closeTimeout = 60000L;
    private boolean autoSettle = true;
    private DeliveryMode deliveryMode = DeliveryMode.AT_LEAST_ONCE;
    private String linkName;
    private final SourceOptions source = new SourceOptions();
    private final TargetOptions target = new TargetOptions();
    private String[] offeredCapabilities;
    private String[] desiredCapabilities;
    private Map<String, Object> properties;

    public LinkOptions() {
    }

    public LinkOptions(LinkOptions<T> options) {
        if (options != null) {
            options.copyInto(this);
        }
    }

    public T autoSettle(boolean autoSettle) {
        this.autoSettle = autoSettle;
        return this.self();
    }

    public boolean autoSettle() {
        return this.autoSettle;
    }

    public T deliveryMode(DeliveryMode deliveryMode) {
        this.deliveryMode = deliveryMode;
        return this.self();
    }

    public DeliveryMode deliveryMode() {
        return this.deliveryMode;
    }

    public T linkName(String linkName) {
        this.linkName = linkName;
        return this.self();
    }

    public String linkName() {
        return this.linkName;
    }

    public long closeTimeout() {
        return this.closeTimeout;
    }

    public T closeTimeout(long closeTimeout) {
        return this.closeTimeout(closeTimeout, TimeUnit.MILLISECONDS);
    }

    public T closeTimeout(long timeout, TimeUnit units) {
        this.closeTimeout = units.toMillis(timeout);
        return this.self();
    }

    public long openTimeout() {
        return this.openTimeout;
    }

    public T openTimeout(long openTimeout) {
        return this.openTimeout(openTimeout, TimeUnit.MILLISECONDS);
    }

    public T openTimeout(long timeout, TimeUnit units) {
        this.openTimeout = units.toMillis(timeout);
        return this.self();
    }

    public long requestTimeout() {
        return this.requestTimeout;
    }

    public T requestTimeout(long requestTimeout) {
        return this.requestTimeout(requestTimeout, TimeUnit.MILLISECONDS);
    }

    public T requestTimeout(long timeout, TimeUnit units) {
        this.requestTimeout = units.toMillis(timeout);
        return this.self();
    }

    public String[] offeredCapabilities() {
        return this.offeredCapabilities;
    }

    public T offeredCapabilities(String ... offeredCapabilities) {
        this.offeredCapabilities = offeredCapabilities;
        return this.self();
    }

    public String[] desiredCapabilities() {
        return this.desiredCapabilities;
    }

    public T desiredCapabilities(String ... desiredCapabilities) {
        this.desiredCapabilities = desiredCapabilities;
        return this.self();
    }

    public Map<String, Object> properties() {
        return this.properties;
    }

    public T properties(Map<String, Object> properties) {
        this.properties = properties;
        return this.self();
    }

    public SourceOptions sourceOptions() {
        return this.source;
    }

    public TargetOptions targetOptions() {
        return this.target;
    }

    protected LinkOptions<T> copyInto(LinkOptions<T> other) {
        other.linkName(this.linkName);
        other.closeTimeout(this.closeTimeout);
        other.openTimeout(this.openTimeout);
        other.requestTimeout(this.requestTimeout);
        other.deliveryMode(this.deliveryMode);
        other.autoSettle(this.autoSettle);
        if (this.offeredCapabilities != null) {
            other.offeredCapabilities(Arrays.copyOf(this.offeredCapabilities, this.offeredCapabilities.length));
        }
        if (this.desiredCapabilities != null) {
            other.desiredCapabilities(Arrays.copyOf(this.desiredCapabilities, this.desiredCapabilities.length));
        }
        if (this.properties != null) {
            other.properties(new HashMap<String, Object>(this.properties));
        }
        this.source.copyInto(other.sourceOptions());
        this.target.copyInto(other.targetOptions());
        return this;
    }

    protected abstract T self();
}

