/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.client;

import com.rabbitmq.qpid.protonj2.client.AdvancedMessage;
import com.rabbitmq.qpid.protonj2.client.exceptions.ClientException;
import com.rabbitmq.qpid.protonj2.client.impl.ClientMessage;
import com.rabbitmq.qpid.protonj2.client.impl.ClientMessageSupport;
import com.rabbitmq.qpid.protonj2.types.messaging.AmqpSequence;
import com.rabbitmq.qpid.protonj2.types.messaging.AmqpValue;
import com.rabbitmq.qpid.protonj2.types.messaging.Data;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public interface Message<E> {
    public static <E> Message<E> create() {
        return ClientMessage.create();
    }

    public static <E> Message<E> create(E body) {
        return ClientMessage.create(new AmqpValue<E>(body));
    }

    public static Message<byte[]> create(byte[] body) {
        return ClientMessage.create(new Data(body));
    }

    public static <E> Message<List<E>> create(List<E> body) {
        return ClientMessage.create(new AmqpSequence<E>(body));
    }

    public static <K, V> Message<Map<K, V>> create(Map<K, V> body) {
        return ClientMessage.create(new AmqpValue<Map<K, V>>(body));
    }

    default public AdvancedMessage<E> toAdvancedMessage() throws ClientException {
        if (this instanceof AdvancedMessage) {
            return (AdvancedMessage)this;
        }
        return ClientMessageSupport.convertMessage(this);
    }

    public boolean durable() throws ClientException;

    public Message<E> durable(boolean var1) throws ClientException;

    public byte priority() throws ClientException;

    public Message<E> priority(byte var1) throws ClientException;

    public long timeToLive() throws ClientException;

    public Message<E> timeToLive(long var1) throws ClientException;

    public boolean firstAcquirer() throws ClientException;

    public Message<E> firstAcquirer(boolean var1) throws ClientException;

    public long deliveryCount() throws ClientException;

    public Message<E> deliveryCount(long var1) throws ClientException;

    public Object messageId() throws ClientException;

    public Message<E> messageId(Object var1) throws ClientException;

    public byte[] userId() throws ClientException;

    public Message<E> userId(byte[] var1) throws ClientException;

    public String to() throws ClientException;

    public Message<E> to(String var1) throws ClientException;

    public String subject() throws ClientException;

    public Message<E> subject(String var1) throws ClientException;

    public String replyTo() throws ClientException;

    public Message<E> replyTo(String var1) throws ClientException;

    public Object correlationId() throws ClientException;

    public Message<E> correlationId(Object var1) throws ClientException;

    public String contentType() throws ClientException;

    public Message<E> contentType(String var1) throws ClientException;

    public String contentEncoding() throws ClientException;

    public Message<?> contentEncoding(String var1) throws ClientException;

    public long absoluteExpiryTime() throws ClientException;

    public Message<E> absoluteExpiryTime(long var1) throws ClientException;

    public long creationTime() throws ClientException;

    public Message<E> creationTime(long var1) throws ClientException;

    public String groupId() throws ClientException;

    public Message<E> groupId(String var1) throws ClientException;

    public int groupSequence() throws ClientException;

    public Message<E> groupSequence(int var1) throws ClientException;

    public String replyToGroupId() throws ClientException;

    public Message<E> replyToGroupId(String var1) throws ClientException;

    public Object annotation(String var1) throws ClientException;

    public boolean hasAnnotation(String var1) throws ClientException;

    public boolean hasAnnotations() throws ClientException;

    public Object removeAnnotation(String var1) throws ClientException;

    public Message<E> forEachAnnotation(BiConsumer<String, Object> var1) throws ClientException;

    public Message<E> annotation(String var1, Object var2) throws ClientException;

    public Object property(String var1) throws ClientException;

    public Message<E> property(String var1, Object var2) throws ClientException;

    public boolean hasProperty(String var1) throws ClientException;

    public boolean hasProperties() throws ClientException;

    public Object removeProperty(String var1) throws ClientException;

    public Message<E> forEachProperty(BiConsumer<String, Object> var1) throws ClientException;

    public Object footer(String var1) throws ClientException;

    public boolean hasFooter(String var1) throws ClientException;

    public boolean hasFooters() throws ClientException;

    public Object removeFooter(String var1) throws ClientException;

    public Message<E> forEachFooter(BiConsumer<String, Object> var1) throws ClientException;

    public Message<E> footer(String var1, Object var2) throws ClientException;

    public E body() throws ClientException;

    public Message<E> body(E var1) throws ClientException;
}

