/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.client;

import com.rabbitmq.qpid.protonj2.client.LinkOptions;
import com.rabbitmq.qpid.protonj2.client.exceptions.ClientException;
import com.rabbitmq.qpid.protonj2.engine.DeliveryTagGenerator;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class SenderOptions
extends LinkOptions<SenderOptions>
implements Cloneable {
    private long sendTimeout = -1L;
    private Consumer<ClientException> closeHandler;
    private Supplier<DeliveryTagGenerator> tagGeneratorSupplier;

    public SenderOptions() {
    }

    public SenderOptions(SenderOptions options) {
        if (options != null) {
            options.copyInto(this);
        }
    }

    public long sendTimeout() {
        return this.sendTimeout;
    }

    public SenderOptions sendTimeout(long sendTimeout) {
        return this.sendTimeout(sendTimeout, TimeUnit.MILLISECONDS);
    }

    public SenderOptions sendTimeout(long timeout, TimeUnit units) {
        this.sendTimeout = units.toMillis(timeout);
        return this;
    }

    public SenderOptions closeHandler(Consumer<ClientException> closeHandler) {
        this.closeHandler = closeHandler;
        return this;
    }

    public Consumer<ClientException> closeHandler() {
        return this.closeHandler;
    }

    public SenderOptions clone() {
        return this.copyInto(new SenderOptions());
    }

    protected SenderOptions copyInto(SenderOptions other) {
        super.copyInto(other);
        other.sendTimeout(this.sendTimeout);
        other.deliveryTagGeneratorSupplier(this.tagGeneratorSupplier);
        return other;
    }

    public SenderOptions deliveryTagGeneratorSupplier(Supplier<DeliveryTagGenerator> supplier) {
        this.tagGeneratorSupplier = supplier;
        return this;
    }

    public Supplier<DeliveryTagGenerator> deliveryTagGeneratorSupplier() {
        return this.tagGeneratorSupplier;
    }

    @Override
    protected SenderOptions self() {
        return this;
    }
}

