/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.client;

import com.rabbitmq.qpid.protonj2.client.DeliveryState;
import com.rabbitmq.qpid.protonj2.client.DistributionMode;
import com.rabbitmq.qpid.protonj2.client.TerminusOptions;
import com.rabbitmq.qpid.protonj2.client.impl.ClientDeliveryState;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class SourceOptions
extends TerminusOptions<SourceOptions>
implements Cloneable {
    private static final DeliveryState.Type[] DEFAULT_OUTCOMES = new DeliveryState.Type[]{DeliveryState.Type.ACCEPTED, DeliveryState.Type.REJECTED, DeliveryState.Type.RELEASED, DeliveryState.Type.MODIFIED};
    public static final ClientDeliveryState DEFAULT_RECEIVER_OUTCOME = new ClientDeliveryState.ClientModified(true, false);
    private DistributionMode distributionMode;
    private DeliveryState defaultOutcome;
    private DeliveryState.Type[] outcomes = DEFAULT_OUTCOMES;
    private Map<String, Object> filters;

    public SourceOptions clone() {
        return this.copyInto(new SourceOptions());
    }

    protected SourceOptions copyInto(SourceOptions other) {
        super.copyInto(other);
        other.distributionMode(this.distributionMode);
        if (this.filters != null) {
            other.filters(new HashMap<String, Object>(this.filters));
        }
        return other;
    }

    public DistributionMode distributionMode() {
        return this.distributionMode;
    }

    public SourceOptions distributionMode(DistributionMode distributionMode) {
        this.distributionMode = distributionMode;
        return this.self();
    }

    public Map<String, Object> filters() {
        return this.filters;
    }

    public SourceOptions filters(Map<String, Object> filters) {
        this.filters = filters;
        return this.self();
    }

    public DeliveryState defaultOutcome() {
        return this.defaultOutcome;
    }

    public SourceOptions defaultOutcome(DeliveryState defaultOutcome) {
        this.defaultOutcome = defaultOutcome;
        return this.self();
    }

    public DeliveryState.Type[] outcomes() {
        return this.outcomes;
    }

    public SourceOptions outcomes(DeliveryState.Type ... outcomes) {
        this.outcomes = outcomes != null ? Arrays.copyOf(outcomes, outcomes.length) : null;
        return this.self();
    }

    @Override
    SourceOptions self() {
        return this;
    }
}

