/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransportOptions
implements Cloneable {
    public static final int DEFAULT_SEND_BUFFER_SIZE = 65536;
    public static final int DEFAULT_RECEIVE_BUFFER_SIZE = 65536;
    public static final int DEFAULT_TRAFFIC_CLASS = 0;
    public static final boolean DEFAULT_TCP_NO_DELAY = true;
    public static final boolean DEFAULT_TCP_KEEP_ALIVE = false;
    public static final int DEFAULT_SO_LINGER = Integer.MIN_VALUE;
    public static final int DEFAULT_SO_TIMEOUT = -1;
    public static final int DEFAULT_CONNECT_TIMEOUT = 60000;
    public static final int DEFAULT_TCP_PORT = 5672;
    public static final boolean DEFAULT_ALLOW_NATIVE_IO = true;
    public static final boolean DEFAULT_TRACE_BYTES = false;
    public static final int DEFAULT_LOCAL_PORT = 0;
    public static final boolean DEFAULT_USE_WEBSOCKETS = false;
    public static final boolean DEFAULT_WEBSOCKET_COMPRESSION = false;
    public static final int DEFAULT_WEBSOCKET_MAX_FRAME_SIZE = 65535;
    private static final String[] DEFAULT_NATIVEIO_PREFERENCES_ARRAY = new String[]{"EPOLL", "KQUEUE"};
    public static final List<String> DEFAULT_NATIVEIO_PREFERENCES = Collections.unmodifiableList(Arrays.asList(DEFAULT_NATIVEIO_PREFERENCES_ARRAY));
    private int sendBufferSize = 65536;
    private int receiveBufferSize = 65536;
    private int trafficClass = 0;
    private int connectTimeout = 60000;
    private int soTimeout = -1;
    private int soLinger = Integer.MIN_VALUE;
    private boolean tcpKeepAlive = false;
    private boolean tcpNoDelay = true;
    private int defaultTcpPort = 5672;
    private String localAddress;
    private int localPort = 0;
    private boolean allowNativeIO = true;
    private String[] nativeIOPreference = DEFAULT_NATIVEIO_PREFERENCES_ARRAY;
    private boolean traceBytes = false;
    private boolean useWebSockets = false;
    private String webSocketPath;
    private int webSocketMaxFrameSize = 65535;
    private boolean webSocketCompression = false;
    private final Map<String, String> webSocketHeaders = new HashMap<String, String>();

    public TransportOptions clone() {
        return this.copyInto(new TransportOptions());
    }

    public int sendBufferSize() {
        return this.sendBufferSize;
    }

    public TransportOptions sendBufferSize(int sendBufferSize) {
        if (sendBufferSize <= 0) {
            throw new IllegalArgumentException("The send buffer size must be > 0");
        }
        this.sendBufferSize = sendBufferSize;
        return this;
    }

    public int receiveBufferSize() {
        return this.receiveBufferSize;
    }

    public TransportOptions receiveBufferSize(int receiveBufferSize) {
        if (receiveBufferSize <= 0) {
            throw new IllegalArgumentException("The send buffer size must be > 0");
        }
        this.receiveBufferSize = receiveBufferSize;
        return this;
    }

    public int trafficClass() {
        return this.trafficClass;
    }

    public TransportOptions trafficClass(int trafficClass) {
        if (trafficClass < 0 || trafficClass > 255) {
            throw new IllegalArgumentException("Traffic class must be in the range [0..255]");
        }
        this.trafficClass = trafficClass;
        return this;
    }

    public int soTimeout() {
        return this.soTimeout;
    }

    public TransportOptions soTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
        return this;
    }

    public boolean tcpNoDelay() {
        return this.tcpNoDelay;
    }

    public TransportOptions tcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        return this;
    }

    public int soLinger() {
        return this.soLinger;
    }

    public TransportOptions soLinger(int soLinger) {
        this.soLinger = soLinger;
        return this;
    }

    public boolean tcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    public TransportOptions tcpKeepAlive(boolean keepAlive) {
        this.tcpKeepAlive = keepAlive;
        return this;
    }

    public int connectTimeout() {
        return this.connectTimeout;
    }

    public TransportOptions connectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public int defaultTcpPort() {
        return this.defaultTcpPort;
    }

    public TransportOptions defaultTcpPort(int defaultTcpPort) {
        this.defaultTcpPort = defaultTcpPort;
        return this;
    }

    public String localAddress() {
        return this.localAddress;
    }

    public TransportOptions localAddress(String localAddress) {
        this.localAddress = localAddress;
        return this;
    }

    public int localPort() {
        return this.localPort;
    }

    public TransportOptions localPort(int localPort) {
        this.localPort = localPort;
        return this;
    }

    public boolean allowNativeIO() {
        return this.allowNativeIO;
    }

    public TransportOptions allowNativeIO(boolean allowNativeIO) {
        this.allowNativeIO = allowNativeIO;
        return this;
    }

    public String[] nativeIOPreference() {
        return this.nativeIOPreference;
    }

    public void nativeIOPreference(String ... nativeIOPreference) {
        this.nativeIOPreference = nativeIOPreference == null || nativeIOPreference.length == 0 || nativeIOPreference.length == 1 && nativeIOPreference[0] == null ? DEFAULT_NATIVEIO_PREFERENCES_ARRAY : nativeIOPreference;
    }

    public boolean traceBytes() {
        return this.traceBytes;
    }

    public TransportOptions traceBytes(boolean traceBytes) {
        this.traceBytes = traceBytes;
        return this;
    }

    public boolean useWebSockets() {
        return this.useWebSockets;
    }

    public TransportOptions useWebSockets(boolean webSockets) {
        this.useWebSockets = webSockets;
        return this;
    }

    public String webSocketPath() {
        return this.webSocketPath;
    }

    public TransportOptions webSocketPath(String webSocketPath) {
        this.webSocketPath = webSocketPath;
        return this;
    }

    public Map<String, String> webSocketHeaders() {
        return this.webSocketHeaders;
    }

    public TransportOptions addWebSocketHeader(String key, String value) {
        this.webSocketHeaders.put(key, value);
        return this;
    }

    public int webSocketMaxFrameSize() {
        return this.webSocketMaxFrameSize;
    }

    public TransportOptions webSocketMaxFrameSize(int maxFrameSize) {
        this.webSocketMaxFrameSize = maxFrameSize;
        return this;
    }

    public boolean webSocketCompression() {
        return this.webSocketCompression;
    }

    public TransportOptions webSocketCompression(boolean enabled) {
        this.webSocketCompression = enabled;
        return this;
    }

    public TransportOptions copyInto(TransportOptions other) {
        other.connectTimeout(this.connectTimeout());
        other.receiveBufferSize(this.receiveBufferSize());
        other.sendBufferSize(this.sendBufferSize());
        other.soLinger(this.soLinger());
        other.soTimeout(this.soTimeout());
        other.tcpKeepAlive(this.tcpKeepAlive());
        other.tcpNoDelay(this.tcpNoDelay());
        other.trafficClass(this.trafficClass());
        other.defaultTcpPort(this.defaultTcpPort());
        other.allowNativeIO(this.allowNativeIO());
        other.nativeIOPreference(this.nativeIOPreference());
        other.traceBytes(this.traceBytes());
        other.localAddress(this.localAddress());
        other.localPort(this.localPort());
        other.useWebSockets(this.useWebSockets());
        other.webSocketPath(this.webSocketPath());
        other.webSocketHeaders().putAll(this.webSocketHeaders);
        other.webSocketMaxFrameSize(this.webSocketMaxFrameSize());
        other.webSocketCompression(this.webSocketCompression());
        return other;
    }
}

