/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.client.futures;

import com.rabbitmq.qpid.protonj2.client.exceptions.ClientException;
import com.rabbitmq.qpid.protonj2.client.futures.AsyncResult;
import com.rabbitmq.qpid.protonj2.client.futures.ClientSynchronization;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class ClientFuture<V>
implements Future<V>,
AsyncResult<V> {
    protected final ClientSynchronization<V> synchronization;
    protected static final int INCOMPLETE = 0;
    protected static final int COMPLETING = 1;
    protected static final int SUCCESS = 2;
    protected static final int FAILURE = 3;
    protected static final int CANCELLED = 4;
    protected static final AtomicIntegerFieldUpdater<ClientFuture> STATE_FIELD_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ClientFuture.class, "state");
    private volatile int state = 0;
    protected ExecutionException error;
    protected int waiting;
    protected V result;

    protected ClientFuture(ClientSynchronization<V> synchronization) {
        this.synchronization = synchronization;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (STATE_FIELD_UPDATER.compareAndSet(this, 0, 1)) {
            STATE_FIELD_UPDATER.lazySet(this, 4);
            ClientFuture clientFuture = this;
            synchronized (clientFuture) {
                if (this.waiting > 0) {
                    this.notifyAll();
                }
            }
            return true;
        }
        return false;
    }

    public boolean isFailed() {
        return this.error != null;
    }

    public V getResult() {
        return this.result;
    }

    @Override
    public boolean isCancelled() {
        return this.state > 3;
    }

    @Override
    public boolean isDone() {
        return this.isComplete() || this.isCancelled() || this.isFailed();
    }

    @Override
    public boolean isComplete() {
        return this.state > 1;
    }

    protected boolean isNotComplete() {
        return this.state <= 1;
    }

    protected int getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failed(ClientException result) {
        Objects.requireNonNull(result, "Cannot fail the Future type without providing an error cause");
        if (STATE_FIELD_UPDATER.compareAndSet(this, 0, 1)) {
            this.error = new ExecutionException(result);
            if (this.synchronization != null) {
                try {
                    this.synchronization.onPendingFailure(this.error);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            STATE_FIELD_UPDATER.lazySet(this, 3);
            ClientFuture clientFuture = this;
            synchronized (clientFuture) {
                if (this.waiting > 0) {
                    this.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete(V result) {
        if (STATE_FIELD_UPDATER.compareAndSet(this, 0, 1)) {
            this.result = result;
            if (this.synchronization != null) {
                try {
                    this.synchronization.onPendingSuccess(result);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            STATE_FIELD_UPDATER.lazySet(this, 2);
            ClientFuture clientFuture = this;
            synchronized (clientFuture) {
                if (this.waiting > 0) {
                    this.notifyAll();
                }
            }
        }
    }

    @Override
    public abstract V get() throws InterruptedException, ExecutionException;

    @Override
    public abstract V get(long var1, TimeUnit var3) throws InterruptedException, ExecutionException, TimeoutException;

    protected void tryCancelTask() {
    }
}

