/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.codec.decoders.messaging;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.codec.DecodeException;
import com.rabbitmq.qpid.protonj2.codec.DecoderState;
import com.rabbitmq.qpid.protonj2.codec.StreamDecoderState;
import com.rabbitmq.qpid.protonj2.codec.StreamTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.AbstractDescribedListTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.ListTypeDecoder;
import com.rabbitmq.qpid.protonj2.types.Symbol;
import com.rabbitmq.qpid.protonj2.types.UnsignedInteger;
import com.rabbitmq.qpid.protonj2.types.UnsignedLong;
import com.rabbitmq.qpid.protonj2.types.messaging.Target;
import com.rabbitmq.qpid.protonj2.types.messaging.TerminusDurability;
import com.rabbitmq.qpid.protonj2.types.messaging.TerminusExpiryPolicy;
import java.io.InputStream;

public final class TargetTypeDecoder
extends AbstractDescribedListTypeDecoder<Target> {
    private static final int MIN_TARGET_LIST_ENTRIES = 0;
    private static final int MAX_TARGET_LIST_ENTRIES = 7;

    @Override
    public Class<Target> getTypeClass() {
        return Target.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return Target.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Target.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Target readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        return this.readTarget(buffer, state, (ListTypeDecoder)TargetTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Target[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        Target[] result = new Target[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readTarget(buffer, state, (ListTypeDecoder)TargetTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    private Target readTarget(ProtonBuffer buffer, DecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Target target = new Target();
        int size = listDecoder.readSize(buffer, state);
        int count = listDecoder.readCount(buffer, state);
        if (count < 0) {
            throw new DecodeException("Not enough entries in Target list encoding: " + count);
        }
        if (count > 7) {
            throw new DecodeException("To many entries in Target list encoding: " + count);
        }
        block9: for (int index = 0; index < count; ++index) {
            switch (index) {
                case 0: {
                    target.setAddress(state.getDecoder().readString(buffer, state));
                    continue block9;
                }
                case 1: {
                    long durability = state.getDecoder().readUnsignedInteger(buffer, state, 0);
                    target.setDurable(TerminusDurability.valueOf(durability));
                    continue block9;
                }
                case 2: {
                    Symbol expiryPolicy = state.getDecoder().readSymbol(buffer, state);
                    target.setExpiryPolicy(expiryPolicy == null ? TerminusExpiryPolicy.SESSION_END : TerminusExpiryPolicy.valueOf(expiryPolicy));
                    continue block9;
                }
                case 3: {
                    UnsignedInteger timeout = state.getDecoder().readUnsignedInteger(buffer, state);
                    target.setTimeout(timeout == null ? UnsignedInteger.ZERO : timeout);
                    continue block9;
                }
                case 4: {
                    target.setDynamic(state.getDecoder().readBoolean(buffer, state, false));
                    continue block9;
                }
                case 5: {
                    target.setDynamicNodeProperties(state.getDecoder().readMap(buffer, state));
                    continue block9;
                }
                case 6: {
                    target.setCapabilities(state.getDecoder().readMultiple(buffer, state, Symbol.class));
                }
            }
        }
        return target;
    }

    @Override
    public Target readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        return this.readTarget(stream, state, (ListTypeDecoder)TargetTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Target[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        Target[] result = new Target[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readTarget(stream, state, (ListTypeDecoder)TargetTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    private Target readTarget(InputStream stream, StreamDecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Target target = new Target();
        int size = listDecoder.readSize(stream, state);
        int count = listDecoder.readCount(stream, state);
        if (count < 0) {
            throw new DecodeException("Not enough entries in Target list encoding: " + count);
        }
        if (count > 7) {
            throw new DecodeException("To many entries in Target list encoding: " + count);
        }
        block9: for (int index = 0; index < count; ++index) {
            switch (index) {
                case 0: {
                    target.setAddress(state.getDecoder().readString(stream, state));
                    continue block9;
                }
                case 1: {
                    long durability = state.getDecoder().readUnsignedInteger(stream, state, 0);
                    target.setDurable(TerminusDurability.valueOf(durability));
                    continue block9;
                }
                case 2: {
                    Symbol expiryPolicy = state.getDecoder().readSymbol(stream, state);
                    target.setExpiryPolicy(expiryPolicy == null ? TerminusExpiryPolicy.SESSION_END : TerminusExpiryPolicy.valueOf(expiryPolicy));
                    continue block9;
                }
                case 3: {
                    UnsignedInteger timeout = state.getDecoder().readUnsignedInteger(stream, state);
                    target.setTimeout(timeout == null ? UnsignedInteger.ZERO : timeout);
                    continue block9;
                }
                case 4: {
                    target.setDynamic(state.getDecoder().readBoolean(stream, state, false));
                    continue block9;
                }
                case 5: {
                    target.setDynamicNodeProperties(state.getDecoder().readMap(stream, state));
                    continue block9;
                }
                case 6: {
                    target.setCapabilities(state.getDecoder().readMultiple(stream, state, Symbol.class));
                }
            }
        }
        return target;
    }
}

