/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.codec.decoders.transport;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.codec.DecodeException;
import com.rabbitmq.qpid.protonj2.codec.Decoder;
import com.rabbitmq.qpid.protonj2.codec.DecoderState;
import com.rabbitmq.qpid.protonj2.codec.StreamDecoder;
import com.rabbitmq.qpid.protonj2.codec.StreamDecoderState;
import com.rabbitmq.qpid.protonj2.codec.StreamTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.AbstractDescribedListTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.ListTypeDecoder;
import com.rabbitmq.qpid.protonj2.types.Symbol;
import com.rabbitmq.qpid.protonj2.types.UnsignedLong;
import com.rabbitmq.qpid.protonj2.types.transport.ErrorCondition;
import java.io.InputStream;
import java.util.Map;

public final class ErrorConditionTypeDecoder
extends AbstractDescribedListTypeDecoder<ErrorCondition> {
    private static final int MIN_ERROR_CONDITION_LIST_ENTRIES = 1;
    private static final int MAX_ERROR_CONDITION_LIST_ENTRIES = 3;

    @Override
    public Class<ErrorCondition> getTypeClass() {
        return ErrorCondition.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return ErrorCondition.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return ErrorCondition.DESCRIPTOR_SYMBOL;
    }

    @Override
    public ErrorCondition readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        return this.readErrorCondition(buffer, state.getDecoder(), state, (ListTypeDecoder)ErrorConditionTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public ErrorCondition[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        ErrorCondition[] result = new ErrorCondition[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readErrorCondition(buffer, state.getDecoder(), state, (ListTypeDecoder)ErrorConditionTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    private ErrorCondition readErrorCondition(ProtonBuffer buffer, Decoder decoder, DecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        int size = listDecoder.readSize(buffer, state);
        int count = listDecoder.readCount(buffer, state);
        if (count < 1) {
            throw new DecodeException("Not enough entries in ErrorCondition list encoding: " + count);
        }
        if (count > 3) {
            throw new DecodeException("To many entries in ErrorCondition list encoding: " + count);
        }
        Symbol condition = null;
        String description = null;
        Map info = null;
        block5: for (int index = 0; index < count; ++index) {
            switch (index) {
                case 0: {
                    condition = decoder.readSymbol(buffer, state);
                    continue block5;
                }
                case 1: {
                    description = decoder.readString(buffer, state);
                    continue block5;
                }
                case 2: {
                    info = decoder.readMap(buffer, state);
                }
            }
        }
        return new ErrorCondition(condition, description, info);
    }

    @Override
    public ErrorCondition readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        return this.readErrorCondition(stream, state.getDecoder(), state, (ListTypeDecoder)ErrorConditionTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public ErrorCondition[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        ErrorCondition[] result = new ErrorCondition[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readErrorCondition(stream, state.getDecoder(), state, (ListTypeDecoder)ErrorConditionTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    private ErrorCondition readErrorCondition(InputStream stream, StreamDecoder decoder, StreamDecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        int size = listDecoder.readSize(stream, state);
        int count = listDecoder.readCount(stream, state);
        if (count < 1) {
            throw new DecodeException("Not enough entries in ErrorCondition list encoding: " + count);
        }
        if (count > 3) {
            throw new DecodeException("To many entries in ErrorCondition list encoding: " + count);
        }
        Symbol condition = null;
        String description = null;
        Map info = null;
        block5: for (int index = 0; index < count; ++index) {
            switch (index) {
                case 0: {
                    condition = decoder.readSymbol(stream, state);
                    continue block5;
                }
                case 1: {
                    description = decoder.readString(stream, state);
                    continue block5;
                }
                case 2: {
                    info = decoder.readMap(stream, state);
                }
            }
        }
        return new ErrorCondition(condition, description, info);
    }
}

