/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.engine;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.engine.EngineHandlerContext;
import com.rabbitmq.qpid.protonj2.engine.HeaderEnvelope;
import com.rabbitmq.qpid.protonj2.engine.IncomingAMQPEnvelope;
import com.rabbitmq.qpid.protonj2.engine.OutgoingAMQPEnvelope;
import com.rabbitmq.qpid.protonj2.engine.SASLEnvelope;
import com.rabbitmq.qpid.protonj2.engine.exceptions.EngineFailedException;

public interface EngineHandler {
    default public void handlerAdded(EngineHandlerContext context) {
    }

    default public void handlerRemoved(EngineHandlerContext context) {
    }

    default public void engineStarting(EngineHandlerContext context) {
    }

    default public void handleEngineStateChanged(EngineHandlerContext context) {
        context.fireEngineStateChanged();
    }

    default public void engineFailed(EngineHandlerContext context, EngineFailedException failure) {
        context.fireFailed(failure);
    }

    default public void handleRead(EngineHandlerContext context, ProtonBuffer buffer) {
        context.fireRead(buffer);
    }

    default public void handleRead(EngineHandlerContext context, HeaderEnvelope header) {
        context.fireRead(header);
    }

    default public void handleRead(EngineHandlerContext context, SASLEnvelope envelope) {
        context.fireRead(envelope);
    }

    default public void handleRead(EngineHandlerContext context, IncomingAMQPEnvelope envelope) {
        context.fireRead(envelope);
    }

    default public void handleWrite(EngineHandlerContext context, HeaderEnvelope envelope) {
        context.fireWrite(envelope);
    }

    default public void handleWrite(EngineHandlerContext context, OutgoingAMQPEnvelope envelope) {
        context.fireWrite(envelope);
    }

    default public void handleWrite(EngineHandlerContext context, SASLEnvelope envelope) {
        context.fireWrite(envelope);
    }

    default public void handleWrite(EngineHandlerContext context, ProtonBuffer buffer, Runnable ioComplete) {
        context.fireWrite(buffer, ioComplete);
    }
}

