/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.engine.impl;

import com.rabbitmq.qpid.protonj2.engine.Endpoint;
import com.rabbitmq.qpid.protonj2.engine.Engine;
import com.rabbitmq.qpid.protonj2.engine.EventHandler;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonAttachments;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonEngine;
import com.rabbitmq.qpid.protonj2.types.transport.ErrorCondition;

public abstract class ProtonEndpoint<E extends Endpoint<E>>
implements Endpoint<E> {
    protected final ProtonEngine engine;
    private ProtonAttachments attachments;
    private Object linkedResource;
    private ErrorCondition localError;
    private ErrorCondition remoteError;
    private EventHandler<E> remoteOpenHandler;
    private EventHandler<E> remoteCloseHandler;
    private EventHandler<E> localOpenHandler;
    private EventHandler<E> localCloseHandler;
    private EventHandler<Engine> engineShutdownHandler;

    public ProtonEndpoint(ProtonEngine engine) {
        this.engine = engine;
    }

    @Override
    public E setLinkedResource(Object resource) {
        this.linkedResource = resource;
        return this.self();
    }

    @Override
    public <T> T getLinkedResource() {
        return (T)this.linkedResource;
    }

    @Override
    public <T> T getLinkedResource(Class<T> typeClass) {
        return typeClass.cast(this.linkedResource);
    }

    @Override
    public ProtonEngine getEngine() {
        return this.engine;
    }

    @Override
    public ProtonAttachments getAttachments() {
        return this.attachments == null ? (this.attachments = new ProtonAttachments()) : this.attachments;
    }

    @Override
    public ErrorCondition getCondition() {
        return this.localError;
    }

    @Override
    public E setCondition(ErrorCondition condition) {
        this.localError = condition == null ? null : condition.copy();
        return this.self();
    }

    @Override
    public ErrorCondition getRemoteCondition() {
        return this.remoteError;
    }

    E setRemoteCondition(ErrorCondition condition) {
        this.remoteError = condition == null ? null : condition.copy();
        return this.self();
    }

    abstract E self();

    @Override
    public E openHandler(EventHandler<E> remoteOpenEventHandler) {
        this.remoteOpenHandler = remoteOpenEventHandler;
        return this.self();
    }

    EventHandler<E> openHandler() {
        return this.remoteOpenHandler;
    }

    E fireRemoteOpen() {
        if (this.remoteOpenHandler != null) {
            this.remoteOpenHandler.handle(this.self());
        }
        return this.self();
    }

    @Override
    public E closeHandler(EventHandler<E> remoteCloseEventHandler) {
        this.remoteCloseHandler = remoteCloseEventHandler;
        return this.self();
    }

    EventHandler<E> closeHandler() {
        return this.remoteCloseHandler;
    }

    E fireRemoteClose() {
        if (this.remoteCloseHandler != null) {
            this.remoteCloseHandler.handle(this.self());
        }
        return this.self();
    }

    @Override
    public E localOpenHandler(EventHandler<E> localOpenEventHandler) {
        this.localOpenHandler = localOpenEventHandler;
        return this.self();
    }

    EventHandler<E> localOpenHandler() {
        return this.localOpenHandler;
    }

    E fireLocalOpen() {
        if (this.localOpenHandler != null) {
            this.localOpenHandler.handle(this.self());
        }
        return this.self();
    }

    @Override
    public E localCloseHandler(EventHandler<E> localCloseEventHandler) {
        this.localCloseHandler = localCloseEventHandler;
        return this.self();
    }

    EventHandler<E> localCloseHandler() {
        return this.localCloseHandler;
    }

    E fireLocalClose() {
        if (this.localCloseHandler != null) {
            this.localCloseHandler.handle(this.self());
        }
        return this.self();
    }

    @Override
    public E engineShutdownHandler(EventHandler<Engine> engineShutdownEventHandler) {
        this.engineShutdownHandler = engineShutdownEventHandler;
        return this.self();
    }

    EventHandler<Engine> engineShutdownHandler() {
        return this.engineShutdownHandler;
    }

    Engine fireEngineShutdown() {
        if (this.engineShutdownHandler != null) {
            this.engineShutdownHandler.handle(this.engine);
        }
        return this.engine;
    }
}

