/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.engine.impl;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.buffer.ProtonBufferAllocator;
import com.rabbitmq.qpid.protonj2.codec.CodecFactory;
import com.rabbitmq.qpid.protonj2.codec.Encoder;
import com.rabbitmq.qpid.protonj2.codec.EncoderState;
import com.rabbitmq.qpid.protonj2.engine.Engine;
import com.rabbitmq.qpid.protonj2.engine.EventHandler;
import com.rabbitmq.qpid.protonj2.engine.OutgoingDelivery;
import com.rabbitmq.qpid.protonj2.engine.Sender;
import com.rabbitmq.qpid.protonj2.engine.Transaction;
import com.rabbitmq.qpid.protonj2.engine.TransactionController;
import com.rabbitmq.qpid.protonj2.engine.TransactionState;
import com.rabbitmq.qpid.protonj2.engine.exceptions.EngineFailedException;
import com.rabbitmq.qpid.protonj2.engine.exceptions.EngineStateException;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonDeliveryTagGenerator;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonEndpoint;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonSender;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonSession;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonTransaction;
import com.rabbitmq.qpid.protonj2.logging.ProtonLogger;
import com.rabbitmq.qpid.protonj2.logging.ProtonLoggerFactory;
import com.rabbitmq.qpid.protonj2.types.Symbol;
import com.rabbitmq.qpid.protonj2.types.messaging.AmqpValue;
import com.rabbitmq.qpid.protonj2.types.messaging.Rejected;
import com.rabbitmq.qpid.protonj2.types.messaging.Source;
import com.rabbitmq.qpid.protonj2.types.transactions.Coordinator;
import com.rabbitmq.qpid.protonj2.types.transactions.Declare;
import com.rabbitmq.qpid.protonj2.types.transactions.Declared;
import com.rabbitmq.qpid.protonj2.types.transactions.Discharge;
import com.rabbitmq.qpid.protonj2.types.transport.DeliveryState;
import com.rabbitmq.qpid.protonj2.types.transport.ErrorCondition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProtonTransactionController
extends ProtonEndpoint<TransactionController>
implements TransactionController {
    private static final ProtonLogger LOG = ProtonLoggerFactory.getLogger(ProtonTransactionController.class);
    private static final ProtonBuffer ENCODED_DECLARE;
    private final ProtonSender senderLink;
    private final Encoder commandEncoder = CodecFactory.getEncoder();
    private final ProtonBuffer encoding = ProtonBufferAllocator.defaultAllocator().allocate();
    private final Set<Transaction<TransactionController>> transactions = new HashSet<Transaction<TransactionController>>();
    private EventHandler<Transaction<TransactionController>> declaredEventHandler;
    private EventHandler<Transaction<TransactionController>> declareFailureEventHandler;
    private EventHandler<Transaction<TransactionController>> dischargedEventHandler;
    private EventHandler<Transaction<TransactionController>> dischargeFailureEventHandler;
    private EventHandler<TransactionController> parentEndpointClosedEventHandler;
    private List<EventHandler<TransactionController>> capacityObservers = new ArrayList<EventHandler<TransactionController>>();

    public ProtonTransactionController(ProtonSender senderLink) {
        super(senderLink.getEngine());
        this.senderLink = senderLink;
        this.senderLink.setDeliveryTagGenerator(ProtonDeliveryTagGenerator.BUILTIN.POOLED.createGenerator());
        this.senderLink.deliveryStateUpdatedHandler(this::handleDeliveryRemotelyUpdated).creditStateUpdateHandler(this::handleLinkCreditUpdated).openHandler(this::handleSenderLinkOpened).closeHandler(this::handleSenderLinkClosed).parentEndpointClosedHandler(this::handleParentEndpointClosed).localOpenHandler(this::handleSenderLinkLocallyOpened).localCloseHandler(this::handleSenderLinkLocallyClosed).engineShutdownHandler(this::handleEngineShutdown);
    }

    public ProtonSession getParent() {
        return this.senderLink.getSession();
    }

    @Override
    ProtonTransactionController self() {
        return this;
    }

    @Override
    public boolean hasCapacity() {
        return this.senderLink.isSendable();
    }

    @Override
    public ProtonTransactionController addCapacityAvailableHandler(EventHandler<TransactionController> handler) {
        if (this.hasCapacity()) {
            handler.handle(this);
        } else {
            this.capacityObservers.add(handler);
        }
        return this;
    }

    @Override
    public Collection<Transaction<TransactionController>> transactions() {
        return Collections.unmodifiableCollection(new ArrayList<Transaction<TransactionController>>(this.transactions));
    }

    public ProtonControllerTransaction newTransaction() {
        ProtonControllerTransaction txn = new ProtonControllerTransaction(this);
        this.transactions.add(txn);
        return txn;
    }

    @Override
    public Transaction<TransactionController> declare() {
        if (!this.senderLink.isSendable()) {
            throw new IllegalStateException("Cannot Declare due to current capacity restrictions.");
        }
        ProtonControllerTransaction transaction = this.newTransaction();
        this.declare(transaction);
        return transaction;
    }

    @Override
    public TransactionController declare(Transaction<TransactionController> transaction) {
        if (!this.senderLink.isSendable()) {
            throw new IllegalStateException("Cannot Declare due to current capacity restrictions.");
        }
        if (transaction.getState() != TransactionState.IDLE) {
            throw new IllegalStateException("Cannot declare a transaction that has already been used previously");
        }
        if (transaction.parent() != this) {
            throw new IllegalArgumentException("Cannot declare a transaction that was created by another controller.");
        }
        ProtonControllerTransaction protonTransaction = (ProtonControllerTransaction)transaction;
        protonTransaction.setState(TransactionState.DECLARING);
        OutgoingDelivery command = this.senderLink.next();
        command.setLinkedResource(protonTransaction);
        command.writeBytes(ENCODED_DECLARE.copy(true));
        return this;
    }

    @Override
    public TransactionController discharge(Transaction<TransactionController> transaction, boolean failed) {
        if (transaction.getState() != TransactionState.DECLARED) {
            throw new IllegalStateException("Cannot discharge a transaction that is not currently actively declared.");
        }
        if (transaction.parent() != this) {
            throw new IllegalArgumentException("Cannot discharge a transaction that was created by another controller.");
        }
        if (!this.senderLink.isSendable()) {
            throw new IllegalStateException("Cannot discharge transaction due to current capacity restrictions.");
        }
        ProtonTransaction protonTxn = (ProtonTransaction)transaction;
        protonTxn.setState(TransactionState.DISCHARGING);
        protonTxn.setDischargeState(failed ? Transaction.DischargeState.ROLLBACK : Transaction.DischargeState.COMMIT);
        Discharge discharge = new Discharge();
        discharge.setFail(failed);
        discharge.setTxnId(transaction.getTxnId());
        this.commandEncoder.writeObject(this.encoding.clear(), this.commandEncoder.getCachedEncoderState(), new AmqpValue<Discharge>(discharge));
        OutgoingDelivery command = this.senderLink.next();
        command.setMessageFormat(0);
        command.setLinkedResource(transaction);
        command.writeBytes(this.encoding);
        return this;
    }

    @Override
    public TransactionController declaredHandler(EventHandler<Transaction<TransactionController>> declaredEventHandler) {
        this.declaredEventHandler = declaredEventHandler;
        return this;
    }

    @Override
    public TransactionController declareFailureHandler(EventHandler<Transaction<TransactionController>> declareFailureEventHandler) {
        this.declareFailureEventHandler = declareFailureEventHandler;
        return this;
    }

    @Override
    public TransactionController dischargedHandler(EventHandler<Transaction<TransactionController>> dischargedEventHandler) {
        this.dischargedEventHandler = dischargedEventHandler;
        return this;
    }

    @Override
    public TransactionController dischargeFailureHandler(EventHandler<Transaction<TransactionController>> dischargeFailureEventHandler) {
        this.dischargeFailureEventHandler = dischargeFailureEventHandler;
        return this;
    }

    @Override
    public TransactionController parentEndpointClosedHandler(EventHandler<TransactionController> handler) {
        this.parentEndpointClosedEventHandler = handler;
        return this.self();
    }

    private void fireParentEndpointClosed() {
        if (this.parentEndpointClosedEventHandler != null && this.isLocallyOpen()) {
            this.parentEndpointClosedEventHandler.handle(this.self());
        }
    }

    private void fireDeclaredEvent(ProtonControllerTransaction transaction) {
        if (this.declaredEventHandler != null) {
            this.declaredEventHandler.handle(transaction);
        } else {
            LOG.debug("Transaction {} declared successfully but no handler registered to signal result", (Object)transaction);
        }
    }

    private void fireDeclareFailureEvent(ProtonControllerTransaction transaction) {
        if (this.declareFailureEventHandler != null) {
            this.declareFailureEventHandler.handle(transaction);
        } else {
            LOG.debug("Transaction {} declare failed but no handler registered to signal result", (Object)transaction);
        }
    }

    private void fireDischargedEvent(ProtonControllerTransaction transaction) {
        if (this.dischargedEventHandler != null) {
            this.dischargedEventHandler.handle(transaction);
        } else {
            LOG.debug("Transaction {} discharged successfully but no handler registered to signal result", (Object)transaction);
        }
    }

    private void fireDischargeFailureEvent(ProtonControllerTransaction transaction) {
        if (this.dischargeFailureEventHandler != null) {
            this.dischargeFailureEventHandler.handle(transaction);
        } else {
            LOG.debug("Transaction {} discharge failed but no handler registered to signal result", (Object)transaction);
        }
    }

    @Override
    public TransactionController open() throws IllegalStateException, EngineStateException {
        this.senderLink.open();
        return this;
    }

    @Override
    public TransactionController close() throws EngineFailedException {
        this.senderLink.close();
        return this;
    }

    @Override
    public boolean isLocallyOpen() {
        return this.senderLink.isLocallyOpen();
    }

    @Override
    public boolean isLocallyClosed() {
        return this.senderLink.isLocallyClosed();
    }

    @Override
    public TransactionController setSource(Source source) throws IllegalStateException {
        this.senderLink.setSource(source);
        return this;
    }

    @Override
    public Source getSource() {
        return this.senderLink.getSource();
    }

    @Override
    public TransactionController setCoordinator(Coordinator coordinator) throws IllegalStateException {
        this.senderLink.setTarget(coordinator);
        return this;
    }

    @Override
    public Coordinator getCoordinator() {
        return (Coordinator)this.senderLink.getTarget();
    }

    @Override
    public ErrorCondition getCondition() {
        return this.senderLink.getCondition();
    }

    @Override
    public TransactionController setCondition(ErrorCondition condition) {
        this.senderLink.setCondition(condition);
        return this;
    }

    @Override
    public Map<Symbol, Object> getProperties() {
        return this.senderLink.getProperties();
    }

    @Override
    public TransactionController setProperties(Map<Symbol, Object> properties) throws IllegalStateException {
        this.senderLink.setProperties((Map)properties);
        return this;
    }

    @Override
    public TransactionController setOfferedCapabilities(Symbol ... offeredCapabilities) throws IllegalStateException {
        this.senderLink.setOfferedCapabilities(offeredCapabilities);
        return this;
    }

    @Override
    public Symbol[] getOfferedCapabilities() {
        return this.senderLink.getOfferedCapabilities();
    }

    @Override
    public TransactionController setDesiredCapabilities(Symbol ... desiredCapabilities) throws IllegalStateException {
        this.senderLink.setDesiredCapabilities(desiredCapabilities);
        return this;
    }

    @Override
    public Symbol[] getDesiredCapabilities() {
        return this.senderLink.getDesiredCapabilities();
    }

    @Override
    public boolean isRemotelyOpen() {
        return this.senderLink.isRemotelyOpen();
    }

    @Override
    public boolean isRemotelyClosed() {
        return this.senderLink.isRemotelyClosed();
    }

    @Override
    public Symbol[] getRemoteOfferedCapabilities() {
        return this.senderLink.getRemoteOfferedCapabilities();
    }

    @Override
    public Symbol[] getRemoteDesiredCapabilities() {
        return this.senderLink.getRemoteDesiredCapabilities();
    }

    @Override
    public Map<Symbol, Object> getRemoteProperties() {
        return this.senderLink.getRemoteProperties();
    }

    @Override
    public ErrorCondition getRemoteCondition() {
        return this.senderLink.getRemoteCondition();
    }

    @Override
    public Source getRemoteSource() {
        return this.senderLink.getRemoteSource();
    }

    @Override
    public Coordinator getRemoteCoordinator() {
        return (Coordinator)this.senderLink.getRemoteTarget();
    }

    private void handleSenderLinkLocallyOpened(Sender sender) {
        this.fireLocalOpen();
    }

    private void handleSenderLinkLocallyClosed(Sender sender) {
        this.fireLocalClose();
    }

    private void handleSenderLinkOpened(Sender sender) {
        this.fireRemoteOpen();
    }

    private void handleSenderLinkClosed(Sender sender) {
        this.fireRemoteClose();
    }

    private void handleParentEndpointClosed(Sender sender) {
        this.fireParentEndpointClosed();
    }

    private void handleEngineShutdown(Engine engine) {
        this.fireEngineShutdown();
    }

    private void handleLinkCreditUpdated(Sender sender) {
        if (sender.isSendable()) {
            this.capacityObservers.removeIf(handler -> {
                if (this.hasCapacity()) {
                    handler.handle(this);
                    return true;
                }
                return false;
            });
        }
        if (sender.isDraining()) {
            sender.drained();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleDeliveryRemotelyUpdated(OutgoingDelivery delivery) {
        ProtonControllerTransaction transaction = (ProtonControllerTransaction)delivery.getLinkedResource();
        DeliveryState state = delivery.getRemoteState();
        TransactionState transactionState = transaction.getState();
        try {
            switch (state.getType()) {
                case Declared: {
                    Declared declared = (Declared)state;
                    transaction.setState(TransactionState.DECLARED);
                    transaction.setTxnId(declared.getTxnId());
                    this.fireDeclaredEvent(transaction);
                    return;
                }
                case Accepted: {
                    transaction.setState(TransactionState.DISCHARGED);
                    this.transactions.remove(transaction);
                    this.fireDischargedEvent(transaction);
                    return;
                }
                default: {
                    if (state.getType() == DeliveryState.DeliveryStateType.Rejected) {
                        Rejected rejected = (Rejected)state;
                        transaction.setCondition(rejected.getError());
                    }
                    this.transactions.remove(transaction);
                    if (transactionState == TransactionState.DECLARING) {
                        transaction.setState(TransactionState.DECLARE_FAILED);
                        this.fireDeclareFailureEvent(transaction);
                        return;
                    } else {
                        transaction.setState(TransactionState.DISCHARGE_FAILED);
                        this.fireDischargeFailureEvent(transaction);
                    }
                    return;
                }
            }
        }
        finally {
            delivery.settle();
        }
    }

    static {
        Encoder declareEncoder = CodecFactory.getEncoder();
        EncoderState state = declareEncoder.newEncoderState();
        ENCODED_DECLARE = ProtonBufferAllocator.defaultAllocator().allocate();
        try {
            declareEncoder.writeObject(ENCODED_DECLARE, state, new AmqpValue<Declare>(new Declare()));
        }
        finally {
            ENCODED_DECLARE.convertToReadOnly();
            state.reset();
        }
    }

    private static final class ProtonControllerTransaction
    extends ProtonTransaction<TransactionController>
    implements Transaction<TransactionController> {
        private final ProtonTransactionController controller;

        public ProtonControllerTransaction(ProtonTransactionController controller) {
            this.controller = controller;
        }

        @Override
        public ProtonTransactionController parent() {
            return this.controller;
        }
    }
}

