/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.resource;

import com.rabbitmq.qpid.protonj2.resource.Resource;

public abstract class SharedResource<T extends Resource<T>>
implements Resource<T>,
AutoCloseable {
    private static final int CLOSED = -1;
    private static final int TRANSFERRED = -2;
    private int count;

    protected final T acquire() {
        if (this.count < 0) {
            throw this.resourceIsClosedException();
        }
        ++this.count;
        return this.self();
    }

    @Override
    public final void close() {
        int current = this.count;
        if (current-- == 0) {
            this.count = -1;
            this.releaseResourceOwnership();
        } else if (current >= 0) {
            --this.count;
        }
    }

    @Override
    public final T transfer() {
        if (this.count < 0) {
            throw this.resourceIsClosedException();
        }
        try {
            T t = this.transferTheResource();
            return t;
        }
        finally {
            this.count = -2;
            this.releaseResourceOwnership();
        }
    }

    @Override
    public final boolean isClosed() {
        return this.count < 0;
    }

    protected final boolean isShared() {
        return this.count > 0;
    }

    protected abstract void releaseResourceOwnership();

    protected abstract T transferTheResource();

    protected abstract RuntimeException resourceIsClosedException();

    private T self() {
        return (T)this;
    }
}

