/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.types.transport;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.types.transport.Attach;
import com.rabbitmq.qpid.protonj2.types.transport.Begin;
import com.rabbitmq.qpid.protonj2.types.transport.Close;
import com.rabbitmq.qpid.protonj2.types.transport.Detach;
import com.rabbitmq.qpid.protonj2.types.transport.Disposition;
import com.rabbitmq.qpid.protonj2.types.transport.End;
import com.rabbitmq.qpid.protonj2.types.transport.Flow;
import com.rabbitmq.qpid.protonj2.types.transport.Open;
import com.rabbitmq.qpid.protonj2.types.transport.Transfer;

public interface Performative {
    public PerformativeType getPerformativeType();

    public Performative copy();

    public <E> void invoke(PerformativeHandler<E> var1, ProtonBuffer var2, int var3, E var4);

    public static interface PerformativeHandler<E> {
        default public void handleOpen(Open open, ProtonBuffer payload, int channel, E context) {
        }

        default public void handleBegin(Begin begin, ProtonBuffer payload, int channel, E context) {
        }

        default public void handleAttach(Attach attach, ProtonBuffer payload, int channel, E context) {
        }

        default public void handleFlow(Flow flow, ProtonBuffer payload, int channel, E context) {
        }

        default public void handleTransfer(Transfer transfer, ProtonBuffer payload, int channel, E context) {
        }

        default public void handleDisposition(Disposition disposition, ProtonBuffer payload, int channel, E context) {
        }

        default public void handleDetach(Detach detach, ProtonBuffer payload, int channel, E context) {
        }

        default public void handleEnd(End end, ProtonBuffer payload, int channel, E context) {
        }

        default public void handleClose(Close close, ProtonBuffer payload, int channel, E context) {
        }
    }

    public static enum PerformativeType {
        ATTACH,
        BEGIN,
        CLOSE,
        DETACH,
        DISPOSITION,
        END,
        FLOW,
        OPEN,
        TRANSFER;

    }
}

