/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.client;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.jms.admin.RMQDestination;
import com.rabbitmq.jms.client.AmqpPropertiesCustomiser;
import com.rabbitmq.jms.client.BrowsingMessageQueue;
import com.rabbitmq.jms.client.DeliveryExecutor;
import com.rabbitmq.jms.client.GenericVersion;
import com.rabbitmq.jms.client.PublisherConfirmsUtils;
import com.rabbitmq.jms.client.PublishingListener;
import com.rabbitmq.jms.client.RMQConnection;
import com.rabbitmq.jms.client.RMQMessage;
import com.rabbitmq.jms.client.RMQMessageConsumer;
import com.rabbitmq.jms.client.RMQMessageProducer;
import com.rabbitmq.jms.client.ReceivingContextConsumer;
import com.rabbitmq.jms.client.SendingContextConsumer;
import com.rabbitmq.jms.client.SessionParams;
import com.rabbitmq.jms.client.message.RMQBytesMessage;
import com.rabbitmq.jms.client.message.RMQMapMessage;
import com.rabbitmq.jms.client.message.RMQObjectMessage;
import com.rabbitmq.jms.client.message.RMQStreamMessage;
import com.rabbitmq.jms.client.message.RMQTextMessage;
import com.rabbitmq.jms.parse.sql.SqlCompiler;
import com.rabbitmq.jms.parse.sql.SqlEvaluator;
import com.rabbitmq.jms.parse.sql.SqlExpressionType;
import com.rabbitmq.jms.parse.sql.SqlParser;
import com.rabbitmq.jms.parse.sql.SqlTokenStream;
import com.rabbitmq.jms.util.RMQJMSException;
import com.rabbitmq.jms.util.RMQJMSSelectorException;
import com.rabbitmq.jms.util.Util;
import com.rabbitmq.jms.util.WhiteListObjectInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeoutException;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMQSession
implements Session,
QueueSession,
TopicSession {
    private final Logger logger = LoggerFactory.getLogger(RMQSession.class);
    private final RMQConnection connection;
    private final boolean transacted;
    public static final int CLIENT_INDIVIDUAL_ACKNOWLEDGE = 4;
    private final int acknowledgeMode;
    private final boolean isIndividualAck;
    private boolean preferProducerMessageProperty = true;
    private final boolean requeueOnMessageListenerException;
    private final boolean cleanUpServerNamedQueuesForNonDurableTopics;
    private final AmqpPropertiesCustomiser amqpPropertiesCustomiser;
    private final boolean throwExceptionOnConsumerStartFailure;
    private final SendingContextConsumer sendingContextConsumer;
    private final ReceivingContextConsumer receivingContextConsumer;
    private final PublishingListener publishingListener;
    private final Channel channel;
    private volatile boolean closed = false;
    private volatile MessageListener messageListener;
    private final ArrayList<RMQMessageProducer> producers = new ArrayList();
    private final ArrayList<RMQMessageConsumer> consumers = new ArrayList();
    private final SortedSet<Long> unackedMessageTags = Collections.synchronizedSortedSet(new TreeSet());
    private final Map<String, RMQMessageConsumer> subscriptions;
    private final Object closeLock = new Object();
    private final Object commitLock = new Object();
    private static final long COMMIT_WAIT_MAX = 2000L;
    private boolean committing = false;
    private static final GenericVersion CLIENT_VERSION = new GenericVersion(RMQSession.class.getPackage().getImplementationVersion());
    private static final String RJMS_CLIENT_VERSION = CLIENT_VERSION.toString();
    private volatile String durableTopicSelectorExchange;
    private volatile String nonDurableTopicSelectorExchange;
    private static final String RJMS_COMPILED_SELECTOR_ARG = "rjms_erlang_selector";
    private static final String RJMS_VERSION_ARG = "rjms_version";
    private static final Map<String, Object> RJMS_SELECTOR_EXCHANGE_ARGS;
    static final Map<String, SqlExpressionType> JMS_TYPE_IDENTS;
    private static final String JMS_TOPIC_SELECTOR_EXCHANGE_TYPE = "x-jms-topic";
    private final DeliveryExecutor deliveryExecutor;
    private Set<Channel> browsingChannels = new HashSet<Channel>();
    private final Object bcLock = new Object();
    private List<String> trustedPackages = WhiteListObjectInputStream.DEFAULT_TRUSTED_PACKAGES;

    private static Map<String, SqlExpressionType> generateJMSTypeIdents() {
        HashMap<String, SqlExpressionType> map = new HashMap<String, SqlExpressionType>(6);
        map.put("JMSDeliveryMode", SqlExpressionType.STRING);
        map.put("JMSPriority", SqlExpressionType.ARITH);
        map.put("JMSMessageID", SqlExpressionType.STRING);
        map.put("JMSTimestamp", SqlExpressionType.ARITH);
        map.put("JMSCorrelationID", SqlExpressionType.STRING);
        map.put("JMSType", SqlExpressionType.STRING);
        return Collections.unmodifiableMap(map);
    }

    public RMQSession(SessionParams sessionParams) throws JMSException {
        if (sessionParams.getMode() < 0 || sessionParams.getMode() > 4) {
            throw new JMSException(String.format("cannot create session with acknowledgement mode = %d.", sessionParams.getMode()));
        }
        this.connection = sessionParams.getConnection();
        this.transacted = sessionParams.isTransacted();
        this.subscriptions = sessionParams.getSubscriptions();
        this.deliveryExecutor = new DeliveryExecutor(sessionParams.getOnMessageTimeoutMs());
        this.preferProducerMessageProperty = sessionParams.willPreferProducerMessageProperty();
        this.requeueOnMessageListenerException = sessionParams.willRequeueOnMessageListenerException();
        this.cleanUpServerNamedQueuesForNonDurableTopics = sessionParams.isCleanUpServerNamedQueuesForNonDurableTopics();
        this.amqpPropertiesCustomiser = sessionParams.getAmqpPropertiesCustomiser();
        this.throwExceptionOnConsumerStartFailure = sessionParams.willThrowExceptionOnConsumerStartFailure();
        this.sendingContextConsumer = sessionParams.getSendingContextConsumer();
        ReceivingContextConsumer receivingContextConsumer = this.receivingContextConsumer = sessionParams.getReceivingContextConsumer() == null ? ReceivingContextConsumer.NO_OP : sessionParams.getReceivingContextConsumer();
        if (this.transacted) {
            this.acknowledgeMode = 0;
            this.isIndividualAck = false;
        } else if (sessionParams.getMode() == 4) {
            this.acknowledgeMode = 2;
            this.isIndividualAck = true;
        } else {
            this.acknowledgeMode = sessionParams.getMode();
            this.isIndividualAck = false;
        }
        try {
            this.channel = this.connection.createRabbitChannel(this.transacted);
            this.publishingListener = sessionParams.getConfirmListener() != null ? PublisherConfirmsUtils.configurePublisherConfirmsSupport(this.channel, sessionParams.getConfirmListener()) : null;
        }
        catch (Exception x) {
            throw new RMQJMSException(x);
        }
    }

    public RMQSession(RMQConnection connection, boolean transacted, int onMessageTimeoutMs, int mode, Map<String, RMQMessageConsumer> subscriptions) throws JMSException {
        this(new SessionParams().setConnection(connection).setTransacted(transacted).setOnMessageTimeoutMs(onMessageTimeoutMs).setMode(mode).setSubscriptions(subscriptions));
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.illegalStateExceptionIfClosed();
        return new RMQBytesMessage();
    }

    private void illegalStateExceptionIfClosed() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("Session is closed");
        }
    }

    public MapMessage createMapMessage() throws JMSException {
        this.illegalStateExceptionIfClosed();
        return new RMQMapMessage();
    }

    public Message createMessage() throws JMSException {
        this.illegalStateExceptionIfClosed();
        return this.createTextMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.illegalStateExceptionIfClosed();
        return new RMQObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        this.illegalStateExceptionIfClosed();
        ObjectMessage message = this.createObjectMessage();
        message.setObject(object);
        return message;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.illegalStateExceptionIfClosed();
        return new RMQStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        this.illegalStateExceptionIfClosed();
        return new RMQTextMessage();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        this.illegalStateExceptionIfClosed();
        TextMessage msg = this.createTextMessage();
        msg.setText(text);
        return msg;
    }

    public boolean getTransacted() throws JMSException {
        this.illegalStateExceptionIfClosed();
        return this.getTransactedNoException();
    }

    private boolean getTransactedNoException() {
        return this.transacted;
    }

    public int getAcknowledgeMode() throws JMSException {
        this.illegalStateExceptionIfClosed();
        return this.getAcknowledgeModeNoException();
    }

    public List<String> getTrustedPackages() {
        return this.trustedPackages;
    }

    public void setTrustedPackages(List<String> trustedPackages) {
        this.trustedPackages = trustedPackages;
    }

    int getAcknowledgeModeNoException() {
        return this.acknowledgeMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean enterCommittingBlock() {
        Object object = this.commitLock;
        synchronized (object) {
            try {
                while (this.committing) {
                    this.commitLock.wait(2000L);
                }
                this.committing = true;
                return true;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leaveCommittingBlock() {
        Object object = this.commitLock;
        synchronized (object) {
            this.committing = false;
            this.commitLock.notifyAll();
        }
    }

    public void commit() throws JMSException {
        this.logger.trace("commit transaction on session {}", (Object)this);
        this.illegalStateExceptionIfClosed();
        if (!this.transacted) {
            throw new IllegalStateException("Session is not transacted");
        }
        if (this.enterCommittingBlock()) {
            try {
                this.channel.txCommit();
            }
            catch (Exception x) {
                this.logger.error("RabbitMQ exception on channel.txCommit() in session {}", (Object)this, (Object)x);
                throw new RMQJMSException(x);
            }
            finally {
                this.leaveCommittingBlock();
            }
        }
    }

    public void rollback() throws JMSException {
        this.logger.trace("rollback transaction on session {}", (Object)this);
        this.illegalStateExceptionIfClosed();
        if (!this.transacted) {
            throw new IllegalStateException("Session is not transacted");
        }
        if (this.enterCommittingBlock()) {
            try {
                this.channel.txRollback();
                this.channel.basicRecover(true);
            }
            catch (IOException x) {
                this.logger.error("RabbitMQ exception on channel.txRollback() or channel.basicRecover(true) in session {}", (Object)this, (Object)x);
                throw new RMQJMSException(x);
            }
            finally {
                this.leaveCommittingBlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void explicitAck(long deliveryTag) {
        if (this.enterCommittingBlock()) {
            try {
                this.channel.basicAck(deliveryTag, false);
            }
            catch (Exception x) {
                this.logger.error("Cannot acknowledge message received (dTag={})", (Object)deliveryTag, (Object)x);
            }
            finally {
                this.leaveCommittingBlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void explicitNack(long deliveryTag) {
        if (this.enterCommittingBlock()) {
            try {
                this.channel.basicNack(deliveryTag, false, true);
            }
            catch (Exception x) {
                this.logger.warn("Cannot reject/requeue message received (dTag={})", (Object)deliveryTag, (Object)x);
            }
            finally {
                this.leaveCommittingBlock();
            }
        }
    }

    public void close() throws JMSException {
        this.getConnection().sessionClose(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalClose() throws JMSException {
        if (this.closed) {
            return;
        }
        this.logger.trace("close session {}", (Object)this);
        Object object = this.closeLock;
        synchronized (object) {
            try {
                this.closeAllConsumers();
                if (this.getTransactedNoException()) {
                    this.rollback();
                }
                this.deliveryExecutor.close();
                for (RMQMessageProducer producer : this.producers) {
                    producer.internalClose();
                }
                this.producers.clear();
                if (this.getTransactedNoException()) {
                    this.commit();
                }
                this.closeRabbitChannels();
            }
            finally {
                this.closed = true;
            }
        }
    }

    private void closeAllConsumers() {
        for (RMQMessageConsumer consumer : this.consumers) {
            try {
                consumer.internalClose();
            }
            catch (JMSException x) {
                this.logger.error("Consumer ({}) cannot be closed", (Object)consumer, (Object)x);
            }
        }
        this.consumers.clear();
    }

    void deliverMessage(RMQMessage rmqMessage, MessageListener messageListener) throws JMSException, InterruptedException {
        this.deliveryExecutor.deliverMessageWithProtection(rmqMessage, messageListener);
    }

    private void closeRabbitChannels() throws JMSException {
        this.clearBrowsingChannels();
        if (this.channel == null) {
            return;
        }
        try {
            this.channel.close();
        }
        catch (ShutdownSignalException shutdownSignalException) {
        }
        catch (Exception x) {
            if (x instanceof IOException) {
                IOException ioe = (IOException)x;
                if (!(ioe.getCause() instanceof ShutdownSignalException)) {
                    this.logger.warn("RabbitMQ channel({}) failed to close on session {}", new Object[]{this.channel, this, ioe});
                    throw new RMQJMSException(ioe);
                }
            }
            if (x instanceof TimeoutException) {
                TimeoutException te = (TimeoutException)x;
                this.logger.warn("RabbitMQ channel({}) timed out trying to close session {}", new Object[]{this.channel, this, te});
                throw new RMQJMSException(te);
            }
            throw new RMQJMSException("Unexpected exception from channel.close()", x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() throws JMSException {
        this.illegalStateExceptionIfClosed();
        if (this.getTransactedNoException()) {
            throw new IllegalStateException("Session is transacted.");
        }
        SortedSet<Long> sortedSet = this.unackedMessageTags;
        synchronized (sortedSet) {
            if (!this.unackedMessageTags.isEmpty()) {
                try {
                    this.channel.basicRecover(true);
                }
                catch (IOException x) {
                    this.logger.warn("basicRecover on channel({}) failed", (Object)this.channel, (Object)x);
                    throw new RMQJMSException(x);
                }
                this.unackedMessageTags.clear();
            }
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        this.illegalStateExceptionIfClosed();
        return this.messageListener;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void run() {
        throw new UnsupportedOperationException();
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        this.logger.trace("create producer for destination '{}' on session '{}'", (Object)destination, (Object)this);
        this.illegalStateExceptionIfClosed();
        RMQDestination dest = (RMQDestination)destination;
        this.declareDestinationIfNecessary(dest);
        RMQMessageProducer producer = new RMQMessageProducer(this, dest, this.preferProducerMessageProperty, this.amqpPropertiesCustomiser, this.sendingContextConsumer, this.publishingListener);
        this.producers.add(producer);
        return producer;
    }

    void declareDestinationIfNecessary(RMQDestination destination) throws JMSException {
        if (destination != null && !destination.isAmqp() && !destination.isDeclared()) {
            if (destination.isQueue()) {
                this.declareRMQQueue(destination, null, false, true);
            } else {
                this.declareTopic(destination);
            }
        }
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        this.illegalStateExceptionIfClosed();
        return this.createConsumerInternal((RMQDestination)destination, null, false, null);
    }

    boolean syncAllowed() {
        for (RMQMessageConsumer mc : this.consumers) {
            if (!mc.messageListenerIsSet()) continue;
            return false;
        }
        return true;
    }

    boolean aSyncAllowed() {
        for (RMQMessageConsumer mc : this.consumers) {
            if (0 == mc.getNumberOfReceives()) continue;
            return false;
        }
        return true;
    }

    private RMQMessageConsumer createConsumerInternal(RMQDestination dest, String uuidTag, boolean durableSubscriber, String jmsSelector) throws JMSException {
        String consumerTag = uuidTag != null ? uuidTag : Util.generateUUID("jms-cons-");
        this.logger.trace("create consumer for destination '{}' with consumerTag '{}' and selector '{}'", new Object[]{dest, consumerTag, jmsSelector});
        this.declareDestinationIfNecessary(dest);
        if (!dest.isQueue()) {
            try {
                String queueName = consumerTag;
                this.declareRMQQueue(dest, queueName, durableSubscriber, false);
                if (RMQSession.nullOrEmpty(jmsSelector)) {
                    this.channel.queueBind(queueName, dest.getAmqpExchangeName(), dest.getAmqpRoutingKey());
                } else {
                    String selectionExchange = this.getSelectionExchange(durableSubscriber);
                    this.channel.exchangeBind(selectionExchange, dest.getAmqpExchangeName(), dest.getAmqpRoutingKey());
                    this.bindSelectorQueue(dest, jmsSelector, queueName, selectionExchange);
                }
            }
            catch (IOException x) {
                this.logger.error("consumer with tag '{}' could not be created", (Object)consumerTag, (Object)x);
                throw new RMQJMSException("RabbitMQ Exception creating Consumer", x);
            }
        }
        RMQMessageConsumer consumer = new RMQMessageConsumer(this, dest, consumerTag, this.getConnection().isStopped(), jmsSelector, this.requeueOnMessageListenerException, this.throwExceptionOnConsumerStartFailure, this.receivingContextConsumer);
        this.consumers.add(consumer);
        return consumer;
    }

    private void bindSelectorQueue(RMQDestination dest, String jmsSelector, String queueName, String selectionExchange) throws InvalidSelectorException, IOException {
        SqlCompiler compiler = new SqlCompiler(new SqlEvaluator(new SqlParser(new SqlTokenStream(jmsSelector)), JMS_TYPE_IDENTS));
        if (!compiler.compileOk()) {
            throw new RMQJMSSelectorException(String.format("Selector expression failure: \"%s\".", jmsSelector));
        }
        HashMap<String, String> args = new HashMap<String, String>(5);
        args.put(RJMS_COMPILED_SELECTOR_ARG, compiler.compile());
        args.put(RJMS_VERSION_ARG, RJMS_CLIENT_VERSION);
        this.channel.queueBind(queueName, selectionExchange, dest.getAmqpRoutingKey(), args);
    }

    private String getSelectionExchange(boolean durableSubscriber) throws IOException {
        if (durableSubscriber) {
            return this.getDurableTopicSelectorExchange();
        }
        return this.getNonDurableTopicSelectorExchange();
    }

    private String getDurableTopicSelectorExchange() throws IOException {
        if (this.durableTopicSelectorExchange == null) {
            this.durableTopicSelectorExchange = Util.generateUUID("jms-dutop-slx-");
        }
        this.channel.exchangeDeclare(this.durableTopicSelectorExchange, JMS_TOPIC_SELECTOR_EXCHANGE_TYPE, true, true, RJMS_SELECTOR_EXCHANGE_ARGS);
        return this.durableTopicSelectorExchange;
    }

    private String getNonDurableTopicSelectorExchange() throws IOException {
        if (this.nonDurableTopicSelectorExchange == null) {
            this.nonDurableTopicSelectorExchange = Util.generateUUID("jms-ndtop-slx-");
        }
        this.channel.exchangeDeclare(this.nonDurableTopicSelectorExchange, JMS_TOPIC_SELECTOR_EXCHANGE_TYPE, false, true, RJMS_SELECTOR_EXCHANGE_ARGS);
        return this.nonDurableTopicSelectorExchange;
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        this.illegalStateExceptionIfClosed();
        if (RMQSession.nullOrEmpty(messageSelector)) {
            return this.createConsumer(destination);
        }
        if (RMQSession.isTopic(destination)) {
            return this.createConsumerInternal((RMQDestination)destination, null, false, messageSelector);
        }
        throw new UnsupportedOperationException();
    }

    private static boolean nullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    private static boolean isTopic(Destination destination) {
        return !((RMQDestination)destination).isQueue();
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        this.illegalStateExceptionIfClosed();
        if (RMQSession.nullOrEmpty(messageSelector)) {
            RMQMessageConsumer consumer = (RMQMessageConsumer)this.createConsumer(destination);
            consumer.setNoLocal(noLocal);
            return consumer;
        }
        if (RMQSession.isTopic(destination)) {
            RMQMessageConsumer consumer = this.createConsumerInternal((RMQDestination)destination, null, false, messageSelector);
            consumer.setNoLocal(noLocal);
            return consumer;
        }
        throw new UnsupportedOperationException();
    }

    public Queue createQueue(String queueName) throws JMSException {
        this.illegalStateExceptionIfClosed();
        RMQDestination dest = new RMQDestination(queueName, true, false);
        this.declareRMQQueue(dest, null, false, true);
        return dest;
    }

    private void declareRMQQueue(RMQDestination dest, String queueNameOverride, boolean durableSubscriber, boolean bind) throws JMSException {
        this.logger.trace("declare RabbitMQ queue for destination '{}', explicitName '{}', durableSubscriber={}", new Object[]{dest, queueNameOverride, durableSubscriber});
        String queueName = queueNameOverride != null ? queueNameOverride : dest.getQueueName();
        String exchangeName = dest.getAmqpExchangeName();
        String exchangeType = dest.amqpExchangeType();
        boolean durable = durableSubscriber || dest.isQueue() & !dest.isTemporary();
        boolean exclusive = dest.isTemporary() || !dest.isQueue() && !durableSubscriber;
        Map options = null;
        if (dest.isQueue()) {
            if (dest.noNeedToDeclareExchange()) {
                this.logger.warn("no need to declare built-in exchange for queue destination '{}'", (Object)dest);
            } else {
                this.logger.trace("declare RabbitMQ exchange for queue destinations '{}'", (Object)dest);
                try {
                    this.channel.exchangeDeclare(exchangeName, exchangeType, durable, false, false, null);
                }
                catch (Exception x) {
                    throw new RMQJMSException(x);
                }
            }
        }
        boolean autoDelete = this.cleanUpServerNamedQueuesForNonDurableTopics ? !durable && queueNameOverride != null && !dest.isQueue() : false;
        try {
            this.logger.debug("declare RabbitMQ queue name({}), durable({}), exclusive({}), auto-delete({}), properties({})", new Object[]{queueName, durable, exclusive, false, options});
            this.channel.queueDeclare(queueName, durable, exclusive, autoDelete, options);
        }
        catch (Exception x) {
            this.logger.error("RabbitMQ exception on queue declare name({}), durable({}), exclusive({}), auto-delete({}), properties({})", new Object[]{queueName, durable, exclusive, autoDelete, options, x});
            throw new RMQJMSException(x);
        }
        if (bind) {
            try {
                this.logger.debug("bind queue name({}), to exchange({}), with r-key({}), no arguments", new Object[]{queueName, exchangeName, queueName});
                this.channel.queueBind(queueName, exchangeName, queueName, null);
            }
            catch (Exception x) {
                this.logger.error("RabbitMQ exception on queue declare name({}), durable({}), exclusive({}), auto-delete({}), properties({})", new Object[]{queueName, durable, exclusive, false, options, x});
                throw new RMQJMSException(x);
            }
        }
        dest.setDeclared(true);
    }

    public Topic createTopic(String topicName) throws JMSException {
        this.illegalStateExceptionIfClosed();
        RMQDestination dest = new RMQDestination(topicName, false, false);
        this.declareTopic(dest);
        return dest;
    }

    private void declareTopic(RMQDestination dest) throws JMSException {
        if (dest.noNeedToDeclareExchange()) {
            this.logger.warn("no need to declare built-in exchange for topic destination '{}'", (Object)dest);
        } else {
            this.logger.trace("declare RabbitMQ exchange for topic destination '{}'", (Object)dest);
            try {
                this.channel.exchangeDeclare(dest.getAmqpExchangeName(), dest.amqpExchangeType(), !dest.isTemporary(), false, false, null);
            }
            catch (IOException x) {
                throw new RMQJMSException(x);
            }
        }
        dest.setDeclared(true);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return this.createDurableSubscriber(topic, name, null, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        this.illegalStateExceptionIfClosed();
        RMQDestination topicDest = (RMQDestination)topic;
        RMQMessageConsumer previousConsumer = this.subscriptions.get(name);
        if (previousConsumer != null) {
            RMQDestination prevDest = previousConsumer.getDestination();
            if (prevDest.equals(topicDest)) {
                if (!previousConsumer.isClosed()) {
                    this.logger.error("Subscription with name '{}' for topic '{}' already exists", (Object)name, (Object)topicDest);
                    throw new JMSException(String.format("Subscription with name [%s] and topic [%s] already exists", name, topicDest));
                }
                this.logger.warn("Re-subscribing to topic '{}' with name '{}'", (Object)topicDest, (Object)name);
            } else {
                this.logger.warn("Previous subscription with name '{}' was for topic '{}' and is replaced by one for topic '{}'", new Object[]{name, prevDest, topicDest});
                this.unsubscribe(name);
            }
        }
        RMQMessageConsumer consumer = this.createConsumerInternal(topicDest, name, true, messageSelector);
        consumer.setDurable(true);
        consumer.setNoLocal(noLocal);
        this.subscriptions.put(name, consumer);
        return consumer;
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        this.illegalStateExceptionIfClosed();
        return this.createBrowser(queue, null);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        RMQDestination rmqDest;
        this.illegalStateExceptionIfClosed();
        if (queue instanceof RMQDestination && (rmqDest = (RMQDestination)queue).isQueue()) {
            return new BrowsingMessageQueue(this, rmqDest, messageSelector, this.connection.getQueueBrowserReadMax(), this.receivingContextConsumer);
        }
        throw new UnsupportedOperationException("Unknown destination");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Channel getBrowsingChannel() throws JMSException {
        try {
            Object object = this.bcLock;
            synchronized (object) {
                Channel chan = this.getConnection().createRabbitChannel(false);
                this.browsingChannels.add(chan);
                return chan;
            }
        }
        catch (Exception e) {
            throw new RMQJMSException("Cannot create browsing channel", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearBrowsingChannels() {
        Object object = this.bcLock;
        synchronized (object) {
            for (Channel chan : this.browsingChannels) {
                try {
                    if (!chan.isOpen()) continue;
                    chan.close();
                }
                catch (Exception exception) {}
            }
            this.browsingChannels.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeBrowsingChannel(Channel chan) {
        try {
            Object object = this.bcLock;
            synchronized (object) {
                if (this.browsingChannels.remove(chan) && chan.isOpen()) {
                    chan.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        this.illegalStateExceptionIfClosed();
        return new RMQDestination(Util.generateUUID("jms-temp-queue-"), true, true);
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        this.illegalStateExceptionIfClosed();
        return new RMQDestination(Util.generateUUID("jms-temp-topic-"), false, true);
    }

    public void unsubscribe(String name) throws JMSException {
        this.illegalStateExceptionIfClosed();
        try {
            if (name != null && this.subscriptions.remove(name) != null) {
                this.channel.queueDelete(name);
            } else {
                this.logger.warn("Cannot unsubscribe subscription named '{}'", (Object)name);
            }
        }
        catch (IOException x) {
            this.logger.error("RabbitMQ Queue delete for queue named '{}' failed", (Object)name, (Object)x);
            throw new RMQJMSException(x);
        }
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        this.illegalStateExceptionIfClosed();
        return (QueueReceiver)this.createConsumer((Destination)queue);
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        this.illegalStateExceptionIfClosed();
        return (QueueReceiver)this.createConsumer((Destination)queue, messageSelector);
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        this.illegalStateExceptionIfClosed();
        return (QueueSender)this.createProducer((Destination)queue);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        this.illegalStateExceptionIfClosed();
        return (TopicSubscriber)this.createConsumer((Destination)topic);
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        this.illegalStateExceptionIfClosed();
        RMQMessageConsumer consumer = this.createConsumerInternal((RMQDestination)topic, null, false, messageSelector);
        consumer.setNoLocal(noLocal);
        return consumer;
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        this.illegalStateExceptionIfClosed();
        return (TopicPublisher)this.createProducer((Destination)topic);
    }

    RMQConnection getConnection() {
        return this.connection;
    }

    Channel getChannel() {
        return this.channel;
    }

    void consumerClose(RMQMessageConsumer consumer) throws JMSException {
        if (this.consumers.remove(consumer)) {
            consumer.internalClose();
        }
    }

    void removeProducer(RMQMessageProducer producer) {
        if (this.producers.remove(producer)) {
            producer.internalClose();
        }
    }

    boolean isAutoAck() {
        return this.getAcknowledgeModeNoException() != 2;
    }

    void pause() throws JMSException {
        for (RMQMessageConsumer consumer : this.consumers) {
            try {
                consumer.pause();
            }
            catch (JMSException e) {
                throw e;
            }
            catch (InterruptedException x) {
                this.logger.error("Consumer({}) pause interrupted", (Object)consumer, (Object)x);
                throw new RMQJMSException(x);
            }
            catch (Exception x) {
                this.logger.error("Error while pausing consumer({})", (Object)consumer, (Object)x);
                throw new RMQJMSException(x);
            }
        }
    }

    void resume() throws JMSException {
        for (RMQMessageConsumer consumer : this.consumers) {
            try {
                consumer.resume();
            }
            catch (IllegalStateException x) {
                throw new RMQJMSException(x);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unackedMessageReceived(long dTag) {
        if (!this.getTransactedNoException()) {
            SortedSet<Long> sortedSet = this.unackedMessageTags;
            synchronized (sortedSet) {
                this.unackedMessageTags.add(dTag);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acknowledgeMessage(RMQMessage message) throws JMSException {
        this.illegalStateExceptionIfClosed();
        boolean individualAck = this.getIndividualAck();
        boolean groupAck = true;
        if (!this.isAutoAck() && !this.unackedMessageTags.isEmpty()) {
            SortedSet<Long> sortedSet = this.unackedMessageTags;
            synchronized (sortedSet) {
                try {
                    if (individualAck) {
                        long messageTag = message.getRabbitDeliveryTag();
                        if (!this.unackedMessageTags.contains(messageTag)) {
                            return;
                        }
                        this.getChannel().basicAck(messageTag, false);
                        this.unackedMessageTags.remove(messageTag);
                    } else if (groupAck) {
                        long messageTag = message.getRabbitDeliveryTag();
                        SortedSet<Long> previousTags = this.unackedMessageTags.headSet(messageTag + 1L);
                        if (previousTags.isEmpty()) {
                            return;
                        }
                        this.getChannel().basicAck(previousTags.last().longValue(), true);
                        previousTags.clear();
                    } else {
                        this.getChannel().basicAck(this.unackedMessageTags.last().longValue(), true);
                        this.unackedMessageTags.clear();
                    }
                }
                catch (IOException x) {
                    this.logger.error("RabbitMQ exception on basicAck of message {}; on session '{}'", new Object[]{message, this, x});
                    throw new RMQJMSException(x);
                }
            }
        }
    }

    private final boolean getIndividualAck() {
        return this.isIndividualAck;
    }

    static {
        if (RJMS_CLIENT_VERSION.equals("0.0.0")) {
            System.out.println("WARNING: Running test version of RJMS Client with no version information.");
        }
        RJMS_SELECTOR_EXCHANGE_ARGS = Collections.singletonMap(RJMS_VERSION_ARG, RJMS_CLIENT_VERSION);
        JMS_TYPE_IDENTS = RMQSession.generateJMSTypeIdents();
    }
}

