/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.client;

import com.rabbitmq.client.Channel;
import com.rabbitmq.jms.client.ConfirmListener;
import com.rabbitmq.jms.client.PublisherConfirmContext;
import com.rabbitmq.jms.client.PublishingListener;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.Message;

class PublisherConfirmsUtils {
    PublisherConfirmsUtils() {
    }

    static PublishingListener configurePublisherConfirmsSupport(Channel channel, final ConfirmListener confirmListener) {
        final ConcurrentHashMap outstandingConfirms = new ConcurrentHashMap();
        final AtomicLong multipleLowerBound = new AtomicLong(1L);
        PublishingListener publishingListener = new PublishingListener(){

            @Override
            public void publish(Message message, long sequenceNumber) {
                outstandingConfirms.put(sequenceNumber, message);
            }
        };
        channel.addConfirmListener(new com.rabbitmq.client.ConfirmListener(){

            public void handleAck(long deliveryTag, boolean multiple) {
                PublisherConfirmsUtils.cleanPublisherConfirmsCorrelation(outstandingConfirms, multipleLowerBound, deliveryTag, multiple, new Consumer<Message>(){

                    @Override
                    public void accept(Message message) {
                        confirmListener.handle(new PublisherConfirmContext(message, true));
                    }
                });
            }

            public void handleNack(long deliveryTag, boolean multiple) {
                PublisherConfirmsUtils.cleanPublisherConfirmsCorrelation(outstandingConfirms, multipleLowerBound, deliveryTag, multiple, new Consumer<Message>(){

                    @Override
                    public void accept(Message message) {
                        confirmListener.handle(new PublisherConfirmContext(message, false));
                    }
                });
            }
        });
        return publishingListener;
    }

    private static void cleanPublisherConfirmsCorrelation(Map<Long, Message> outstandingConfirms, AtomicLong multipleLowerBound, long deliveryTag, boolean multiple, Consumer<Message> messageConsumer) {
        Long lowerBound = multipleLowerBound.get();
        if (multiple) {
            for (long i = lowerBound.longValue(); i <= deliveryTag; ++i) {
                Message message = outstandingConfirms.remove(i);
                if (message == null) continue;
                messageConsumer.accept(message);
            }
        } else {
            Message message = outstandingConfirms.remove(deliveryTag);
            if (message != null) {
                messageConsumer.accept(message);
            }
            if (deliveryTag == lowerBound + 1L) {
                multipleLowerBound.compareAndSet(lowerBound, deliveryTag);
            }
        }
    }

    private static interface Consumer<T> {
        public void accept(T var1);
    }
}

