/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.client.message;

import com.rabbitmq.jms.client.RMQMessage;
import com.rabbitmq.jms.util.DiscardingObjectOutput;
import com.rabbitmq.jms.util.IteratorEnum;
import com.rabbitmq.jms.util.RMQMessageFormatException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;

public class RMQMapMessage
extends RMQMessage
implements MapMessage {
    private Map<String, Serializable> data = new HashMap<String, Serializable>();

    public boolean getBoolean(String name) throws JMSException {
        Serializable o = this.data.get(name);
        if (o == null) {
            return false;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            return Boolean.parseBoolean((String)((Object)o));
        }
        throw new MessageFormatException(String.format("Unable to cast the object, %s, into the specified type %s", o, "boolean"));
    }

    public byte getByte(String name) throws JMSException {
        Serializable o = this.data.get(name);
        if (o == null) {
            throw new NumberFormatException(String.format("Unable to cast the object, %s, into the specified type %s", o, "byte"));
        }
        if (o instanceof Byte) {
            return (Byte)o;
        }
        if (o instanceof String) {
            return Byte.parseByte((String)((Object)o));
        }
        throw new MessageFormatException(String.format("Unable to cast the object, %s, into the specified type %s", o, "byte"));
    }

    public short getShort(String name) throws JMSException {
        Serializable o = this.data.get(name);
        if (o == null) {
            throw new NumberFormatException(String.format("Unable to cast the object, %s, into the specified type %s", o, "short"));
        }
        if (o instanceof Byte) {
            return ((Byte)o).byteValue();
        }
        if (o instanceof Short) {
            return (Short)o;
        }
        if (o instanceof String) {
            return Short.parseShort((String)((Object)o));
        }
        throw new MessageFormatException(String.format("Unable to cast the object, %s, into the specified type %s", o, "short"));
    }

    public char getChar(String name) throws JMSException {
        Serializable o = this.data.get(name);
        if (o == null) {
            throw new NumberFormatException(String.format("Unable to cast the object, %s, into the specified type %s", o, "char"));
        }
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        throw new MessageFormatException(String.format("Unable to cast the object, %s, into the specified type %s", o, "char"));
    }

    public int getInt(String name) throws JMSException {
        Serializable o = this.data.get(name);
        if (o == null) {
            throw new NumberFormatException(String.format("Unable to cast the object, %s, into the specified type %s", o, "int"));
        }
        if (o instanceof Byte) {
            return ((Byte)o).byteValue();
        }
        if (o instanceof Short) {
            return ((Short)o).shortValue();
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof String) {
            return Integer.parseInt((String)((Object)o));
        }
        throw new MessageFormatException(String.format("Unable to cast the object, %s, into the specified type %s", o, "int"));
    }

    public long getLong(String name) throws JMSException {
        Serializable o = this.data.get(name);
        if (o == null) {
            throw new NumberFormatException(String.format("Unable to cast the object, %s, into the specified type %s", o, "long"));
        }
        if (o instanceof Byte) {
            return ((Byte)o).byteValue();
        }
        if (o instanceof Short) {
            return ((Short)o).shortValue();
        }
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof String) {
            return Long.parseLong((String)((Object)o));
        }
        throw new MessageFormatException(String.format("Unable to cast the object, %s, into the specified type %s", o, "long"));
    }

    public float getFloat(String name) throws JMSException {
        Serializable o = this.data.get(name);
        if (o == null) {
            throw new NumberFormatException(String.format("Unable to cast the object, %s, into the specified type %s", o, "float"));
        }
        if (o instanceof Float) {
            return ((Float)o).floatValue();
        }
        if (o instanceof String) {
            return Float.parseFloat((String)((Object)o));
        }
        throw new MessageFormatException(String.format("Unable to cast the object, %s, into the specified type %s", o, "float"));
    }

    public double getDouble(String name) throws JMSException {
        Serializable o = this.data.get(name);
        if (o == null) {
            throw new NumberFormatException(String.format("Unable to cast the object, %s, into the specified type %s", o, "double"));
        }
        if (o instanceof Float) {
            return ((Float)o).floatValue();
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof String) {
            return Double.parseDouble((String)((Object)o));
        }
        throw new MessageFormatException(String.format("Unable to cast the object, %s, into the specified type %s", o, "double"));
    }

    public String getString(String name) throws JMSException {
        Serializable o = this.data.get(name);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)((Object)o);
        }
        if (o instanceof byte[]) {
            throw new MessageFormatException(String.format("Unable to cast the object, %s, into the specified type %s", o, "String"));
        }
        return o.toString();
    }

    public byte[] getBytes(String name) throws JMSException {
        Serializable o = this.data.get(name);
        if (o == null) {
            return null;
        }
        if (o instanceof byte[]) {
            byte[] b1 = (byte[])o;
            byte[] b2 = new byte[b1.length];
            System.arraycopy(b1, 0, b2, 0, b1.length);
            return b2;
        }
        throw new MessageFormatException(String.format("Unable to cast the object, %s, into the specified type %s", o, "byte[]"));
    }

    public Object getObject(String name) throws JMSException {
        Serializable o = this.data.get(name);
        if (o == null) {
            return null;
        }
        if (o instanceof byte[]) {
            return this.getBytes(name);
        }
        return o;
    }

    public Enumeration<String> getMapNames() throws JMSException {
        return new IteratorEnum<String>(this.data.keySet().iterator());
    }

    public void setBoolean(String name, boolean value) throws JMSException {
        this.checkNotReadonlyBody();
        this.data.put(name, Boolean.valueOf(value));
    }

    public void setByte(String name, byte value) throws JMSException {
        this.checkNotReadonlyBody();
        this.data.put(name, Byte.valueOf(value));
    }

    public void setShort(String name, short value) throws JMSException {
        this.checkNotReadonlyBody();
        this.data.put(name, Short.valueOf(value));
    }

    public void setChar(String name, char value) throws JMSException {
        this.checkNotReadonlyBody();
        this.data.put(name, Character.valueOf(value));
    }

    public void setInt(String name, int value) throws JMSException {
        this.checkNotReadonlyBody();
        this.data.put(name, Integer.valueOf(value));
    }

    public void setLong(String name, long value) throws JMSException {
        this.checkNotReadonlyBody();
        this.data.put(name, Long.valueOf(value));
    }

    public void setFloat(String name, float value) throws JMSException {
        this.checkNotReadonlyBody();
        this.data.put(name, Float.valueOf(value));
    }

    public void setDouble(String name, double value) throws JMSException {
        this.checkNotReadonlyBody();
        this.data.put(name, Double.valueOf(value));
    }

    public void setString(String name, String value) throws JMSException {
        this.checkNotReadonlyBody();
        this.data.put(name, (Serializable)((Object)value));
    }

    public void setBytes(String name, byte[] value) throws JMSException {
        this.checkNotReadonlyBody();
        this.setBytes(name, value, 0, value.length);
    }

    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        this.checkNotReadonlyBody();
        if (value == null) {
            this.data.remove(name);
            return;
        }
        byte[] buf = new byte[length];
        System.arraycopy(value, offset, buf, 0, length);
        this.data.put(name, (Serializable)buf);
    }

    public void setObject(String name, Object value) throws JMSException {
        this.checkNotReadonlyBody();
        if (name != null || value != null) {
            if (value == null) {
                this.data.remove(name);
            } else {
                if (!(value instanceof Serializable)) {
                    throw new MessageFormatException(String.format("Unable to cast the object, %s, into the specified type %s", value, Serializable.class.getName()));
                }
                try {
                    this.writePrimitiveData(value, new DiscardingObjectOutput(), false);
                }
                catch (IOException x) {
                    throw new RMQMessageFormatException(x);
                }
            }
        }
        if (value instanceof byte[]) {
            this.setBytes(name, (byte[])value);
        } else {
            this.data.put(name, (Serializable)value);
        }
    }

    public boolean itemExists(String name) throws JMSException {
        return this.data.containsKey(name);
    }

    @Override
    public void clearBodyInternal() throws JMSException {
        this.data.clear();
    }

    @Override
    protected void writeBody(ObjectOutput out, ByteArrayOutputStream bout) throws IOException {
        int size = this.data.size();
        out.writeInt(size);
        for (Map.Entry<String, Serializable> entry : this.data.entrySet()) {
            out.writeUTF(entry.getKey());
            try {
                RMQMessage.writePrimitive(entry.getValue(), out);
            }
            catch (MessageFormatException x) {
                throw new IOException(x);
            }
        }
    }

    @Override
    protected void readBody(ObjectInput inputStream, ByteArrayInputStream bin) throws IOException, ClassNotFoundException {
        int size = inputStream.readInt();
        for (int i = 0; i < size; ++i) {
            String name = inputStream.readUTF();
            Object value = RMQMessage.readPrimitive(inputStream);
            this.data.put(name, (Serializable)value);
        }
    }

    @Override
    protected void readAmqpBody(byte[] barr) {
        throw new UnsupportedOperationException();
    }

    private void writePrimitiveData(Object s, ObjectOutput out, boolean allowSerializable) throws IOException, MessageFormatException {
        if (s == null) {
            throw new NullPointerException();
        }
        if (s instanceof Boolean) {
            out.writeBoolean((Boolean)s);
        } else if (s instanceof Byte) {
            out.writeByte(((Byte)s).byteValue());
        } else if (s instanceof Short) {
            out.writeShort(((Short)s).shortValue());
        } else if (s instanceof Integer) {
            out.writeInt((Integer)s);
        } else if (s instanceof Long) {
            out.writeLong((Long)s);
        } else if (s instanceof Float) {
            out.writeFloat(((Float)s).floatValue());
        } else if (s instanceof Double) {
            out.writeDouble((Double)s);
        } else if (s instanceof String) {
            out.writeUTF((String)s);
        } else if (s instanceof Character) {
            out.writeChar(((Character)s).charValue());
        } else if (s instanceof Character) {
            out.writeChar(((Character)s).charValue());
        } else if (allowSerializable && s instanceof Serializable) {
            out.writeObject(s);
        } else if (s instanceof byte[]) {
            out.write((byte[])s);
        } else {
            throw new MessageFormatException(s + " is not a recognized primitive type.");
        }
    }

    private void checkNotReadonlyBody() throws JMSException {
        if (this.isReadonlyBody()) {
            throw new MessageNotWriteableException("Message not writeable");
        }
    }

    @Override
    protected void writeAmqpBody(ByteArrayOutputStream out) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static final RMQMessage recreate(MapMessage msg) throws JMSException {
        RMQMapMessage rmqMMsg = new RMQMapMessage();
        RMQMessage.copyAttributes(rmqMMsg, (Message)msg);
        RMQMapMessage.copyMapObjects(rmqMMsg, msg);
        return rmqMMsg;
    }

    private static final void copyMapObjects(RMQMapMessage rmqMsg, MapMessage msg) throws JMSException {
        Enumeration mapNames = msg.getMapNames();
        while (mapNames.hasMoreElements()) {
            String name = (String)mapNames.nextElement();
            rmqMsg.setObject(name, msg.getObject(name));
        }
    }
}

